/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.Recycler;
import io.github.lukehutch.fastclasspathscanner.utils.SingletonMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NestedJarHandler
implements AutoCloseable {
    private final ConcurrentLinkedDeque<File> tempFiles = new ConcurrentLinkedDeque();
    private final SingletonMap<String, File> nestedPathToJarfileMap;
    private final SingletonMap<String, Recycler<ZipFile, IOException>> canonicalPathToZipFileRecyclerMap;
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;

    public NestedJarHandler(final InterruptionChecker interruptionChecker, final LogNode log) {
        this.interruptionChecker = interruptionChecker;
        this.log = log;
        this.canonicalPathToZipFileRecyclerMap = new SingletonMap<String, Recycler<ZipFile, IOException>>(){

            @Override
            public Recycler<ZipFile, IOException> newInstance(final String canonicalPath) throws Exception {
                return new Recycler<ZipFile, IOException>(){

                    @Override
                    public ZipFile newInstance() throws IOException {
                        return new ZipFile(canonicalPath);
                    }
                };
            }
        };
        this.nestedPathToJarfileMap = new SingletonMap<String, File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File newInstance(String nestedJarPath) throws Exception {
                int lastPlingIdx = nestedJarPath.lastIndexOf(33);
                if (lastPlingIdx < 0) {
                    File canonicalFile;
                    File pathFile = new File(nestedJarPath);
                    try {
                        canonicalFile = pathFile.getCanonicalFile();
                    }
                    catch (IOException e) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component could not be canonicalized: " + nestedJarPath, (Throwable)e);
                        }
                        return null;
                    }
                    if (!canonicalFile.exists()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component does not exist: " + nestedJarPath);
                        }
                        return null;
                    }
                    if (!canonicalFile.isFile()) {
                        if (log != null) {
                            log.log(nestedJarPath, "Path component is not a file: " + nestedJarPath);
                        }
                        return null;
                    }
                    if (!JarUtils.isJar(canonicalFile.getPath())) {
                        if (log != null) {
                            log.log(nestedJarPath, "Ignoring classpath element with non-jar path component: " + nestedJarPath);
                        }
                        return null;
                    }
                    return canonicalFile;
                }
                String parentPath = nestedJarPath.substring(0, lastPlingIdx);
                String childPath = nestedJarPath.substring(lastPlingIdx + 1);
                if (childPath.startsWith("/")) {
                    childPath = childPath.substring(1);
                }
                if (!JarUtils.isJar(childPath)) {
                    if (log != null) {
                        log.log(nestedJarPath, "Ignoring classpath element with non-jar path component: " + nestedJarPath);
                    }
                    return null;
                }
                File parentJarfile = (File)NestedJarHandler.this.nestedPathToJarfileMap.getOrCreateSingleton(parentPath);
                if (parentJarfile == null) {
                    return null;
                }
                if (!parentJarfile.getPath().equals(parentPath)) {
                    return (File)NestedJarHandler.this.nestedPathToJarfileMap.getOrCreateSingleton(parentJarfile.getPath() + "!" + childPath);
                }
                Recycler parentJarRecycler = (Recycler)NestedJarHandler.this.canonicalPathToZipFileRecyclerMap.getOrCreateSingleton(parentJarfile.getCanonicalPath());
                ZipFile parentZipFile = null;
                try {
                    parentZipFile = (ZipFile)parentJarRecycler.acquire();
                    ZipEntry childZipEntry = parentZipFile.getEntry(childPath);
                    if (childZipEntry == null) {
                        if (log != null) {
                            log.log(nestedJarPath, "Child path component " + childPath + " does not exist in jarfile " + parentPath);
                        }
                        File file = null;
                        return file;
                    }
                    File childTempFile = NestedJarHandler.this.unzipToTempFile(parentZipFile, childZipEntry);
                    if (interruptionChecker.checkAndReturn()) {
                        File file = null;
                        return file;
                    }
                    File file = childTempFile;
                    return file;
                }
                finally {
                    parentJarRecycler.release(parentZipFile);
                }
            }
        };
    }

    public File getNestedJarfile(String nestedJarfilePath) {
        block3: {
            try {
                return this.nestedPathToJarfileMap.getOrCreateSingleton(nestedJarfilePath);
            }
            catch (InterruptedException e) {
                this.interruptionChecker.interrupt();
            }
            catch (Exception e) {
                if (this.log == null) break block3;
                this.log.log("Exception while creating singleton", e);
            }
        }
        return null;
    }

    public Recycler<ZipFile, IOException> getZipFileRecycler(String canonicalPath) {
        block3: {
            try {
                return this.canonicalPathToZipFileRecyclerMap.getOrCreateSingleton(canonicalPath);
            }
            catch (InterruptedException e) {
                this.interruptionChecker.interrupt();
            }
            catch (Exception e) {
                if (this.log == null) break block3;
                this.log.log("Exception while creating singleton", e);
            }
        }
        return null;
    }

    public File getInnermostNestedJar(String nestedJarPath) {
        block3: {
            try {
                return this.nestedPathToJarfileMap.getOrCreateSingleton(nestedJarPath);
            }
            catch (InterruptedException e) {
                this.interruptionChecker.interrupt();
            }
            catch (Exception e) {
                if (this.log == null) break block3;
                this.log.log("Exception while creating singleton", e);
            }
        }
        return null;
    }

    public File unzipToTempFile(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        String zipEntryPath = zipEntry.getName();
        String leafName = zipEntryPath.substring(zipEntryPath.lastIndexOf(47) + 1);
        File tempFile = File.createTempFile("FastClasspathScanner-", "-" + leafName);
        tempFile.deleteOnExit();
        this.tempFiles.add(tempFile);
        if (this.log != null) {
            String qualifiedPath = zipFile.getName() + "!" + zipEntryPath;
            LogNode subLog = this.log.log(qualifiedPath, "Unzipping zip entry " + qualifiedPath);
            subLog.log("Writing temporary file " + tempFile.getPath());
        }
        Files.copy(zipFile.getInputStream(zipEntry), tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tempFile;
    }

    @Override
    public void close() {
        while (!this.tempFiles.isEmpty()) {
            File head = this.tempFiles.remove();
            String string = head.getPath();
            boolean bl = head.delete();
        }
        try {
            for (Recycler recycler : this.canonicalPathToZipFileRecyclerMap.values()) {
                recycler.close();
            }
        }
        catch (InterruptedException e) {
            this.interruptionChecker.interrupt();
        }
    }
}

