/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner;

import io.github.lukehutch.fastclasspathscanner.MatchProcessorException;
import io.github.lukehutch.fastclasspathscanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.scanner.Scanner;
import io.github.lukehutch.fastclasspathscanner.utils.AutoCloseableExecutorService;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.VersionFinder;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class FastClasspathScanner {
    private final String[] scanSpecArgs;
    private ScanSpec scanSpec;
    private List<File> classpathElts;
    private static String version;
    private static final int DEFAULT_NUM_WORKER_THREADS = 6;
    private LogNode log;

    public FastClasspathScanner(String ... scanSpec) {
        this.scanSpecArgs = scanSpec;
    }

    public static final String getVersion() {
        if (version == null) {
            version = VersionFinder.getVersion();
        }
        return version;
    }

    private synchronized ScanSpec getScanSpec() {
        if (this.scanSpec == null) {
            this.scanSpec = new ScanSpec(this.scanSpecArgs, this.log == null ? null : this.log.log("Parsing scan spec"));
        }
        return this.scanSpec;
    }

    public FastClasspathScanner verbose(boolean verbose) {
        if (verbose) {
            if (this.log == null) {
                this.log = new LogNode();
            }
        } else {
            this.log = null;
        }
        return this;
    }

    public FastClasspathScanner verbose() {
        this.verbose(true);
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility(boolean ignoreFieldVisibility) {
        this.getScanSpec().ignoreFieldVisibility = ignoreFieldVisibility;
        return this;
    }

    public FastClasspathScanner ignoreFieldVisibility() {
        this.ignoreFieldVisibility(true);
        return this;
    }

    public FastClasspathScanner ignoreMethodVisibility(boolean ignoreMethodVisibility) {
        this.getScanSpec().ignoreMethodVisibility = ignoreMethodVisibility;
        return this;
    }

    public FastClasspathScanner ignoreMethodVisibility() {
        this.ignoreMethodVisibility(true);
        return this;
    }

    public FastClasspathScanner enableFieldTypeIndexing(boolean enableFieldTypeIndexing) {
        this.getScanSpec().enableFieldTypeIndexing = enableFieldTypeIndexing;
        return this;
    }

    public FastClasspathScanner enableFieldTypeIndexing() {
        this.enableFieldTypeIndexing(true);
        return this;
    }

    public FastClasspathScanner enableMethodAnnotationIndexing(boolean enableMethodAnnotationIndexing) {
        this.getScanSpec().enableMethodAnnotationIndexing = enableMethodAnnotationIndexing;
        return this;
    }

    public FastClasspathScanner enableMethodAnnotationIndexing() {
        this.enableMethodAnnotationIndexing(true);
        return this;
    }

    public FastClasspathScanner strictWhitelist(boolean strictWhitelist) {
        this.getScanSpec().strictWhitelist = strictWhitelist;
        return this;
    }

    public FastClasspathScanner strictWhitelist() {
        this.strictWhitelist(true);
        return this;
    }

    public FastClasspathScanner initializeLoadedClasses(boolean initializeLoadedClasses) {
        this.getScanSpec().initializeLoadedClasses = initializeLoadedClasses;
        return this;
    }

    public FastClasspathScanner removeTemporaryFilesAfterScan(boolean removeTemporaryFilesAfterScan) {
        this.getScanSpec().removeTemporaryFilesAfterScan = removeTemporaryFilesAfterScan;
        return this;
    }

    public FastClasspathScanner disableRecursiveScanning() {
        return this.disableRecursiveScanning(true);
    }

    public FastClasspathScanner disableRecursiveScanning(boolean disableRecursiveScanning) {
        this.getScanSpec().disableRecursiveScanning = disableRecursiveScanning;
        return this;
    }

    public FastClasspathScanner registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandlerClass) {
        this.getScanSpec().registerClassLoaderHandler(classLoaderHandlerClass);
        return this;
    }

    public FastClasspathScanner overrideClasspath(String overrideClasspath) {
        this.getScanSpec().overrideClasspath(overrideClasspath);
        return this;
    }

    public FastClasspathScanner overrideClasspath(Iterable<?> overrideClasspathElements) {
        StringBuilder buf = new StringBuilder();
        for (Object classpathElt : overrideClasspathElements) {
            if (classpathElt == null) continue;
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(classpathElt);
        }
        String overrideClasspath = buf.toString();
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public FastClasspathScanner overrideClasspath(Object ... overrideClasspathElements) {
        StringBuilder buf = new StringBuilder();
        for (Object classpathElt : overrideClasspathElements) {
            if (classpathElt == null) continue;
            if (buf.length() > 0) {
                buf.append(File.pathSeparatorChar);
            }
            buf.append(classpathElt);
        }
        String overrideClasspath = buf.toString();
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public FastClasspathScanner addClassLoader(ClassLoader classLoader) {
        this.getScanSpec().addClassLoader(classLoader);
        return this;
    }

    public FastClasspathScanner overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.getScanSpec().overrideClassLoaders(overrideClassLoaders);
        return this;
    }

    public FastClasspathScanner matchAllClasses(ClassMatchProcessor classMatchProcessor) {
        this.getScanSpec().matchAllClasses(classMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchAllStandardClasses(ClassMatchProcessor standardClassMatchProcessor) {
        this.getScanSpec().matchAllStandardClasses(standardClassMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchAllInterfaceClasses(ClassMatchProcessor interfaceClassMatchProcessor) {
        this.getScanSpec().matchAllInterfaceClasses(interfaceClassMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchAllAnnotationClasses(ClassMatchProcessor annotationClassMatchProcessor) {
        this.getScanSpec().matchAllAnnotationClasses(annotationClassMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchSubclassesOf(Class<T> superclass, SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.getScanSpec().matchSubclassesOf(superclass, subclassMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchSubinterfacesOf(Class<T> superinterface, SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.getScanSpec().matchSubinterfacesOf(superinterface, subinterfaceMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchClassesImplementing(Class<T> implementedInterface, ImplementingClassMatchProcessor<T> interfaceMatchProcessor) {
        this.getScanSpec().matchClassesImplementing(implementedInterface, interfaceMatchProcessor);
        return this;
    }

    public <T> FastClasspathScanner matchClassesWithFieldOfType(Class<T> fieldType, ClassMatchProcessor classMatchProcessor) {
        this.enableFieldTypeIndexing();
        this.getScanSpec().matchClassesWithFieldOfType(fieldType, classMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchClassesWithAnnotation(Class<?> annotation, ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.getScanSpec().matchClassesWithAnnotation(annotation, classAnnotationMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchClassesWithMethodAnnotation(Class<? extends Annotation> annotation, MethodAnnotationMatchProcessor methodAnnotationMatchProcessor) {
        this.enableMethodAnnotationIndexing();
        this.getScanSpec().matchClassesWithMethodAnnotation(annotation, methodAnnotationMatchProcessor);
        return this;
    }

    public FastClasspathScanner setAnnotationVisibility(RetentionPolicy annotationVisibility) {
        if (annotationVisibility == RetentionPolicy.SOURCE) {
            throw new IllegalArgumentException("RetentionPolicy.SOURCE annotations are not retained in classfiles");
        }
        this.getScanSpec().annotationVisibility = annotationVisibility;
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldName, staticFinalFieldMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        this.getScanSpec().matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNames, staticFinalFieldMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePattern(pathRegexp, fileMatchContentsProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePath(relativePathToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenamePathLeaf(pathLeafToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchContentsProcessor);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchProcessorWithContext);
        return this;
    }

    public FastClasspathScanner matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.getScanSpec().matchFilenameExtension(extensionToMatch, fileMatchContentsProcessorWithContext);
        return this;
    }

    private Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks, boolean asyncMode) {
        if (asyncMode) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StackTraceElement[] elts;
                for (StackTraceElement elt : elts = e.getStackTrace()) {
                    if (!"<clinit>".equals(elt.getMethodName())) continue;
                    throw new RuntimeException("Cannot launch FastClasspathScanner asynchronously during class initialization (for class " + elt.getClassName() + ") -- this can lead to a deadlock. See: https://github.com/lukehutch/fast-classpath-scanner/issues/103");
                }
            }
        }
        ScanSpec scanSpec = this.getScanSpec();
        return executorService.submit(new Scanner(scanSpec, executorService, numParallelTasks, true, scanSpec.removeTemporaryFilesAfterScan, asyncMode, this.log));
    }

    public Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        return this.scanAsync(executorService, numParallelTasks, true);
    }

    public ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            ScanResult scanResult = this.scanAsync(executorService, numParallelTasks, false).get();
            this.getScanSpec().callMatchProcessors(scanResult, null, this.log);
            ScanResult scanResult2 = scanResult;
            return scanResult2;
        }
        catch (InterruptedException e) {
            if (this.log != null) {
                this.log.log("Scan interrupted");
            }
            throw new ScanInterruptedException();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                if (this.log != null) {
                    this.log.log("Scan interrupted");
                }
                throw new ScanInterruptedException();
            }
            if (e.getCause() instanceof MatchProcessorException) {
                if (this.log != null) {
                    this.log.log("Exception during scan", e);
                }
                throw (MatchProcessorException)e.getCause();
            }
            if (this.log != null) {
                this.log.log("Unexpected exception during scan", e);
            }
            throw new RuntimeException(e.getCause());
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public ScanResult scan(int numThreads) {
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            ScanResult scanResult = this.scan(executorService, numThreads);
            return scanResult;
        }
    }

    public ScanResult scan() {
        return this.scan(6);
    }

    public Future<List<File>> getUniqueClasspathElementsAsync(ExecutorService executorService, int numParallelTasks) {
        final Future<ScanResult> scanResult = executorService.submit(new Scanner(this.getScanSpec(), executorService, numParallelTasks, false, false, false, this.log == null ? null : this.log.log("Getting unique classpath elements")));
        Future<List<File>> future = executorService.submit(new Callable<List<File>>(){

            @Override
            public List<File> call() throws Exception {
                if (FastClasspathScanner.this.log != null) {
                    FastClasspathScanner.this.log.log("Getting classpath elements");
                }
                return ((ScanResult)scanResult.get()).getUniqueClasspathElements();
            }
        });
        if (this.log != null) {
            this.log.flush();
        }
        return future;
    }

    public List<File> getUniqueClasspathElements(ExecutorService executorService, int numParallelTasks) {
        if (this.classpathElts == null) {
            try {
                this.classpathElts = this.getUniqueClasspathElementsAsync(executorService, numParallelTasks).get();
            }
            catch (InterruptedException e) {
                if (this.log != null) {
                    this.log.log("Thread interrupted while getting classpath elements");
                }
                throw new ScanInterruptedException();
            }
            catch (ExecutionException e) {
                if (this.log != null) {
                    this.log.log("Exception while getting classpath elements", e);
                }
                throw new RuntimeException(e.getCause());
            }
            if (this.log != null) {
                this.log.flush();
            }
        }
        return this.classpathElts;
    }

    public List<File> getUniqueClasspathElements() {
        if (this.classpathElts == null) {
            try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(6);){
                List<File> list = this.getUniqueClasspathElements(executorService, 6);
                return list;
            }
        }
        return this.classpathElts;
    }
}

