/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FastManifestParser {
    public boolean isSystemJar;
    public ArrayList<String> classPath;
    public static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    private void parseManifest(ZipFile zipFile, ZipEntry manifestEntry) throws IOException {
        if (manifestEntry != null) {
            try (InputStream inputStream = zipFile.getInputStream(manifestEntry);){
                int bytesRead;
                ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
                byteBuf.write(10);
                byte[] data = new byte[16384];
                while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
                    byteBuf.write(data, 0, bytesRead);
                }
                byteBuf.flush();
                String manifest = byteBuf.toString("UTF-8");
                int len = manifest.length();
                this.isSystemJar = manifest.indexOf("\nImplementation-Title: Java Runtime Environment") > 0 || manifest.indexOf("\nSpecification-Title: Java Platform API Specification") > 0;
                int classPathIdx = manifest.indexOf("\nClass-Path:");
                if (classPathIdx >= 0) {
                    StringBuilder buf = new StringBuilder();
                    int curr = classPathIdx + 12;
                    if (curr < len && manifest.charAt(curr) == ' ') {
                        ++curr;
                    }
                    while (curr < len) {
                        char c = manifest.charAt(curr);
                        if (c == '\r' && (curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) == 10) {
                            if ((curr < len - 2 ? (int)manifest.charAt(curr + 2) : 10) != 32) break;
                            curr += 2;
                        } else if (c == '\r') {
                            if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                            ++curr;
                        } else if (c == '\n') {
                            if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                            ++curr;
                        } else {
                            buf.append(c);
                        }
                        ++curr;
                    }
                    String classPath = buf.toString();
                    for (String classPathEntry : classPath.split(" ")) {
                        if (classPathEntry.isEmpty()) continue;
                        if (this.classPath == null) {
                            this.classPath = new ArrayList();
                        }
                        this.classPath.add(classPathEntry);
                    }
                }
            }
        }
    }

    public FastManifestParser(ZipFile zipFile, ZipEntry manifestEntry, LogNode log) {
        block2: {
            try {
                this.parseManifest(zipFile, manifestEntry);
            }
            catch (IOException e) {
                if (log == null) break block2;
                log.log("Exception while opening manifest in jarfile " + zipFile, e);
            }
        }
    }

    public FastManifestParser(ZipFile zipFile, LogNode log) {
        this(zipFile, zipFile.getEntry(MANIFEST_PATH), log);
    }

    public FastManifestParser(File jarFile, LogNode log) {
        block14: {
            try (ZipFile zipFile = new ZipFile(jarFile);){
                this.parseManifest(zipFile, zipFile.getEntry(MANIFEST_PATH));
            }
            catch (IOException e) {
                if (log == null) break block14;
                log.log("Exception while opening jarfile " + jarFile, e);
            }
        }
    }
}

