/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.CdoSnapshotState;
import org.javers.core.metamodel.object.CdoSnapshotStateBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.type.ManagedType;

public class CdoSnapshotBuilder {
    private GlobalId globalId;
    private CommitMetadata commitMetadata;
    private SnapshotType type = SnapshotType.UPDATE;
    private CdoSnapshotState state;
    private CdoSnapshotStateBuilder stateBuilder = CdoSnapshotStateBuilder.cdoSnapshotState();
    private CdoSnapshot previous;
    private boolean markAllAsChanged;
    private List<String> changed = Collections.emptyList();
    private ManagedType managedType;
    private long version;

    private CdoSnapshotBuilder() {
    }

    public static CdoSnapshot emptyCopyOf(CdoSnapshot snapshot) {
        return CdoSnapshotBuilder.cdoSnapshot().withGlobalId(snapshot.getGlobalId()).withManagedType(snapshot.getManagedType()).withCommitMetadata(snapshot.getCommitMetadata()).withType(snapshot.getType()).build();
    }

    public static CdoSnapshotBuilder cdoSnapshot() {
        return new CdoSnapshotBuilder();
    }

    public CdoSnapshotBuilder withGlobalId(GlobalId globalId) {
        this.globalId = globalId;
        return this;
    }

    public CdoSnapshotBuilder withManagedType(ManagedType managedType) {
        this.managedType = managedType;
        return this;
    }

    public CdoSnapshotBuilder withCommitMetadata(CommitMetadata commitMetadata) {
        this.commitMetadata = commitMetadata;
        return this;
    }

    public CdoSnapshotBuilder withState(CdoSnapshotState state) {
        Validate.argumentIsNotNull(state);
        this.state = state;
        return this;
    }

    public CdoSnapshotBuilder withVersion(Long version) {
        this.version = version == null ? 0L : version;
        return this;
    }

    public CdoSnapshot build() {
        if (this.state == null) {
            this.state = this.stateBuilder.build();
        }
        if (this.previous != null) {
            this.changed = this.state.differentValues(this.previous.getState());
        }
        if (this.markAllAsChanged) {
            this.changed = new ArrayList<String>(this.state.getProperties());
        }
        return new CdoSnapshot(this.globalId, this.commitMetadata, this.state, this.type, this.changed, this.managedType, this.version);
    }

    public CdoSnapshotBuilder withType(SnapshotType type) {
        Validate.argumentIsNotNull((Object)type);
        this.type = type;
        return this;
    }

    public CdoSnapshotBuilder markAllAsChanged() {
        this.markAllAsChanged = true;
        return this;
    }

    public CdoSnapshotBuilder withChangedProperties(List<String> changedPropertyNames) {
        this.changed = new ArrayList<String>(changedPropertyNames);
        return this;
    }

    public CdoSnapshotBuilder markChanged(CdoSnapshot previous) {
        this.previous = previous;
        return this;
    }
}

