/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;

public abstract class JaversMember<T extends Member> {
    private final T rawMember;
    private final Optional<Type> resolvedReturnType;

    public JaversMember(T rawMember, Type resolvedReturnType) {
        Validate.argumentIsNotNull(rawMember);
        this.rawMember = rawMember;
        this.resolvedReturnType = Optional.ofNullable(resolvedReturnType);
    }

    protected abstract Type getRawGenericType();

    public abstract Class<?> getRawType();

    public T getRawMember() {
        return this.rawMember;
    }

    public Type getGenericResolvedType() {
        if (this.resolvedReturnType.isPresent()) {
            return this.resolvedReturnType.get();
        }
        return this.getRawGenericType();
    }

    public Class<?> getDeclaringClass() {
        return this.rawMember.getDeclaringClass();
    }

    public String name() {
        return this.rawMember.getName();
    }

    public String propertyName() {
        return this.rawMember.getName();
    }

    public boolean hasAnyAnnotation(Set<String> annotationNames) {
        return this.findFirst(annotationNames).isPresent();
    }

    public Optional<Annotation> findFirst(Set<String> annotationNames) {
        return ReflectionUtil.findFirst((AccessibleObject)this.rawMember, annotationNames);
    }

    public Optional<String> getFirstValue(Set<String> annotationNames) {
        return this.findFirst(annotationNames).map(a -> (String)ReflectionUtil.getAnnotationValue(a, "value"));
    }

    public abstract Object invokeEvenIfPrivate(Object var1);

    protected void setAccessibleIfNecessary() {
        if (!this.isPublic((Member)this.rawMember)) {
            ((AccessibleObject)this.rawMember).setAccessible(true);
        }
    }

    private boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversMember that = (JaversMember)o;
        return this.rawMember.equals(that.rawMember) && this.resolvedReturnType.equals(that.resolvedReturnType);
    }

    public int hashCode() {
        return this.rawMember.hashCode() + this.resolvedReturnType.hashCode();
    }
}

