/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;

public abstract class ManagedType
extends JaversType {
    private final ManagedClass managedClass;

    ManagedType(ManagedClass managedClass) {
        this(managedClass, Optional.empty());
    }

    ManagedType(ManagedClass managedClass, Optional<String> typeName) {
        super(managedClass.getBaseJavaClass(), typeName);
        this.managedClass = managedClass;
    }

    abstract ManagedType spawn(ManagedClass var1, Optional<String> var2);

    @Override
    protected Type getRawDehydratedType() {
        return GlobalId.class;
    }

    @Override
    protected PrettyPrintBuilder prettyPrintBuilder() {
        return super.prettyPrintBuilder().addMultiField("managedProperties", this.managedClass.getManagedProperties());
    }

    public Property getProperty(String propertyName) {
        return this.managedClass.getProperty(propertyName);
    }

    public List<Property> getProperties(Predicate<Property> query) {
        return this.managedClass.getManagedProperties(query);
    }

    public List<Property> getProperties() {
        return this.managedClass.getManagedProperties();
    }

    public Set<String> getPropertyNames() {
        return this.managedClass.getPropertyNames();
    }

    ManagedClass getManagedClass() {
        return this.managedClass;
    }
}

