/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.javers.common.collections.Arrays;
import org.javers.common.validation.Validate;

public class Lists {
    public static List wrapNull(Object list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return (List)list;
    }

    public static <T> List<T> immutableListOf(T ... elements) {
        return Collections.unmodifiableList(java.util.Arrays.asList(elements));
    }

    public static <E> List<E> asList(E ... elements) {
        return Arrays.asList(elements);
    }

    public static <T> Map<Integer, T> asMap(List<T> input) {
        if (input == null) {
            return null;
        }
        HashMap<Integer, T> result = new HashMap<Integer, T>();
        int i = 0;
        for (T element : input) {
            result.put(i, element);
            ++i;
        }
        return result;
    }

    public static <T> List<T> positiveFilter(List<T> input, Predicate<T> filter) {
        Validate.argumentsAreNotNull(input, filter);
        return input.stream().filter(filter).collect(Collectors.toList());
    }

    public static <T> List<T> negativeFilter(List<T> input, Predicate<T> filter) {
        Validate.argumentsAreNotNull(input, filter);
        return input.stream().filter(element -> !filter.test(element)).collect(Collectors.toList());
    }

    public static <F, T> List<T> transform(Collection<F> input, Function<F, T> transformation) {
        Validate.argumentsAreNotNull(input, transformation);
        return input.stream().map(transformation::apply).collect(Collectors.toList());
    }

    public static <E> List<E> difference(List<E> first, List<E> second) {
        if (first == null) {
            return Collections.EMPTY_LIST;
        }
        if (second == null) {
            return first;
        }
        ArrayList<E> difference = new ArrayList<E>(first);
        difference.removeAll(second);
        return difference;
    }

    public static <t> Collector<t, List<t>, List<t>> toImmutableList() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableList, new Collector.Characteristics[0]);
    }
}

