/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationEnumValue;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import java.lang.reflect.Array;
import java.util.Set;

class ObjectTypedValueWrapper
extends ScanResultObject {
    private AnnotationEnumValue enumValue;
    private AnnotationClassRef classRef;
    private AnnotationInfo annotationInfo;
    private ObjectTypedValueWrapper[] valueArray;
    private String stringValue;
    private Integer integerValue;
    private Long longValue;
    private Short shortValue;
    private Boolean booleanValue;
    private Character characterValue;
    private Float floatValue;
    private Double doubleValue;
    private Byte byteValue;

    public ObjectTypedValueWrapper() {
    }

    public ObjectTypedValueWrapper(Object annotationParamValue) {
        if (annotationParamValue != null) {
            if (annotationParamValue.getClass().isArray()) {
                int n = Array.getLength(annotationParamValue);
                this.valueArray = new ObjectTypedValueWrapper[n];
                for (int i = 0; i < n; ++i) {
                    this.valueArray[i] = new ObjectTypedValueWrapper(Array.get(annotationParamValue, i));
                }
            } else if (annotationParamValue instanceof AnnotationEnumValue) {
                this.enumValue = (AnnotationEnumValue)annotationParamValue;
            } else if (annotationParamValue instanceof AnnotationClassRef) {
                this.classRef = (AnnotationClassRef)annotationParamValue;
            } else if (annotationParamValue instanceof AnnotationInfo) {
                this.annotationInfo = (AnnotationInfo)annotationParamValue;
            } else if (annotationParamValue instanceof String) {
                this.stringValue = (String)annotationParamValue;
            } else if (annotationParamValue instanceof Integer) {
                this.integerValue = (Integer)annotationParamValue;
            } else if (annotationParamValue instanceof Long) {
                this.longValue = (Long)annotationParamValue;
            } else if (annotationParamValue instanceof Short) {
                this.shortValue = (Short)annotationParamValue;
            } else if (annotationParamValue instanceof Boolean) {
                this.booleanValue = (Boolean)annotationParamValue;
            } else if (annotationParamValue instanceof Character) {
                this.characterValue = (Character)annotationParamValue;
            } else if (annotationParamValue instanceof Float) {
                this.floatValue = (Float)annotationParamValue;
            } else if (annotationParamValue instanceof Double) {
                this.doubleValue = (Double)annotationParamValue;
            } else if (annotationParamValue instanceof Byte) {
                this.byteValue = (Byte)annotationParamValue;
            } else {
                throw new IllegalArgumentException("Unsupported annotation parameter value type: " + annotationParamValue.getClass().getName());
            }
        }
    }

    public Object get() {
        if (this.valueArray != null) {
            Object[] annotationValueObjects = new Object[this.valueArray.length];
            for (int i = 0; i < this.valueArray.length; ++i) {
                if (this.valueArray[i] == null) continue;
                annotationValueObjects[i] = this.valueArray[i].get();
            }
            return annotationValueObjects;
        }
        if (this.enumValue != null) {
            return this.enumValue;
        }
        if (this.classRef != null) {
            return this.classRef;
        }
        if (this.annotationInfo != null) {
            return this.annotationInfo;
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.integerValue != null) {
            return this.integerValue;
        }
        if (this.longValue != null) {
            return this.longValue;
        }
        if (this.shortValue != null) {
            return this.shortValue;
        }
        if (this.booleanValue != null) {
            return this.booleanValue;
        }
        if (this.characterValue != null) {
            return this.characterValue;
        }
        if (this.floatValue != null) {
            return this.floatValue;
        }
        if (this.doubleValue != null) {
            return this.doubleValue;
        }
        if (this.byteValue != null) {
            return this.byteValue;
        }
        return null;
    }

    @Override
    protected String getClassName() {
        throw new IllegalArgumentException("getClassName() cannot be called here");
    }

    @Override
    protected ClassInfo getClassInfo() {
        throw new IllegalArgumentException("getClassInfo() cannot be called here");
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.enumValue != null) {
            this.enumValue.setScanResult(scanResult);
        } else if (this.classRef != null) {
            this.classRef.setScanResult(scanResult);
        } else if (this.annotationInfo != null) {
            this.annotationInfo.setScanResult(scanResult);
        } else if (this.valueArray != null) {
            for (int i = 0; i < this.valueArray.length; ++i) {
                if (this.valueArray[i] == null) continue;
                this.valueArray[i].setScanResult(scanResult);
            }
        }
    }

    @Override
    void getClassNamesFromTypeDescriptors(Set<String> referencedClassNames) {
        if (this.enumValue != null) {
            this.enumValue.getClassNamesFromTypeDescriptors(referencedClassNames);
        } else if (this.classRef != null) {
            referencedClassNames.add(this.classRef.getClassName());
        } else if (this.annotationInfo != null) {
            this.annotationInfo.getClassNamesFromTypeDescriptors(referencedClassNames);
        } else if (this.valueArray != null) {
            for (ObjectTypedValueWrapper item : this.valueArray) {
                item.getClassNamesFromTypeDescriptors(referencedClassNames);
            }
        }
    }
}

