/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.Resource;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;

class ClassGraphClassLoader
extends ClassLoader {
    private final ScanResult scanResult;

    ClassGraphClassLoader(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException, LinkageError, ExceptionInInitializerError, SecurityException {
        ResourceList classfileResources;
        Object object;
        ClassInfo classInfo = this.scanResult.getClassInfo(className);
        if (classInfo != null) {
            ClassLoader[] classLoaders = classInfo.classLoaders;
            if (classLoaders != null) {
                object = classLoaders;
                int n = ((ClassLoader[])object).length;
                for (int i = 0; i < n; ++i) {
                    ClassLoader classLoader = object[i];
                    try {
                        return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, classLoader);
                    }
                    catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                        continue;
                    }
                }
            }
        } else if (this.scanResult.envClassLoaderOrder == null || this.scanResult.envClassLoaderOrder.length == 0) {
            return Class.forName(className);
        }
        if (!(this.scanResult.envClassLoaderOrder == null || classInfo != null && Arrays.equals(classInfo.classLoaders, this.scanResult.envClassLoaderOrder))) {
            for (ClassLoader envClassLoader : this.scanResult.envClassLoaderOrder) {
                try {
                    return Class.forName(className, this.scanResult.scanSpec.initializeLoadedClasses, envClassLoader);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                }
            }
        }
        if ((classfileResources = this.scanResult.getResourcesWithPath(className.replace('.', '/') + ".class")) != null && (object = classfileResources.iterator()).hasNext()) {
            try (Resource resource = (Resource)object.next();){
                byte[] resourceContent = resource.load();
                Class<?> clazz = this.defineClass(className, resourceContent, 0, resourceContent.length);
                return clazz;
            }
        }
        throw new ClassNotFoundException("Classfile for class " + className + " not found");
    }

    @Override
    public URL getResource(String path) {
        ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResource(path);
        }
        return ((Resource)resourceList.get(0)).getURL();
    }

    @Override
    public Enumeration<URL> getResources(String path) throws IOException {
        final ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResources(path);
        }
        return new Enumeration<URL>(){
            int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < resourceList.size();
            }

            @Override
            public URL nextElement() {
                return ((Resource)resourceList.get(this.idx++)).getURL();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        ResourceList resourceList = this.scanResult.getResourcesWithPath(path);
        if (resourceList == null || resourceList.isEmpty()) {
            return super.getResourceAsStream(path);
        }
        try {
            return ((Resource)resourceList.get(0)).open();
        }
        catch (IOException e) {
            return null;
        }
    }
}

