/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.CallStackReader;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.ReflectionUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ClassLoaderAndModuleFinder {
    private final ClassLoader[] classLoaders;
    private final List<ModuleRef> systemModuleRefs;
    private final List<ModuleRef> nonSystemModuleRefs;

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    private static void findLayerOrder(Object layer, Set<Object> layerVisited, Deque<Object> layerOrderOut) {
        if (layerVisited.add(layer)) {
            List parents = (List)ReflectionUtils.invokeMethod(layer, "parents", true);
            if (parents != null) {
                for (int i = 0; i < parents.size(); ++i) {
                    ClassLoaderAndModuleFinder.findLayerOrder(parents.get(i), layerVisited, layerOrderOut);
                }
            }
            layerOrderOut.push(layer);
        }
    }

    private static List<ModuleRef> findModuleRefs(Class<?>[] callStack) {
        Object bootLayer;
        ArrayDeque<Object> layerOrder = null;
        HashSet<Object> layerVisited = new HashSet<Object>();
        for (int i = 0; i < callStack.length; ++i) {
            Object layer;
            Object module = ReflectionUtils.invokeMethod(callStack[i], "getModule", false);
            if (module == null || (layer = ReflectionUtils.invokeMethod(module, "getLayer", true)) == null) continue;
            if (layerOrder == null) {
                layerOrder = new ArrayDeque();
            }
            ClassLoaderAndModuleFinder.findLayerOrder(layer, layerVisited, layerOrder);
        }
        Class<?> moduleLayerClass = null;
        try {
            moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        }
        catch (Throwable module) {
            // empty catch block
        }
        if (moduleLayerClass != null && (bootLayer = ReflectionUtils.invokeStaticMethod(moduleLayerClass, "boot", false)) != null) {
            if (layerOrder == null) {
                layerOrder = new ArrayDeque<Object>();
            }
            ClassLoaderAndModuleFinder.findLayerOrder(bootLayer, layerVisited, layerOrder);
        }
        if (layerOrder != null) {
            HashSet<Object> addedModules = new HashSet<Object>();
            LinkedHashSet moduleRefOrder = new LinkedHashSet();
            for (Object e : layerOrder) {
                Set modules;
                Object configuration = ReflectionUtils.invokeMethod(e, "configuration", true);
                if (configuration == null || (modules = (Set)ReflectionUtils.invokeMethod(configuration, "modules", true)) == null) continue;
                ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
                for (Object module : modules) {
                    Object moduleReference = ReflectionUtils.invokeMethod(module, "reference", true);
                    if (moduleReference == null || !addedModules.add(moduleReference)) continue;
                    modulesInLayer.add(new ModuleRef(moduleReference, e));
                }
                Collections.sort(modulesInLayer);
                moduleRefOrder.addAll(modulesInLayer);
            }
            return new ArrayList<ModuleRef>(moduleRefOrder);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoaderAndModuleFinder(ScanSpec scanSpec, LogNode log) {
        LinkedHashSet<Object> classLoadersUnique;
        LogNode classLoadersFoundLog = null;
        ArrayList<ModuleRef> systemModuleRefs = null;
        ArrayList<ModuleRef> nonSystemModuleRefs = null;
        if (scanSpec == null || scanSpec.overrideClassLoaders == null) {
            Object threadClassLoader;
            block24: {
                classLoadersUnique = new LinkedHashSet();
                ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
                if (systemClassLoader != null) {
                    classLoadersUnique.add(systemClassLoader);
                }
                try {
                    Class<?>[] callStack = CallStackReader.getClassContext();
                    for (int i = callStack.length - 1; i >= 0; --i) {
                        ClassLoader classLoader = callStack[i].getClassLoader();
                        if (classLoader == null) continue;
                        classLoadersUnique.add(classLoader);
                    }
                    List<ModuleRef> allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefs(callStack);
                    systemModuleRefs = new ArrayList<ModuleRef>();
                    nonSystemModuleRefs = new ArrayList<ModuleRef>();
                    for (ModuleRef moduleRef : allModuleRefsList) {
                        if (moduleRef.isSystemModule()) {
                            systemModuleRefs.add(moduleRef);
                            continue;
                        }
                        nonSystemModuleRefs.add(moduleRef);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (log == null) break block24;
                    log.log("Could not get call stack: " + e);
                }
            }
            if ((threadClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
                classLoadersUnique.add(threadClassLoader);
            }
            if (scanSpec != null && scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        HashSet<void> ancestralClassLoaders = new HashSet<void>(classLoadersUnique.size());
        for (Object classLoader : classLoadersUnique) {
            void var10_16;
            ClassLoader classLoader2 = ((ClassLoader)classLoader).getParent();
            while (var10_16 != null) {
                ancestralClassLoaders.add(var10_16);
                ClassLoader classLoader3 = var10_16.getParent();
            }
        }
        ArrayList<Object> classLoaderFinalOrder = new ArrayList<Object>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderFinalOrder.add(classLoader);
        }
        if (scanSpec.overrideClasspath != null) {
            ClassLoader fallbackURLClassLoader = JarUtils.createURLClassLoaderFromPathString(scanSpec.overrideClasspath);
            classLoaderFinalOrder.add(fallbackURLClassLoader);
            if (log != null) {
                log.log("Adding fallback URLClassLoader for overriden classpath: " + fallbackURLClassLoader);
            }
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoaderFinalOrder) {
                classLoadersFoundLog.log("" + classLoader);
            }
        }
        if (log != null) {
            LogNode sysSubLog = log.log("Found system modules:");
            if (systemModuleRefs != null && !systemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : systemModuleRefs) {
                    sysSubLog.log(moduleRef.toString());
                }
            } else {
                sysSubLog.log("[None]");
            }
            LogNode logNode = log.log("Found non-system modules:");
            if (nonSystemModuleRefs != null && !nonSystemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : nonSystemModuleRefs) {
                    logNode.log(moduleRef.toString());
                }
            } else {
                logNode.log("[None]");
            }
        }
        this.classLoaders = classLoaderFinalOrder.toArray(new ClassLoader[0]);
        this.systemModuleRefs = systemModuleRefs;
        this.nonSystemModuleRefs = nonSystemModuleRefs;
    }
}

