/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.Join;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.Parser;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class ClassInfoUnlinked {
    private final String className;
    private final int classModifiers;
    private final boolean isInterface;
    private final boolean isAnnotation;
    private String superclassName;
    private List<String> implementedInterfaces;
    private AnnotationInfoList classAnnotations;
    private String fullyQualifiedDefiningMethodName;
    private List<AbstractMap.SimpleEntry<String, String>> classContainmentEntries;
    private List<AnnotationParameterValue> annotationParamDefaultValues;
    final ClasspathElement classpathElement;
    private FieldInfoList fieldInfoList;
    private MethodInfoList methodInfoList;
    private String typeSignature;

    ClassInfoUnlinked(String className, int classModifiers, boolean isInterface, boolean isAnnotation, ClasspathElement classpathElement) {
        this.className = className;
        this.classModifiers = classModifiers;
        this.isInterface = isInterface;
        this.isAnnotation = isAnnotation;
        this.classpathElement = classpathElement;
    }

    void addTypeSignature(String typeSignature) {
        this.typeSignature = typeSignature;
    }

    void addSuperclass(String superclassName) {
        this.superclassName = superclassName;
    }

    void addImplementedInterface(String interfaceName) {
        if (this.implementedInterfaces == null) {
            this.implementedInterfaces = new ArrayList<String>();
        }
        this.implementedInterfaces.add(interfaceName);
    }

    void addClassAnnotation(AnnotationInfo classAnnotation) {
        if (this.classAnnotations == null) {
            this.classAnnotations = new AnnotationInfoList();
        }
        this.classAnnotations.add(classAnnotation);
    }

    void addFieldInfo(FieldInfo fieldInfo) {
        if (this.fieldInfoList == null) {
            this.fieldInfoList = new FieldInfoList();
        }
        this.fieldInfoList.add(fieldInfo);
    }

    void addMethodInfo(MethodInfo methodInfo) {
        if (this.methodInfoList == null) {
            this.methodInfoList = new MethodInfoList();
        }
        this.methodInfoList.add(methodInfo);
    }

    public void addEnclosingMethod(String fullyQualifiedDefiningMethodName) {
        this.fullyQualifiedDefiningMethodName = fullyQualifiedDefiningMethodName;
    }

    public void addClassContainment(String innerClassName, String outerClassName) {
        if (this.classContainmentEntries == null) {
            this.classContainmentEntries = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        }
        this.classContainmentEntries.add(new AbstractMap.SimpleEntry<String, String>(innerClassName, outerClassName));
    }

    public void addAnnotationParamDefaultValues(List<AnnotationParameterValue> annotationParamDefaultValues) {
        this.annotationParamDefaultValues = annotationParamDefaultValues;
    }

    void link(ScanSpec scanSpec, Map<String, ClassInfo> classNameToClassInfo, LogNode log) {
        ClassInfo classInfo = ClassInfo.addScannedClass(this.className, this.classModifiers, this.isInterface, this.isAnnotation, classNameToClassInfo, this.classpathElement, scanSpec, log);
        if (this.superclassName != null) {
            classInfo.addSuperclass(this.superclassName, classNameToClassInfo);
        }
        if (this.implementedInterfaces != null) {
            for (String interfaceName : this.implementedInterfaces) {
                classInfo.addImplementedInterface(interfaceName, classNameToClassInfo);
            }
        }
        if (this.classAnnotations != null) {
            for (AnnotationInfo classAnnotation : this.classAnnotations) {
                classInfo.addClassAnnotation(classAnnotation, classNameToClassInfo);
            }
        }
        if (this.classContainmentEntries != null) {
            ClassInfo.addClassContainment(this.classContainmentEntries, classNameToClassInfo);
        }
        if (this.annotationParamDefaultValues != null) {
            classInfo.addAnnotationParamDefaultValues(this.annotationParamDefaultValues);
        }
        if (this.fullyQualifiedDefiningMethodName != null) {
            classInfo.addFullyQualifiedDefiningMethodName(this.fullyQualifiedDefiningMethodName);
        }
        if (this.fieldInfoList != null) {
            classInfo.addFieldInfo(this.fieldInfoList, classNameToClassInfo);
        }
        if (this.methodInfoList != null) {
            classInfo.addMethodInfo(this.methodInfoList, classNameToClassInfo);
        }
        if (this.typeSignature != null) {
            classInfo.addTypeSignature(this.typeSignature);
        }
    }

    void logTo(LogNode log) {
        if (log != null) {
            LogNode subLog = log.log("Found " + (this.isAnnotation ? "annotation class" : (this.isInterface ? "interface class" : "class")) + " " + this.className);
            if (this.superclassName != null) {
                subLog.log("Super" + (this.isInterface && !this.isAnnotation ? "interface" : "class") + ": " + this.superclassName);
            }
            if (this.implementedInterfaces != null) {
                subLog.log("Interfaces: " + Join.join(", ", this.implementedInterfaces));
            }
            if (this.classAnnotations != null) {
                subLog.log("Class annotations: " + Join.join(", ", this.classAnnotations));
            }
            if (this.annotationParamDefaultValues != null) {
                subLog.log("Annotation default param values: " + Join.join(", ", this.annotationParamDefaultValues));
            }
            if (this.methodInfoList != null) {
                subLog.log("Method info: " + Join.join(", ", this.methodInfoList));
            }
            if (this.fieldInfoList != null) {
                subLog.log("Field info: " + Join.join(", ", this.fieldInfoList));
            }
            if (this.typeSignature != null) {
                ClassTypeSignature typeSig = null;
                try {
                    typeSig = ClassTypeSignature.parse(this.typeSignature, null);
                }
                catch (Parser.ParseException parseException) {
                    // empty catch block
                }
                subLog.log("Class type signature: " + (typeSig == null ? this.typeSignature : typeSig.toString(this.className, this.classModifiers, this.isAnnotation, this.isInterface)));
            }
        }
    }
}

