/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Recycler<T extends Closeable, E extends Exception>
implements AutoCloseable {
    private final ConcurrentLinkedQueue<T> allocatedInstances = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<T> unusedInstances = new ConcurrentLinkedQueue();

    public abstract T newInstance() throws E;

    public Recyclable acquire() throws E {
        return new Recyclable();
    }

    @Override
    public void close() {
        Closeable allocatedInstance;
        Closeable unusedInstance;
        HashSet<Closeable> closedInstances = new HashSet<Closeable>();
        while ((unusedInstance = (Closeable)this.unusedInstances.poll()) != null) {
            try {
                unusedInstance.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            closedInstances.add(unusedInstance);
        }
        ArrayList<Closeable> unclosedInstances = new ArrayList<Closeable>();
        while ((allocatedInstance = (Closeable)this.allocatedInstances.poll()) != null) {
            if (closedInstances.contains(allocatedInstance)) continue;
            unclosedInstances.add(allocatedInstance);
        }
        this.allocatedInstances.addAll(unclosedInstances);
    }

    public class Recyclable
    implements AutoCloseable {
        private final T instance;

        public Recyclable() throws Exception {
            Closeable recycledInstance = (Closeable)Recycler.this.unusedInstances.poll();
            if (recycledInstance != null) {
                this.instance = recycledInstance;
            } else {
                Object newInstance = Recycler.this.newInstance();
                if (newInstance == null) {
                    throw new RuntimeException("Failed to allocate a new recyclable instance");
                }
                Recycler.this.allocatedInstances.add(newInstance);
                this.instance = newInstance;
            }
        }

        public T get() {
            return this.instance;
        }

        @Override
        public void close() {
            if (this.instance != null) {
                Recycler.this.unusedInstances.add(this.instance);
            }
        }
    }
}

