/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.api;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.common.collections.Lists;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.Change;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.snapshot.SnapshotDiffer;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.PreviousSnapshotsCalculator;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;

public class JaversExtendedRepository
implements JaversRepository {
    private final JaversRepository delegate;
    private final SnapshotDiffer snapshotDiffer;
    private final PreviousSnapshotsCalculator previousSnapshotsCalculator;

    public JaversExtendedRepository(JaversRepository delegate, SnapshotDiffer snapshotDiffer) {
        this.delegate = delegate;
        this.snapshotDiffer = snapshotDiffer;
        this.previousSnapshotsCalculator = new PreviousSnapshotsCalculator(input -> this.getSnapshots((Collection<SnapshotIdentifier>)input));
    }

    public List<Change> getChangeHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, queryParams);
        List<CdoSnapshot> snapshots = this.getStateHistory(globalId, queryParams);
        List<Change> changes = this.getChangesIntroducedBySnapshots(snapshots, queryParams.newObjectChanges());
        return this.filterByPropertyName(changes, queryParams);
    }

    public List<Change> getChangeHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        Validate.argumentsAreNotNull(givenClasses, queryParams);
        List<CdoSnapshot> snapshots = this.getStateHistory(givenClasses, queryParams);
        List<Change> changes = this.getChangesIntroducedBySnapshots(snapshots, queryParams.newObjectChanges());
        return this.filterByPropertyName(changes, queryParams);
    }

    public List<Change> getValueObjectChangeHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path, queryParams);
        List<CdoSnapshot> snapshots = this.getValueObjectStateHistory(ownerEntity, path, queryParams);
        return this.getChangesIntroducedBySnapshots(snapshots, queryParams.newObjectChanges());
    }

    public List<Change> getChanges(boolean newObjects, QueryParams queryParams) {
        Validate.argumentsAreNotNull(queryParams);
        List<CdoSnapshot> snapshots = this.getSnapshots(queryParams);
        return this.getChangesIntroducedBySnapshots(snapshots, queryParams.newObjectChanges());
    }

    @Override
    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Validate.argumentsAreNotNull(globalId, queryParams);
        List<CdoSnapshot> snapshots = this.delegate.getStateHistory(globalId, queryParams);
        if (globalId instanceof InstanceId && queryParams.isAggregate()) {
            return this.loadMasterEntitySnapshotIfNecessary((InstanceId)globalId, snapshots);
        }
        return snapshots;
    }

    @Override
    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        Validate.argumentsAreNotNull(ownerEntity, path, queryParams);
        return this.delegate.getValueObjectStateHistory(ownerEntity, path, queryParams);
    }

    @Override
    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Validate.argumentIsNotNull(globalId);
        return this.delegate.getLatest(globalId);
    }

    @Override
    public List<CdoSnapshot> getLatest(Collection<GlobalId> globalIds) {
        Validate.argumentIsNotNull(globalIds);
        return this.delegate.getLatest(globalIds);
    }

    public List<CdoSnapshot> getHistoricals(GlobalId globalId, CommitId timePoint, boolean withChildValueObjects, int limit) {
        Validate.argumentsAreNotNull(globalId, timePoint);
        return this.delegate.getStateHistory(globalId, QueryParamsBuilder.withLimit(limit).withChildValueObjects(withChildValueObjects).toCommitId(timePoint).build());
    }

    public Optional<CdoSnapshot> getHistorical(GlobalId globalId, LocalDateTime timePoint) {
        Validate.argumentsAreNotNull(globalId, timePoint);
        return this.delegate.getStateHistory(globalId, QueryParamsBuilder.withLimit(1).to(timePoint).build()).stream().findFirst();
    }

    public List<CdoSnapshot> getHistoricals(GlobalId globalId, LocalDateTime timePoint, boolean withChildValueObjects, int limit) {
        Validate.argumentsAreNotNull(globalId, timePoint);
        return this.delegate.getStateHistory(globalId, QueryParamsBuilder.withLimit(limit).withChildValueObjects(withChildValueObjects).to(timePoint).build());
    }

    @Override
    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        Validate.argumentsAreNotNull(queryParams);
        return this.delegate.getSnapshots(queryParams);
    }

    @Override
    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        Validate.argumentIsNotNull(snapshotIdentifiers);
        return this.delegate.getSnapshots(snapshotIdentifiers);
    }

    @Override
    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        return this.delegate.getStateHistory(givenClasses, queryParams);
    }

    @Override
    public void persist(Commit commit) {
        this.delegate.persist(commit);
    }

    @Override
    public CommitId getHeadId() {
        return this.delegate.getHeadId();
    }

    @Override
    public void setJsonConverter(JsonConverter jsonConverter) {
    }

    @Override
    public void ensureSchema() {
        this.delegate.ensureSchema();
    }

    private List<Change> filterByPropertyName(List<Change> changes, QueryParams queryParams) {
        if (!queryParams.changedProperty().isPresent()) {
            return changes;
        }
        return Lists.positiveFilter(changes, input -> input instanceof PropertyChange && ((PropertyChange)input).getPropertyName().equals(queryParams.changedProperty().get()));
    }

    private List<CdoSnapshot> skipInitial(List<CdoSnapshot> snapshots) {
        return Lists.negativeFilter(snapshots, snapshot -> snapshot.isInitial());
    }

    private List<Change> getChangesIntroducedBySnapshots(List<CdoSnapshot> snapshots, boolean newObjectChanges) {
        return this.snapshotDiffer.calculateDiffs(newObjectChanges ? snapshots : this.skipInitial(snapshots), this.previousSnapshotsCalculator.calculate(snapshots));
    }

    private List<CdoSnapshot> loadMasterEntitySnapshotIfNecessary(InstanceId instanceId, List<CdoSnapshot> alreadyLoaded) {
        if (alreadyLoaded.isEmpty()) {
            return alreadyLoaded;
        }
        if (alreadyLoaded.stream().filter(s -> s.getGlobalId().equals(instanceId)).findFirst().isPresent()) {
            return alreadyLoaded;
        }
        return this.getLatest(instanceId).map(it -> {
            ArrayList<CdoSnapshot> enhanced = new ArrayList<CdoSnapshot>(alreadyLoaded);
            enhanced.add((CdoSnapshot)it);
            return Collections.unmodifiableList(enhanced);
        }).orElse(alreadyLoaded);
    }
}

