/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.classloaderhandler;

import io.github.classgraph.ClassLoaderHandler;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrder;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.ReflectionUtils;
import java.io.File;

public class OSGiDefaultClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classloader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object classpathManager = ReflectionUtils.invokeMethod(classloader, "getClasspathManager", false);
        Object[] entries = (Object[])ReflectionUtils.getFieldVal(classpathManager, "entries", false);
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                Object bundleFile = ReflectionUtils.invokeMethod(entries[i], "getBundleFile", false);
                File baseFile = (File)ReflectionUtils.invokeMethod(bundleFile, "getBaseFile", false);
                if (baseFile == null) continue;
                classpathOrderOut.addClasspathElement(baseFile.getPath(), classloader, log);
            }
        }
    }
}

