/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.validation.Validate;

public class Arrays {
    public static Class INT_ARRAY_TYPE = new int[0].getClass();
    public static Class INTEGER_ARRAY_TYPE = new Integer[0].getClass();
    public static Class OBJECT_ARRAY_TYPE = new Object[0].getClass();

    public static <T> Map<Integer, T> asMap(Object array) {
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        if (array == null) {
            return result;
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            result.put(i, Array.get(array, i));
        }
        return result;
    }

    public static List<Object> asList(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(array.getClass().getSimpleName() + "is not array");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(array); ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static int[] intArray(int ... data) {
        int[] ret = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = data[i];
        }
        return ret;
    }

    public static boolean equals(Object arr1, Object arr2) {
        Class<Object> c = arr1.getClass();
        Validate.argumentCheck(c.isArray(), arr1 + " is not an array");
        if (!c.getComponentType().isPrimitive()) {
            c = Object[].class;
        }
        try {
            Method eqMethod = java.util.Arrays.class.getMethod("equals", c, c);
            return (Boolean)eqMethod.invoke(null, arr1, arr2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

