/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ClassTypeSignature;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanResultObject;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.json.Id;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.Parser;
import io.github.classgraph.utils.TypeUtils;
import io.github.classgraph.utils.URLPathEncoder;
import java.io.File;
import java.lang.annotation.Inherited;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassInfo
extends ScanResultObject
implements Comparable<ClassInfo> {
    @Id
    private String name;
    private int modifiers;
    private boolean isInterface;
    private boolean isAnnotation;
    boolean isInherited;
    private String typeSignatureStr;
    private transient ClassTypeSignature typeSignature;
    private String fullyQualifiedDefiningMethodName;
    private boolean isExternalClass;
    transient File classpathElementFile;
    private transient String jarfilePackageRoot = "";
    private transient ModuleRef moduleRef;
    private transient URL classpathElementURL;
    transient ClassLoader[] classLoaders;
    AnnotationInfoList annotationInfo;
    FieldInfoList fieldInfo;
    private transient Map<String, FieldInfo> fieldNameToFieldInfo;
    MethodInfoList methodInfo;
    List<AnnotationParameterValue> annotationDefaultParamValues;
    private final Map<RelType, Set<ClassInfo>> relatedClasses = new HashMap<RelType, Set<ClassInfo>>();
    private static final int ANNOTATION_CLASS_MODIFIER = 8192;
    private static final ReachableAndDirectlyRelatedClasses NO_REACHABLE_CLASSES = new ReachableAndDirectlyRelatedClasses(Collections.emptySet(), Collections.emptySet());

    ClassInfo() {
    }

    private ClassInfo(String name, int classModifiers, boolean isExternalClass) {
        this();
        this.name = name;
        if (name.endsWith(";")) {
            throw new RuntimeException("Bad class name");
        }
        this.modifiers = classModifiers;
        this.isExternalClass = isExternalClass;
    }

    private boolean addRelatedClass(RelType relType, ClassInfo classInfo) {
        Set<ClassInfo> classInfoSet = this.relatedClasses.get((Object)relType);
        if (classInfoSet == null) {
            classInfoSet = new HashSet<ClassInfo>(4);
            this.relatedClasses.put(relType, classInfoSet);
        }
        return classInfoSet.add(classInfo);
    }

    private static ClassInfo getOrCreateClassInfo(String className, int classModifiers, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className, classModifiers, true);
            classNameToClassInfo.put(className, classInfo);
        }
        classInfo.modifiers |= classModifiers;
        if ((classModifiers & 0x2000) != 0) {
            classInfo.isAnnotation = true;
        }
        if ((classModifiers & 0x200) != 0) {
            classInfo.isInterface = true;
        }
        return classInfo;
    }

    void addSuperclass(String superclassName, Map<String, ClassInfo> classNameToClassInfo) {
        if (superclassName != null && !superclassName.equals("java.lang.Object")) {
            ClassInfo superclassClassInfo = ClassInfo.getOrCreateClassInfo(superclassName, 0, classNameToClassInfo);
            this.addRelatedClass(RelType.SUPERCLASSES, superclassClassInfo);
            superclassClassInfo.addRelatedClass(RelType.SUBCLASSES, this);
        }
    }

    void addImplementedInterface(String interfaceName, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo interfaceClassInfo = ClassInfo.getOrCreateClassInfo(interfaceName, 512, classNameToClassInfo);
        interfaceClassInfo.isInterface = true;
        interfaceClassInfo.modifiers |= 0x200;
        this.addRelatedClass(RelType.IMPLEMENTED_INTERFACES, interfaceClassInfo);
        interfaceClassInfo.addRelatedClass(RelType.CLASSES_IMPLEMENTING, this);
    }

    static void addClassContainment(List<AbstractMap.SimpleEntry<String, String>> classContainmentEntries, Map<String, ClassInfo> classNameToClassInfo) {
        for (AbstractMap.SimpleEntry<String, String> ent : classContainmentEntries) {
            String innerClassName = ent.getKey();
            ClassInfo innerClassInfo = ClassInfo.getOrCreateClassInfo(innerClassName, 0, classNameToClassInfo);
            String outerClassName = ent.getValue();
            ClassInfo outerClassInfo = ClassInfo.getOrCreateClassInfo(outerClassName, 0, classNameToClassInfo);
            innerClassInfo.addRelatedClass(RelType.CONTAINED_WITHIN_OUTER_CLASS, outerClassInfo);
            outerClassInfo.addRelatedClass(RelType.CONTAINS_INNER_CLASS, innerClassInfo);
        }
    }

    void addFullyQualifiedDefiningMethodName(String fullyQualifiedDefiningMethodName) {
        this.fullyQualifiedDefiningMethodName = fullyQualifiedDefiningMethodName;
    }

    void addClassAnnotation(AnnotationInfo classAnnotationInfo, Map<String, ClassInfo> classNameToClassInfo) {
        ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(classAnnotationInfo.getName(), 8192, classNameToClassInfo);
        if (this.annotationInfo == null) {
            this.annotationInfo = new AnnotationInfoList(2);
        }
        this.annotationInfo.add(classAnnotationInfo);
        this.addRelatedClass(RelType.CLASS_ANNOTATIONS, annotationClassInfo);
        annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_ANNOTATION, this);
        if (classAnnotationInfo.getName().equals(Inherited.class.getName())) {
            this.isInherited = true;
        }
    }

    void addFieldInfo(FieldInfoList fieldInfoList, Map<String, ClassInfo> classNameToClassInfo) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            AnnotationInfoList fieldAnnotationInfoList = fieldInfo.annotationInfo;
            if (fieldAnnotationInfoList == null) continue;
            for (AnnotationInfo fieldAnnotationInfo : fieldAnnotationInfoList) {
                ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(fieldAnnotationInfo.getName(), 8192, classNameToClassInfo);
                this.addRelatedClass(RelType.FIELD_ANNOTATIONS, annotationClassInfo);
                annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_FIELD_ANNOTATION, this);
            }
        }
        if (this.fieldInfo == null) {
            this.fieldInfo = fieldInfoList;
        } else {
            this.fieldInfo.addAll(fieldInfoList);
        }
    }

    void addMethodInfo(MethodInfoList methodInfoList, Map<String, ClassInfo> classNameToClassInfo) {
        for (MethodInfo methodInfo : methodInfoList) {
            AnnotationInfoList methodAnnotationInfoList = methodInfo.annotationInfo;
            if (methodAnnotationInfoList == null) continue;
            for (AnnotationInfo methodAnnotationInfo : methodAnnotationInfoList) {
                ClassInfo annotationClassInfo = ClassInfo.getOrCreateClassInfo(methodAnnotationInfo.getName(), 8192, classNameToClassInfo);
                this.addRelatedClass(RelType.METHOD_ANNOTATIONS, annotationClassInfo);
                annotationClassInfo.addRelatedClass(RelType.CLASSES_WITH_METHOD_ANNOTATION, this);
            }
        }
        if (this.methodInfo == null) {
            this.methodInfo = methodInfoList;
        } else {
            this.methodInfo.addAll(methodInfoList);
        }
    }

    void addTypeSignature(String typeSignatureStr) {
        if (this.typeSignatureStr == null) {
            this.typeSignatureStr = typeSignatureStr;
        } else if (typeSignatureStr != null && !this.typeSignatureStr.equals(typeSignatureStr)) {
            throw new RuntimeException("Trying to merge two classes with different type signatures for class " + this.name + ": " + this.typeSignatureStr + " ; " + typeSignatureStr);
        }
    }

    void addAnnotationParamDefaultValues(List<AnnotationParameterValue> paramNamesAndValues) {
        if (this.annotationDefaultParamValues == null) {
            this.annotationDefaultParamValues = paramNamesAndValues;
        } else {
            this.annotationDefaultParamValues.addAll(paramNamesAndValues);
        }
    }

    static ClassInfo addScannedClass(String className, int classModifiers, boolean isInterface, boolean isAnnotation, Map<String, ClassInfo> classNameToClassInfo, ClasspathElement classpathElement, ScanSpec scanSpec, LogNode log) {
        File file;
        boolean classEncounteredMultipleTimes = false;
        ClassInfo classInfo = classNameToClassInfo.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className, classModifiers, false);
            classNameToClassInfo.put(className, classInfo);
        } else if (!classInfo.isExternalClass) {
            classEncounteredMultipleTimes = true;
        }
        ModuleRef modRef = classpathElement.getClasspathElementModuleRef();
        File file2 = file = modRef != null ? null : classpathElement.getClasspathElementFile(log);
        if (classInfo.moduleRef != null && modRef != null && !classInfo.moduleRef.equals(modRef) || classInfo.classpathElementFile != null && file != null && !classInfo.classpathElementFile.equals(file)) {
            classEncounteredMultipleTimes = true;
        }
        if (classEncounteredMultipleTimes && log != null) {
            log.log("Class " + className + " is defined in multiple different classpath elements or modules -- ClassInfo#getClasspathElementFile() and/or ClassInfo#getClasspathElementModuleRef will only return the first of these; attempting to merge info from all copies of the classfile");
        }
        if (classInfo.classpathElementFile == null) {
            classInfo.classpathElementFile = file;
            classInfo.jarfilePackageRoot = classpathElement.getJarfilePackageRoot();
        }
        if (classInfo.moduleRef == null) {
            classInfo.moduleRef = modRef;
        }
        Object[] classLoaders = classpathElement.getClassLoaders();
        if (classInfo.classLoaders == null) {
            classInfo.classLoaders = classLoaders;
        } else if (classLoaders != null && !Arrays.equals(classInfo.classLoaders, classLoaders)) {
            LinkedHashSet<ClassLoader> allClassLoaders = new LinkedHashSet<ClassLoader>(Arrays.asList(classInfo.classLoaders));
            for (Object classLoader : classLoaders) {
                allClassLoaders.add((ClassLoader)classLoader);
            }
            ArrayList<ClassLoader> classLoaderOrder = new ArrayList<ClassLoader>(allClassLoaders);
            classInfo.classLoaders = classLoaderOrder.toArray(new ClassLoader[0]);
        }
        classInfo.isExternalClass = false;
        classInfo.modifiers |= classModifiers;
        classInfo.isInterface |= isInterface;
        classInfo.isAnnotation |= isAnnotation;
        return classInfo;
    }

    private static Set<ClassInfo> filterClassInfo(Collection<ClassInfo> classes, ScanSpec scanSpec, boolean strictWhitelist, ClassType ... classTypes) {
        if (classes == null) {
            return null;
        }
        boolean includeAllTypes = classTypes.length == 0;
        boolean includeStandardClasses = false;
        boolean includeImplementedInterfaces = false;
        boolean includeAnnotations = false;
        block7: for (ClassType classType : classTypes) {
            switch (classType) {
                case ALL: {
                    includeAllTypes = true;
                    continue block7;
                }
                case STANDARD_CLASS: {
                    includeStandardClasses = true;
                    continue block7;
                }
                case IMPLEMENTED_INTERFACE: {
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                case ANNOTATION: {
                    includeAnnotations = true;
                    continue block7;
                }
                case INTERFACE_OR_ANNOTATION: {
                    includeAnnotations = true;
                    includeImplementedInterfaces = true;
                    continue block7;
                }
                default: {
                    throw new RuntimeException("Unknown ClassType: " + (Object)((Object)classType));
                }
            }
        }
        if (includeStandardClasses && includeImplementedInterfaces && includeAnnotations) {
            includeAllTypes = true;
        }
        LinkedHashSet<ClassInfo> classInfoSetFiltered = new LinkedHashSet<ClassInfo>(classes.size());
        for (ClassInfo classInfo : classes) {
            if (!(includeAllTypes || includeStandardClasses && classInfo.isStandardClass() || includeImplementedInterfaces && classInfo.isImplementedInterface()) && (!includeAnnotations || !classInfo.isAnnotation()) || scanSpec.classIsBlacklisted(classInfo.name) || strictWhitelist && (classInfo.isExternalClass && !scanSpec.enableExternalClasses || scanSpec.blacklistSystemJarsOrModules && JarUtils.isInSystemPackageOrModule(classInfo.name))) continue;
            classInfoSetFiltered.add(classInfo);
        }
        return classInfoSetFiltered;
    }

    private ReachableAndDirectlyRelatedClasses filterClassInfo(RelType relType, boolean strictWhitelist, ClassType ... classTypes) {
        Set<ClassInfo> directlyRelatedClasses = this.relatedClasses.get((Object)relType);
        if (directlyRelatedClasses == null) {
            return NO_REACHABLE_CLASSES;
        }
        LinkedHashSet<ClassInfo> reachableClasses = new LinkedHashSet<ClassInfo>(directlyRelatedClasses);
        if (relType == RelType.METHOD_ANNOTATIONS || relType == RelType.FIELD_ANNOTATIONS) {
            for (ClassInfo annotation : directlyRelatedClasses) {
                reachableClasses.addAll(annotation.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)strictWhitelist, (ClassType[])new ClassType[0]).reachableClasses);
            }
        } else if (relType == RelType.CLASSES_WITH_METHOD_ANNOTATION || relType == RelType.CLASSES_WITH_FIELD_ANNOTATION) {
            for (ClassInfo subAnnotation : this.filterClassInfo((RelType)RelType.CLASSES_WITH_ANNOTATION, (boolean)strictWhitelist, (ClassType[])new ClassType[]{ClassType.ANNOTATION}).reachableClasses) {
                Set<ClassInfo> annotatedClasses = subAnnotation.relatedClasses.get((Object)relType);
                if (annotatedClasses == null) continue;
                reachableClasses.addAll(annotatedClasses);
            }
        } else {
            LinkedList<ClassInfo> queue = new LinkedList<ClassInfo>();
            queue.addAll(directlyRelatedClasses);
            while (!queue.isEmpty()) {
                ClassInfo head = (ClassInfo)queue.removeFirst();
                Set<ClassInfo> headRelatedClasses = head.relatedClasses.get((Object)relType);
                if (headRelatedClasses == null) continue;
                for (ClassInfo directlyReachableFromHead : headRelatedClasses) {
                    if (!reachableClasses.add(directlyReachableFromHead)) continue;
                    queue.add(directlyReachableFromHead);
                }
            }
        }
        if (reachableClasses.isEmpty()) {
            return NO_REACHABLE_CLASSES;
        }
        HashSet<ClassInfo> javaLangAnnotationRelatedClasses = null;
        for (ClassInfo classInfo : reachableClasses) {
            if (!classInfo.getName().startsWith("java.lang.annotation.")) continue;
            if (javaLangAnnotationRelatedClasses == null) {
                javaLangAnnotationRelatedClasses = new HashSet<ClassInfo>();
            }
            javaLangAnnotationRelatedClasses.add(classInfo);
        }
        if (javaLangAnnotationRelatedClasses != null) {
            HashSet<ClassInfo> javaLangAnnotationDirectlyRelatedClasses = null;
            for (ClassInfo classInfo : directlyRelatedClasses) {
                if (!classInfo.getName().startsWith("java.lang.annotation.")) continue;
                if (javaLangAnnotationDirectlyRelatedClasses == null) {
                    javaLangAnnotationDirectlyRelatedClasses = new HashSet<ClassInfo>();
                }
                javaLangAnnotationDirectlyRelatedClasses.add(classInfo);
            }
            if (javaLangAnnotationDirectlyRelatedClasses != null) {
                javaLangAnnotationRelatedClasses.removeAll(javaLangAnnotationDirectlyRelatedClasses);
            }
            reachableClasses.removeAll(javaLangAnnotationRelatedClasses);
        }
        return new ReachableAndDirectlyRelatedClasses(ClassInfo.filterClassInfo(reachableClasses, this.scanResult.scanSpec, strictWhitelist, new ClassType[0]), ClassInfo.filterClassInfo(directlyRelatedClasses, this.scanResult.scanSpec, strictWhitelist, new ClassType[0]));
    }

    static ClassInfoList getAllClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.ALL), true);
    }

    static ClassInfoList getAllStandardClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.STANDARD_CLASS), true);
    }

    static ClassInfoList getAllImplementedInterfaceClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.IMPLEMENTED_INTERFACE), true);
    }

    static ClassInfoList getAllAnnotationClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.ANNOTATION), true);
    }

    static ClassInfoList getAllInterfacesOrAnnotationClasses(Collection<ClassInfo> classes, ScanSpec scanSpec, ScanResult scanResult) {
        return new ClassInfoList(ClassInfo.filterClassInfo(classes, scanSpec, true, ClassType.INTERFACE_OR_ANNOTATION), true);
    }

    public String getName() {
        return this.name;
    }

    public boolean isExternalClass() {
        return this.isExternalClass;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        return TypeUtils.modifiersToString(this.modifiers, false);
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    public boolean isInterface() {
        return this.isInterface && !this.isAnnotation;
    }

    public boolean isInterfaceOrAnnotation() {
        return this.isInterface;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public boolean isStandardClass() {
        return !this.isAnnotation && !this.isInterface;
    }

    public boolean extendsSuperclass(String superclassName) {
        return this.getSuperclasses().containsName(superclassName);
    }

    public boolean isInnerClass() {
        return !this.getOuterClasses().isEmpty();
    }

    public boolean isOuterClass() {
        return !this.getInnerClasses().isEmpty();
    }

    public boolean isAnonymousInnerClass() {
        return this.fullyQualifiedDefiningMethodName != null;
    }

    public boolean isImplementedInterface() {
        return this.relatedClasses.get((Object)RelType.CLASSES_IMPLEMENTING) != null || this.isInterface && !this.isAnnotation;
    }

    public boolean implementsInterface(String interfaceName) {
        return this.getInterfaces().containsName(interfaceName);
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().containsName(annotationName);
    }

    public boolean hasField(String fieldName) {
        return this.getFieldInfo().containsName(fieldName);
    }

    public boolean hasFieldAnnotation(String fieldAnnotationName) {
        for (FieldInfo fieldInfo : this.getFieldInfo()) {
            if (!fieldInfo.getAnnotationInfo().containsName(fieldAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMethod(String methodName) {
        return this.getMethodInfo().containsName(methodName);
    }

    public boolean hasMethodAnnotation(String methodAnnotationName) {
        for (MethodInfo methodInfo : this.getMethodInfo()) {
            if (!methodInfo.getAnnotationInfo().containsName(methodAnnotationName)) continue;
            return true;
        }
        return false;
    }

    public ClassInfoList getSubclasses() {
        if (this.getName().equals("java.lang.Object")) {
            return this.scanResult.getAllClasses();
        }
        return new ClassInfoList(this.filterClassInfo(RelType.SUBCLASSES, true, new ClassType[0]), true);
    }

    public ClassInfoList getSuperclasses() {
        return new ClassInfoList(this.filterClassInfo(RelType.SUPERCLASSES, false, new ClassType[0]), false);
    }

    public ClassInfo getSuperclass() {
        Set<ClassInfo> superClasses = this.relatedClasses.get((Object)RelType.SUPERCLASSES);
        if (superClasses == null || superClasses.isEmpty()) {
            return null;
        }
        if (superClasses.size() > 2) {
            throw new IllegalArgumentException("More than one superclass: " + superClasses);
        }
        ClassInfo superclass = superClasses.iterator().next();
        if (superclass.getName().equals("java.lang.Object")) {
            return null;
        }
        return superclass;
    }

    public ClassInfoList getOuterClasses() {
        return new ClassInfoList(this.filterClassInfo(RelType.CONTAINED_WITHIN_OUTER_CLASS, false, new ClassType[0]), false);
    }

    public ClassInfoList getInnerClasses() {
        return new ClassInfoList(this.filterClassInfo(RelType.CONTAINS_INNER_CLASS, false, new ClassType[0]), true);
    }

    public String getFullyQualifiedDefiningMethodName() {
        return this.fullyQualifiedDefiningMethodName;
    }

    public ClassInfoList getInterfaces() {
        ReachableAndDirectlyRelatedClasses implementedInterfaces = this.filterClassInfo(RelType.IMPLEMENTED_INTERFACES, false, new ClassType[0]);
        HashSet<ClassInfo> allInterfaces = new HashSet<ClassInfo>(implementedInterfaces.reachableClasses);
        for (ClassInfo superclass : this.filterClassInfo((RelType)RelType.SUPERCLASSES, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses) {
            Set<ClassInfo> superclassImplementedInterfaces = superclass.filterClassInfo((RelType)RelType.IMPLEMENTED_INTERFACES, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses;
            allInterfaces.addAll(superclassImplementedInterfaces);
        }
        return new ClassInfoList(allInterfaces, implementedInterfaces.directlyRelatedClasses, true);
    }

    public ClassInfoList getClassesImplementing() {
        if (!this.isInterface) {
            throw new IllegalArgumentException("Class is not an interface: " + this.getName());
        }
        ReachableAndDirectlyRelatedClasses implementingClasses = this.filterClassInfo(RelType.CLASSES_IMPLEMENTING, true, new ClassType[0]);
        HashSet<ClassInfo> allImplementingClasses = new HashSet<ClassInfo>(implementingClasses.reachableClasses);
        for (ClassInfo implementingClass : implementingClasses.reachableClasses) {
            Set<ClassInfo> implementingSubclasses = implementingClass.filterClassInfo((RelType)RelType.SUBCLASSES, (boolean)true, (ClassType[])new ClassType[0]).reachableClasses;
            allImplementingClasses.addAll(implementingSubclasses);
        }
        return new ClassInfoList(allImplementingClasses, implementingClasses.directlyRelatedClasses, true);
    }

    public ClassInfoList getAnnotations() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses annotationClasses = this.filterClassInfo(RelType.CLASS_ANNOTATIONS, false, new ClassType[0]);
        HashSet<ClassInfo> inheritedSuperclassAnnotations = null;
        for (ClassInfo superclass : this.getSuperclasses()) {
            for (ClassInfo superclassAnnotationClass : superclass.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses) {
                Set<ClassInfo> superclassAnnotations = superclassAnnotationClass.relatedClasses.get((Object)RelType.CLASS_ANNOTATIONS);
                if (superclassAnnotations == null || !this.isInherited) continue;
                if (inheritedSuperclassAnnotations == null) {
                    inheritedSuperclassAnnotations = new HashSet<ClassInfo>();
                }
                inheritedSuperclassAnnotations.add(superclassAnnotationClass);
            }
        }
        if (inheritedSuperclassAnnotations == null) {
            return new ClassInfoList(annotationClasses, true);
        }
        inheritedSuperclassAnnotations.addAll(annotationClasses.reachableClasses);
        return new ClassInfoList((Set<ClassInfo>)inheritedSuperclassAnnotations, annotationClasses.directlyRelatedClasses, true);
    }

    public AnnotationInfoList getAnnotationInfo() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ArrayList inheritedSuperclassAnnotations = null;
        for (ClassInfo superclass : this.getSuperclasses()) {
            for (AnnotationInfo superclassAnnotationInfo : superclass.getAnnotationInfo()) {
                if (!superclassAnnotationInfo.isInherited()) continue;
                if (inheritedSuperclassAnnotations == null) {
                    inheritedSuperclassAnnotations = new AnnotationInfoList();
                }
                inheritedSuperclassAnnotations.add(superclassAnnotationInfo);
            }
        }
        if (inheritedSuperclassAnnotations == null) {
            return this.annotationInfo == null ? AnnotationInfoList.EMPTY_LIST : this.annotationInfo;
        }
        if (this.annotationInfo != null) {
            inheritedSuperclassAnnotations.addAll(this.annotationInfo);
        }
        Collections.sort(inheritedSuperclassAnnotations);
        return inheritedSuperclassAnnotations;
    }

    public List<AnnotationParameterValue> getAnnotationDefaultParameterValues() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        if (!this.isAnnotation) {
            throw new IllegalArgumentException("Class is not an annotation: " + this.getName());
        }
        return this.annotationDefaultParamValues == null ? Collections.emptyList() : this.annotationDefaultParamValues;
    }

    public ClassInfoList getClassesWithAnnotation() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        if (!this.isAnnotation) {
            throw new IllegalArgumentException("Class is not an annotation: " + this.getName());
        }
        ReachableAndDirectlyRelatedClasses classesWithAnnotation = this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, true, new ClassType[0]);
        if (this.isInherited) {
            HashSet<ClassInfo> classesWithAnnotationAndTheirSubclasses = new HashSet<ClassInfo>(classesWithAnnotation.reachableClasses);
            for (ClassInfo classWithAnnotation : classesWithAnnotation.reachableClasses) {
                classesWithAnnotationAndTheirSubclasses.addAll(classWithAnnotation.getSubclasses());
            }
            return new ClassInfoList(classesWithAnnotationAndTheirSubclasses, classesWithAnnotation.directlyRelatedClasses, true);
        }
        return new ClassInfoList(classesWithAnnotation, true);
    }

    ClassInfoList getClassesWithAnnotationDirectOnly() {
        return new ClassInfoList(this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, true, new ClassType[0]), true);
    }

    public MethodInfoList getMethodInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        if (this.methodInfo == null) {
            return MethodInfoList.EMPTY_LIST;
        }
        MethodInfoList nonConstructorMethods = new MethodInfoList();
        for (MethodInfo mi : this.methodInfo) {
            String methodName = mi.getName();
            if (methodName.equals("<init>") || methodName.equals("<clinit>")) continue;
            nonConstructorMethods.add(mi);
        }
        return nonConstructorMethods;
    }

    public MethodInfoList getConstructorInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        if (this.methodInfo == null) {
            return MethodInfoList.EMPTY_LIST;
        }
        MethodInfoList nonConstructorMethods = new MethodInfoList();
        for (MethodInfo mi : this.methodInfo) {
            String methodName = mi.getName();
            if (!methodName.equals("<init>")) continue;
            nonConstructorMethods.add(mi);
        }
        return nonConstructorMethods;
    }

    public MethodInfoList getMethodAndConstructorInfo() {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        return this.methodInfo == null ? MethodInfoList.EMPTY_LIST : this.methodInfo;
    }

    public MethodInfoList getMethodInfo(String methodName) {
        if (!this.scanResult.scanSpec.enableMethodInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() before #scan()");
        }
        if (this.methodInfo == null) {
            return MethodInfoList.EMPTY_LIST;
        }
        boolean hasMethodWithName = false;
        for (MethodInfo f : this.methodInfo) {
            if (!f.getName().equals(methodName)) continue;
            hasMethodWithName = true;
            break;
        }
        if (!hasMethodWithName) {
            return MethodInfoList.EMPTY_LIST;
        }
        MethodInfoList methodInfoList = new MethodInfoList();
        for (MethodInfo f : this.methodInfo) {
            if (!f.getName().equals(methodName)) continue;
            methodInfoList.add(f);
        }
        return methodInfoList;
    }

    public ClassInfoList getMethodAnnotations() {
        if (!this.scanResult.scanSpec.enableMethodInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() and #enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses methodAnnotations = this.filterClassInfo(RelType.METHOD_ANNOTATIONS, false, ClassType.ANNOTATION);
        HashSet<ClassInfo> methodAnnotationsAndMetaAnnotations = new HashSet<ClassInfo>(methodAnnotations.reachableClasses);
        for (ClassInfo methodAnnotation : methodAnnotations.reachableClasses) {
            methodAnnotationsAndMetaAnnotations.addAll(methodAnnotation.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(methodAnnotationsAndMetaAnnotations, methodAnnotations.directlyRelatedClasses, true);
    }

    public ClassInfoList getClassesWithMethodAnnotation() {
        if (!this.scanResult.scanSpec.enableMethodInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableMethodInfo() and #enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses classesWithDirectlyAnnotatedMethods = this.filterClassInfo(RelType.CLASSES_WITH_METHOD_ANNOTATION, true, new ClassType[0]);
        ReachableAndDirectlyRelatedClasses annotationsWithThisMetaAnnotation = this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, false, ClassType.ANNOTATION);
        if (annotationsWithThisMetaAnnotation.reachableClasses.isEmpty()) {
            return new ClassInfoList(classesWithDirectlyAnnotatedMethods, true);
        }
        HashSet<ClassInfo> allClassesWithAnnotatedOrMetaAnnotatedMethods = new HashSet<ClassInfo>(classesWithDirectlyAnnotatedMethods.reachableClasses);
        for (ClassInfo metaAnnotatedAnnotation : annotationsWithThisMetaAnnotation.reachableClasses) {
            allClassesWithAnnotatedOrMetaAnnotatedMethods.addAll(metaAnnotatedAnnotation.filterClassInfo((RelType)RelType.CLASSES_WITH_METHOD_ANNOTATION, (boolean)true, (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(allClassesWithAnnotatedOrMetaAnnotatedMethods, classesWithDirectlyAnnotatedMethods.directlyRelatedClasses, true);
    }

    ClassInfoList getClassesWithMethodAnnotationDirectOnly() {
        return new ClassInfoList(this.filterClassInfo(RelType.CLASSES_WITH_METHOD_ANNOTATION, true, new ClassType[0]), true);
    }

    public FieldInfoList getFieldInfo() {
        if (!this.scanResult.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() before #scan()");
        }
        return this.fieldInfo == null ? FieldInfoList.EMPTY_LIST : this.fieldInfo;
    }

    public FieldInfo getFieldInfo(String fieldName) {
        if (!this.scanResult.scanSpec.enableFieldInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() before #scan()");
        }
        if (this.fieldInfo == null) {
            return null;
        }
        if (this.fieldNameToFieldInfo == null) {
            this.fieldNameToFieldInfo = new HashMap<String, FieldInfo>();
            for (FieldInfo f : this.fieldInfo) {
                this.fieldNameToFieldInfo.put(f.getName(), f);
            }
        }
        return this.fieldNameToFieldInfo.get(fieldName);
    }

    public ClassInfoList getFieldAnnotations() {
        if (!this.scanResult.scanSpec.enableFieldInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() and ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses fieldAnnotations = this.filterClassInfo(RelType.FIELD_ANNOTATIONS, false, ClassType.ANNOTATION);
        HashSet<ClassInfo> fieldAnnotationsAndMetaAnnotations = new HashSet<ClassInfo>(fieldAnnotations.reachableClasses);
        for (ClassInfo fieldAnnotation : fieldAnnotations.reachableClasses) {
            fieldAnnotationsAndMetaAnnotations.addAll(fieldAnnotation.filterClassInfo((RelType)RelType.CLASS_ANNOTATIONS, (boolean)false, (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(fieldAnnotationsAndMetaAnnotations, fieldAnnotations.directlyRelatedClasses, true);
    }

    public ClassInfoList getClassesWithFieldAnnotation() {
        if (!this.scanResult.scanSpec.enableFieldInfo || !this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableFieldInfo() and ClassGraph#enableAnnotationInfo() before #scan()");
        }
        ReachableAndDirectlyRelatedClasses classesWithDirectlyAnnotatedFields = this.filterClassInfo(RelType.CLASSES_WITH_FIELD_ANNOTATION, true, new ClassType[0]);
        ReachableAndDirectlyRelatedClasses annotationsWithThisMetaAnnotation = this.filterClassInfo(RelType.CLASSES_WITH_ANNOTATION, false, ClassType.ANNOTATION);
        if (annotationsWithThisMetaAnnotation.reachableClasses.isEmpty()) {
            return new ClassInfoList(classesWithDirectlyAnnotatedFields, true);
        }
        HashSet<ClassInfo> allClassesWithAnnotatedOrMetaAnnotatedFields = new HashSet<ClassInfo>(classesWithDirectlyAnnotatedFields.reachableClasses);
        for (ClassInfo metaAnnotatedAnnotation : annotationsWithThisMetaAnnotation.reachableClasses) {
            allClassesWithAnnotatedOrMetaAnnotatedFields.addAll(metaAnnotatedAnnotation.filterClassInfo((RelType)RelType.CLASSES_WITH_FIELD_ANNOTATION, (boolean)true, (ClassType[])new ClassType[0]).reachableClasses);
        }
        return new ClassInfoList(allClassesWithAnnotatedOrMetaAnnotatedFields, classesWithDirectlyAnnotatedFields.directlyRelatedClasses, true);
    }

    ClassInfoList getClassesWithFieldAnnotationDirectOnly() {
        return new ClassInfoList(this.filterClassInfo(RelType.CLASSES_WITH_FIELD_ANNOTATION, true, new ClassType[0]), true);
    }

    public ClassTypeSignature getTypeSignature() {
        if (this.typeSignatureStr == null) {
            return null;
        }
        if (this.typeSignature == null) {
            try {
                this.typeSignature = ClassTypeSignature.parse(this.typeSignatureStr, this);
                this.typeSignature.setScanResult(this.scanResult);
            }
            catch (Parser.ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.typeSignature;
    }

    public URL getClasspathElementURL() {
        block9: {
            if (this.classpathElementURL == null) {
                try {
                    if (this.moduleRef != null) {
                        this.classpathElementURL = this.moduleRef.getLocation().toURL();
                        break block9;
                    }
                    if (!this.jarfilePackageRoot.isEmpty()) {
                        String classpathEltURL;
                        File classpathEltFile = this.getClasspathElementFile();
                        boolean classpathEltIsJar = classpathEltFile.isFile();
                        try {
                            classpathEltURL = classpathEltFile.toURI().toURL().toString();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                        String relativePathEncoded = URLPathEncoder.encodePath(this.jarfilePackageRoot);
                        String urlStr = classpathEltIsJar ? "jar:" + classpathEltURL + "!" + relativePathEncoded : classpathEltURL + (!classpathEltURL.endsWith("/") ? "/" : "") + (relativePathEncoded.startsWith("/") ? relativePathEncoded.substring(1) : relativePathEncoded);
                        try {
                            this.classpathElementURL = new URL(urlStr);
                            break block9;
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    this.classpathElementURL = this.getClasspathElementFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return this.classpathElementURL;
    }

    public File getClasspathElementFile() {
        return this.classpathElementFile;
    }

    public ModuleRef getModuleRef() {
        return this.moduleRef;
    }

    @Override
    public <T> Class<T> loadClass(Class<T> superclassOrInterfaceType, boolean ignoreExceptions) {
        return super.loadClass(superclassOrInterfaceType, ignoreExceptions);
    }

    @Override
    public <T> Class<T> loadClass(Class<T> superclassOrInterfaceType) {
        return super.loadClass(superclassOrInterfaceType, false);
    }

    @Override
    public Class<?> loadClass(boolean ignoreExceptions) {
        return super.loadClass(ignoreExceptions);
    }

    @Override
    public Class<?> loadClass() {
        return super.loadClass(false);
    }

    @Override
    protected String getClassName() {
        return this.name;
    }

    @Override
    protected ClassInfo getClassInfo() {
        return this;
    }

    @Override
    void setScanResult(ScanResult scanResult) {
        super.setScanResult(scanResult);
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                fi.setScanResult(scanResult);
            }
        }
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                mi.setScanResult(scanResult);
            }
        }
        if (this.annotationDefaultParamValues != null) {
            for (AnnotationParameterValue apv : this.annotationDefaultParamValues) {
                apv.setScanResult(scanResult);
            }
        }
    }

    @Override
    protected void getClassNamesFromTypeDescriptors(Set<String> classNames) {
        ClassTypeSignature classSig;
        HashSet<String> referencedClassNames = new HashSet<String>();
        if (this.methodInfo != null) {
            for (MethodInfo mi : this.methodInfo) {
                mi.getClassNamesFromTypeDescriptors(classNames);
            }
        }
        if (this.fieldInfo != null) {
            for (FieldInfo fi : this.fieldInfo) {
                fi.getClassNamesFromTypeDescriptors(classNames);
            }
        }
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.getClassNamesFromTypeDescriptors(referencedClassNames);
            }
        }
        if (this.annotationDefaultParamValues != null) {
            for (AnnotationParameterValue paramValue : this.annotationDefaultParamValues) {
                paramValue.getClassNamesFromTypeDescriptors(referencedClassNames);
            }
        }
        if ((classSig = this.getTypeSignature()) != null) {
            classSig.getClassNamesFromTypeDescriptors(referencedClassNames);
        }
    }

    @Override
    public int compareTo(ClassInfo o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassInfo other = (ClassInfo)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 33;
    }

    public String toString() {
        ClassTypeSignature typeSig = this.getTypeSignature();
        if (typeSig != null) {
            return typeSig.toString();
        }
        StringBuilder buf = new StringBuilder();
        TypeUtils.modifiersToString(this.modifiers, false, buf);
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.isAnnotation ? "@interface " : (this.isInterface ? "interface " : ((this.modifiers & 0x4000) != 0 ? "enum " : "class ")));
        buf.append(this.name);
        return buf.toString();
    }

    static class ReachableAndDirectlyRelatedClasses {
        final Set<ClassInfo> reachableClasses;
        final Set<ClassInfo> directlyRelatedClasses;

        private ReachableAndDirectlyRelatedClasses(Set<ClassInfo> reachableClasses, Set<ClassInfo> directlyRelatedClasses) {
            this.reachableClasses = reachableClasses;
            this.directlyRelatedClasses = directlyRelatedClasses;
        }
    }

    private static enum ClassType {
        ALL,
        STANDARD_CLASS,
        IMPLEMENTED_INTERFACE,
        ANNOTATION,
        INTERFACE_OR_ANNOTATION;

    }

    private static enum RelType {
        SUPERCLASSES,
        SUBCLASSES,
        CONTAINS_INNER_CLASS,
        CONTAINED_WITHIN_OUTER_CLASS,
        IMPLEMENTED_INTERFACES,
        CLASSES_IMPLEMENTING,
        CLASS_ANNOTATIONS,
        CLASSES_WITH_ANNOTATION,
        METHOD_ANNOTATIONS,
        CLASSES_WITH_METHOD_ANNOTATION,
        FIELD_ANNOTATIONS,
        CLASSES_WITH_FIELD_ANNOTATION;

    }
}

