/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassLoaderHandler;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.Scanner;
import io.github.classgraph.utils.AutoCloseableExecutorService;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.VersionFinder;
import io.github.classgraph.utils.WhiteBlackList;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public class ClassGraph {
    private final ScanSpec scanSpec = new ScanSpec();
    private static final int DEFAULT_NUM_WORKER_THREADS = Math.max(2, (int)Math.ceil(Math.min(4.0f, (float)Runtime.getRuntime().availableProcessors() * 0.75f) + (float)Runtime.getRuntime().availableProcessors() * 1.25f));
    private LogNode log;

    public static final String getVersion() {
        return VersionFinder.getVersion();
    }

    public ClassGraph verbose() {
        if (this.log == null) {
            this.log = new LogNode();
        }
        return this;
    }

    public ClassGraph enableAllInfo() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.enableStaticFinalFieldConstantInitializerValues();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        return this;
    }

    public ClassGraph enableClassInfo() {
        this.scanSpec.enableClassInfo = true;
        return this;
    }

    public ClassGraph ignoreClassVisibility() {
        this.enableClassInfo();
        this.scanSpec.ignoreClassVisibility = true;
        return this;
    }

    public ClassGraph enableMethodInfo() {
        this.enableClassInfo();
        this.scanSpec.enableMethodInfo = true;
        return this;
    }

    public ClassGraph ignoreMethodVisibility() {
        this.enableClassInfo();
        this.enableMethodInfo();
        this.scanSpec.ignoreMethodVisibility = true;
        return this;
    }

    public ClassGraph enableFieldInfo() {
        this.enableClassInfo();
        this.scanSpec.enableFieldInfo = true;
        return this;
    }

    public ClassGraph ignoreFieldVisibility() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.ignoreFieldVisibility = true;
        return this;
    }

    public ClassGraph enableStaticFinalFieldConstantInitializerValues() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.enableStaticFinalFieldConstantInitializerValues = true;
        return this;
    }

    public ClassGraph enableAnnotationInfo() {
        this.enableClassInfo();
        this.scanSpec.enableAnnotationInfo = true;
        return this;
    }

    public ClassGraph disableRuntimeInvisibleAnnotations() {
        this.enableClassInfo();
        this.scanSpec.disableRuntimeInvisibleAnnotations = true;
        return this;
    }

    public ClassGraph disableJarScanning() {
        this.scanSpec.scanJars = false;
        return this;
    }

    public ClassGraph disableNestedJarScanning() {
        this.scanSpec.scanNestedJars = false;
        return this;
    }

    public ClassGraph disableDirScanning() {
        this.scanSpec.scanDirs = false;
        return this;
    }

    public ClassGraph disableModuleScanning() {
        this.scanSpec.scanModules = false;
        return this;
    }

    public ClassGraph enableExternalClasses() {
        this.enableClassInfo();
        this.scanSpec.enableExternalClasses = true;
        return this;
    }

    public ClassGraph initializeLoadedClasses() {
        this.scanSpec.initializeLoadedClasses = true;
        return this;
    }

    public ClassGraph removeTemporaryFilesAfterScan() {
        this.scanSpec.removeTemporaryFilesAfterScan = true;
        return this;
    }

    public ClassGraph stripZipSFXHeaders() {
        this.scanSpec.stripSFXHeader = true;
        return this;
    }

    public ClassGraph registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandlerClass) {
        this.scanSpec.registerClassLoaderHandler(classLoaderHandlerClass);
        return this;
    }

    public ClassGraph overrideClasspath(String overrideClasspath) {
        this.scanSpec.overrideClasspath(overrideClasspath);
        return this;
    }

    public ClassGraph overrideClasspath(Iterable<?> overrideClasspathElements) {
        String overrideClasspath = JarUtils.pathElementsToPathStr(overrideClasspathElements);
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public ClassGraph overrideClasspath(Object ... overrideClasspathElements) {
        String overrideClasspath = JarUtils.pathElementsToPathStr(overrideClasspathElements);
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        this.overrideClasspath(overrideClasspath);
        return this;
    }

    public ClassGraph filterClasspathElements(ClasspathElementFilter classpathElementFilter) {
        this.scanSpec.filterClasspathElements(classpathElementFilter);
        return this;
    }

    public ClassGraph addClassLoader(ClassLoader classLoader) {
        this.scanSpec.addClassLoader(classLoader);
        return this;
    }

    public ClassGraph overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.scanSpec.overrideClassLoaders(overrideClassLoaders);
        return this;
    }

    public ClassGraph ignoreParentClassLoaders() {
        this.scanSpec.ignoreParentClassLoaders = true;
        return this;
    }

    public ClassGraph whitelistPackages(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            if (packageName.startsWith("!") || packageName.startsWith("-")) {
                throw new IllegalArgumentException("This style of whitelisting/blacklisting is no longer supported: " + packageName);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName));
            if (packageName.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName));
        }
        return this;
    }

    public ClassGraph whitelistPaths(String ... paths) {
        for (String path : paths) {
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(path));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePath(path));
            if (path.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(path) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePath(path));
        }
        return this;
    }

    public ClassGraph whitelistPackagesNonRecursive(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            if (packageName.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + packageName);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName));
        }
        return this;
    }

    public ClassGraph whitelistPathsNonRecursive(String ... paths) {
        for (String path : paths) {
            if (path.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + path);
            }
            this.scanSpec.packageWhiteBlackList.addToWhitelist(WhiteBlackList.pathToPackageName(path));
            this.scanSpec.pathWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePath(path));
        }
        return this;
    }

    public ClassGraph blacklistPackages(String ... packageNames) {
        this.enableClassInfo();
        for (String packageName : packageNames) {
            this.scanSpec.packageWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.pathWhiteBlackList.addToBlacklist(WhiteBlackList.packageNameToPath(packageName));
            if (packageName.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(packageName) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToBlacklist(WhiteBlackList.packageNameToPath(packageName));
        }
        return this;
    }

    public ClassGraph blacklistPaths(String ... paths) {
        for (String path : paths) {
            this.scanSpec.packageWhiteBlackList.addToBlacklist(WhiteBlackList.pathToPackageName(path));
            this.scanSpec.pathWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePath(path));
            if (path.contains("*")) continue;
            this.scanSpec.packagePrefixWhiteBlackList.addToBlacklist(WhiteBlackList.pathToPackageName(path) + ".");
            this.scanSpec.pathPrefixWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePath(path));
        }
        return this;
    }

    public ClassGraph whitelistClasses(String ... classNames) {
        this.enableClassInfo();
        for (String className : classNames) {
            if (className.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + className);
            }
            this.scanSpec.classWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(className));
            this.scanSpec.classfilePathWhiteBlackList.addToWhitelist(WhiteBlackList.classNameToClassfilePath(className));
            int lastDotIdx = className.lastIndexOf(46);
            String packageName = lastDotIdx < 0 ? "" : className.substring(0, lastDotIdx);
            this.scanSpec.classPackageWhiteBlackList.addToWhitelist(WhiteBlackList.normalizePackageOrClassName(packageName));
            this.scanSpec.classPackagePathWhiteBlackList.addToWhitelist(WhiteBlackList.packageNameToPath(packageName));
        }
        return this;
    }

    public ClassGraph blacklistClasses(String ... classNames) {
        this.enableClassInfo();
        for (String className : classNames) {
            if (className.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + className);
            }
            this.scanSpec.classWhiteBlackList.addToBlacklist(WhiteBlackList.normalizePackageOrClassName(className));
            this.scanSpec.classfilePathWhiteBlackList.addToBlacklist(WhiteBlackList.classNameToClassfilePath(className));
        }
        return this;
    }

    public ClassGraph whitelistJars(String ... jarLeafNames) {
        for (String jarLeafName : jarLeafNames) {
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only whitelist jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarWhiteBlackList.addToWhitelist(leafName);
        }
        return this;
    }

    public ClassGraph blacklistJars(String ... jarLeafNames) {
        for (String jarLeafName : jarLeafNames) {
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only blacklist jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarWhiteBlackList.addToBlacklist(leafName);
        }
        return this;
    }

    public ClassGraph whitelistLibOrExtJars(String ... jarLeafNames) {
        if (jarLeafNames.length == 0) {
            for (String libOrExtJar : JarUtils.getJreLibOrExtJars()) {
                this.whitelistLibOrExtJars(JarUtils.leafName(libOrExtJar));
            }
        } else {
            for (String jarLeafName : jarLeafNames) {
                String leafName = JarUtils.leafName(jarLeafName);
                if (!leafName.equals(jarLeafName)) {
                    throw new IllegalArgumentException("Can only whitelist jars by leafname: " + jarLeafName);
                }
                if (jarLeafName.contains("*")) {
                    Pattern pattern = WhiteBlackList.globToPattern(jarLeafName);
                    boolean found = false;
                    for (String libOrExtJarPath : JarUtils.getJreLibOrExtJars()) {
                        String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                        if (!pattern.matcher(libOrExtJarLeafName).matches()) continue;
                        if (!libOrExtJarLeafName.contains("*")) {
                            this.whitelistLibOrExtJars(libOrExtJarLeafName);
                        }
                        found = true;
                    }
                    if (found || this.log == null) continue;
                    this.log.log("Could not find lib or ext jar matching wildcard: " + jarLeafName);
                    continue;
                }
                boolean found = false;
                for (String libOrExtJarPath : JarUtils.getJreLibOrExtJars()) {
                    String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                    if (!jarLeafName.equals(libOrExtJarLeafName)) continue;
                    this.scanSpec.libOrExtJarWhiteBlackList.addToWhitelist(jarLeafName);
                    if (this.log != null) {
                        this.log.log("Whitelisting lib or ext jar: " + libOrExtJarPath);
                    }
                    found = true;
                    break;
                }
                if (found || this.log == null) continue;
                this.log.log("Could not find lib or ext jar: " + jarLeafName);
            }
        }
        return this;
    }

    public ClassGraph blacklistLibOrExtJars(String ... jarLeafNames) {
        if (jarLeafNames.length == 0) {
            for (String libOrExtJar : JarUtils.getJreLibOrExtJars()) {
                this.blacklistLibOrExtJars(libOrExtJar);
            }
        } else {
            for (String jarLeafName : jarLeafNames) {
                String leafName = JarUtils.leafName(jarLeafName);
                if (!leafName.equals(jarLeafName)) {
                    throw new IllegalArgumentException("Can only blacklist jars by leafname: " + jarLeafName);
                }
                if (jarLeafName.contains("*")) {
                    Pattern pattern = WhiteBlackList.globToPattern(jarLeafName);
                    boolean found = false;
                    for (String libOrExtJarPath : JarUtils.getJreLibOrExtJars()) {
                        String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                        if (!pattern.matcher(libOrExtJarLeafName).matches()) continue;
                        if (!libOrExtJarLeafName.contains("*")) {
                            this.blacklistLibOrExtJars(libOrExtJarLeafName);
                        }
                        found = true;
                    }
                    if (found || this.log == null) continue;
                    this.log.log("Could not find lib or ext jar matching wildcard: " + jarLeafName);
                    continue;
                }
                boolean found = false;
                for (String libOrExtJarPath : JarUtils.getJreLibOrExtJars()) {
                    String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                    if (!jarLeafName.equals(libOrExtJarLeafName)) continue;
                    this.scanSpec.libOrExtJarWhiteBlackList.addToBlacklist(jarLeafName);
                    if (this.log != null) {
                        this.log.log("Blacklisting lib or ext jar: " + libOrExtJarPath);
                    }
                    found = true;
                    break;
                }
                if (found || this.log == null) continue;
                this.log.log("Could not find lib or ext jar: " + jarLeafName);
            }
        }
        return this;
    }

    public ClassGraph whitelistModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.scanSpec.moduleWhiteBlackList.addToWhitelist(moduleName);
        }
        return this;
    }

    public ClassGraph blacklistModules(String ... moduleNames) {
        for (String moduleName : moduleNames) {
            this.scanSpec.moduleWhiteBlackList.addToBlacklist(moduleName);
        }
        return this;
    }

    public ClassGraph enableSystemPackages() {
        this.enableClassInfo();
        this.whitelistLibOrExtJars(new String[0]);
        this.scanSpec.blacklistSystemJarsOrModules = false;
        return this;
    }

    public void scanAsync(ExecutorService executorService, int numParallelTasks, ScanResultProcessor scanResultProcessor, FailureHandler failureHandler) {
        if (scanResultProcessor == null) {
            throw new IllegalArgumentException("scanResultProcessor cannot be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("failureHandler cannot be null");
        }
        executorService.submit(new Scanner(this.scanSpec, executorService, numParallelTasks, true, scanResultProcessor, failureHandler, this.log));
    }

    public Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        return executorService.submit(new Scanner(this.scanSpec, executorService, numParallelTasks, true, null, null, this.log));
    }

    public ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            ScanResult scanResult;
            ScanResult scanResult2 = scanResult = executorService.submit(new Scanner(this.scanSpec, executorService, numParallelTasks, true, null, null, this.log)).get();
            return scanResult2;
        }
        catch (InterruptedException e) {
            if (this.log != null) {
                this.log.log("Scan interrupted");
            }
            throw new IllegalArgumentException("Scan interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            if (cause instanceof InterruptedException) {
                if (this.log != null) {
                    this.log.log("Scan interrupted");
                }
                throw new IllegalArgumentException("Scan interrupted", e);
            }
            if (this.log != null) {
                this.log.log("Unexpected exception during scan", e);
            }
            throw new RuntimeException(cause);
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public ScanResult scan(int numThreads) {
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            ScanResult scanResult = this.scan(executorService, numThreads);
            return scanResult;
        }
    }

    public ScanResult scan() {
        return this.scan(DEFAULT_NUM_WORKER_THREADS);
    }

    public List<File> getClasspathFiles() {
        try {
            List<File> list;
            AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
            Throwable throwable = null;
            try {
                list = executorService.submit(new Scanner(this.scanSpec, executorService, DEFAULT_NUM_WORKER_THREADS, false, null, null, this.log == null ? null : this.log.log("Getting unique classpath elements"))).get().getClasspathFiles();
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ClassGraph.$closeResource(throwable, executorService);
                        throw throwable3;
                    }
                }
                catch (InterruptedException e) {
                    if (this.log != null) {
                        this.log.log("Thread interrupted while getting classpath elements");
                    }
                    throw new IllegalArgumentException("Scan interrupted", e);
                }
                catch (ExecutionException e) {
                    Throwable cause;
                    if (this.log != null) {
                        this.log.log("Exception while getting classpath elements", e);
                    }
                    throw new RuntimeException((cause = e.getCause()) == null ? e : cause);
                }
            }
            ClassGraph.$closeResource(throwable, executorService);
            return list;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public String getClasspath() {
        return JarUtils.pathElementsToPathStr(this.getClasspathFiles());
    }

    public List<URL> getClasspathURLs() {
        try {
            List<URL> list;
            AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
            Throwable throwable = null;
            try {
                list = executorService.submit(new Scanner(this.scanSpec, executorService, DEFAULT_NUM_WORKER_THREADS, false, null, null, this.log == null ? null : this.log.log("Getting unique classpath elements"))).get().getClasspathURLs();
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ClassGraph.$closeResource(throwable, executorService);
                        throw throwable3;
                    }
                }
                catch (InterruptedException e) {
                    if (this.log != null) {
                        this.log.log("Thread interrupted while getting classpath elements");
                    }
                    throw new IllegalArgumentException("Scan interrupted", e);
                }
                catch (ExecutionException e) {
                    Throwable cause;
                    if (this.log != null) {
                        this.log.log("Exception while getting classpath elements", e);
                    }
                    throw new RuntimeException((cause = e.getCause()) == null ? e : cause);
                }
            }
            ClassGraph.$closeResource(throwable, executorService);
            return list;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    public List<ModuleRef> getModules() {
        try {
            List<ModuleRef> list;
            AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
            Throwable throwable = null;
            try {
                list = executorService.submit(new Scanner(this.scanSpec, executorService, DEFAULT_NUM_WORKER_THREADS, false, null, null, this.log == null ? null : this.log.log("Getting unique classpath elements"))).get().getModules();
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ClassGraph.$closeResource(throwable, executorService);
                        throw throwable3;
                    }
                }
                catch (InterruptedException e) {
                    if (this.log != null) {
                        this.log.log("Thread interrupted while getting modules");
                    }
                    throw new IllegalArgumentException("Scan interrupted", e);
                }
                catch (ExecutionException e) {
                    Throwable cause;
                    if (this.log != null) {
                        this.log.log("Exception while getting modules", e);
                    }
                    throw new RuntimeException((cause = e.getCause()) == null ? e : cause);
                }
            }
            ClassGraph.$closeResource(throwable, executorService);
            return list;
        }
        finally {
            if (this.log != null) {
                this.log.flush();
            }
        }
    }

    @FunctionalInterface
    public static interface FailureHandler {
        public void onFailure(Throwable var1);
    }

    @FunctionalInterface
    public static interface ScanResultProcessor {
        public void processScanResult(ScanResult var1);
    }

    @FunctionalInterface
    public static interface ClasspathElementFilter {
        public boolean includeClasspathElement(String var1);
    }
}

