/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeMapper;

class SetChangeAppender
extends CorePropertyChangeAppender<SetChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    SetChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof SetType;
    }

    private List<ContainerElementChange> calculateEntryChanges(SetType setType, Set leftRawSet, Set rightRawSet, OwnerContext owner) {
        JaversType itemType = this.typeMapper.getJaversType(setType.getItemType());
        DehydrateContainerFunction dehydrateFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        if (Objects.equals(leftRawSet, rightRawSet)) {
            return Collections.emptyList();
        }
        Set leftSet = (Set)setType.map(leftRawSet, dehydrateFunction, owner);
        Set rightSet = (Set)setType.map(rightRawSet, dehydrateFunction, owner);
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        Sets.difference(leftSet, rightSet).forEach(valueOrId -> changes.add(new ValueRemoved(valueOrId)));
        Sets.difference(rightSet, leftSet).forEach(valueOrId -> changes.add(new ValueAdded(valueOrId)));
        return changes;
    }

    @Override
    public SetChange calculateChanges(NodePair pair, Property property) {
        PropertyOwnerContext owner;
        Set leftValues = (Set)pair.getLeftPropertyValue(property);
        Set rightValues = (Set)pair.getRightPropertyValue(property);
        SetType setType = (SetType)((JaversProperty)property).getType();
        List<ContainerElementChange> entryChanges = this.calculateEntryChanges(setType, leftValues, rightValues, owner = new PropertyOwnerContext(pair.getGlobalId(), property.getName()));
        if (!entryChanges.isEmpty()) {
            this.renderNotParametrizedWarningIfNeeded(setType.getItemType(), "item", "Set", property);
            return new SetChange(pair.getGlobalId(), property.getName(), entryChanges);
        }
        return null;
    }
}

