/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.common.validation.Validate;

public abstract class JaversMember<T extends Member> {
    private final T rawMember;
    private final Optional<Type> resolvedReturnType;

    public JaversMember(T rawMember, Type resolvedReturnType) {
        Validate.argumentIsNotNull(rawMember);
        this.rawMember = rawMember;
        this.resolvedReturnType = Optional.ofNullable(resolvedReturnType);
        this.setAccessibleIfNecessary((Member)rawMember);
    }

    protected abstract Type getRawGenericType();

    public abstract Class<?> getRawType();

    public T getRawMember() {
        return this.rawMember;
    }

    public Type getGenericResolvedType() {
        if (this.resolvedReturnType.isPresent()) {
            return this.resolvedReturnType.get();
        }
        return this.getRawGenericType();
    }

    public Class<?> getDeclaringClass() {
        return this.rawMember.getDeclaringClass();
    }

    public String name() {
        return this.rawMember.getName();
    }

    public String propertyName() {
        return this.rawMember.getName();
    }

    public Set<Annotation> getAnnotations() {
        return Collections.unmodifiableSet(Sets.asSet(((AccessibleObject)this.rawMember).getAnnotations()));
    }

    public Set<Class<? extends Annotation>> getAnnotationTypes() {
        return Sets.transform(this.getAnnotations(), ann -> ann.annotationType());
    }

    public boolean hasAnnotation(Set<String> aliases) {
        if (aliases == null) {
            return false;
        }
        return this.getAnnotationTypes().stream().anyMatch(annType -> aliases.contains(annType.getSimpleName()));
    }

    public abstract Object getEvenIfPrivate(Object var1);

    public abstract void setEvenIfPrivate(Object var1, Object var2);

    void setAccessibleIfNecessary(Member rawMember) {
        if (!this.isPublic(rawMember)) {
            ((AccessibleObject)((Object)rawMember)).setAccessible(true);
        }
    }

    private boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversMember that = (JaversMember)o;
        return this.rawMember.equals(that.rawMember) && this.resolvedReturnType.equals(that.resolvedReturnType);
    }

    public int hashCode() {
        return this.rawMember.hashCode() + this.resolvedReturnType.hashCode();
    }
}

