/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.javers.common.reflection.JaversGetter;
import org.javers.common.reflection.JaversMember;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.scanner.AnnotationNamesProvider;
import org.javers.core.metamodel.scanner.PropertyScan;
import org.javers.core.metamodel.scanner.PropertyScanner;

class BeanBasedPropertyScanner
extends PropertyScanner {
    private final AnnotationNamesProvider annotationNamesProvider;

    BeanBasedPropertyScanner(AnnotationNamesProvider annotationNamesProvider) {
        this.annotationNamesProvider = annotationNamesProvider;
    }

    @Override
    public PropertyScan scan(Class<?> managedClass, boolean ignoreDeclaredProperties) {
        List<JaversGetter> getters = ReflectionUtil.getAllGetters(managedClass);
        ArrayList<Property> beanProperties = new ArrayList<Property>();
        for (JaversGetter getter : getters) {
            boolean isIgnoredInType = ignoreDeclaredProperties && getter.getDeclaringClass().equals(managedClass);
            boolean hasTransientAnn = this.annotationNamesProvider.hasTransientPropertyAnn(getter.getAnnotationTypes());
            boolean hasShallowReferenceAnn = this.annotationNamesProvider.hasShallowReferenceAnn(getter.getAnnotationTypes());
            Optional<String> customPropertyName = this.annotationNamesProvider.findPropertyNameAnnValue(getter.getAnnotations());
            beanProperties.add(new Property((JaversMember)getter, hasTransientAnn || isIgnoredInType, hasShallowReferenceAnn, customPropertyName));
        }
        return new PropertyScan(beanProperties);
    }
}

