/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.MatchProcessorException;
import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FieldAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchContentsProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.FileMatchProcessorWithContext;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.ImplementingClassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.MethodAnnotationMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.StaticFinalFieldMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubinterfaceMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfo;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassLoaderFinder;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElement;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.utils.JarUtils;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

public class ScanSpec {
    private final ArrayList<String> whitelistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPathPrefixes = new ArrayList();
    private final ArrayList<String> blacklistedPackagePrefixes = new ArrayList();
    private final HashSet<String> specificallyWhitelistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyWhitelistedClassParentRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassRelativePaths = new HashSet();
    private final HashSet<String> specificallyBlacklistedClassNames = new HashSet();
    private final HashSet<String> whitelistedJars = new HashSet();
    private final HashSet<String> blacklistedJars = new HashSet();
    private final ArrayList<Pattern> whitelistedJarPatterns = new ArrayList();
    private final ArrayList<Pattern> blacklistedJarPatterns = new ArrayList();
    boolean scanJars = true;
    boolean scanDirs = true;
    public boolean enableFieldTypeIndexing;
    public boolean enableMethodAnnotationIndexing;
    public boolean enableFieldAnnotationIndexing;
    public boolean enableFieldInfo;
    public boolean enableMethodInfo;
    public boolean strictWhitelist;
    private boolean blacklistSystemJars = true;
    private boolean blacklistSystemPackages = true;
    public boolean ignoreFieldVisibility = false;
    public boolean ignoreMethodVisibility = false;
    public RetentionPolicy annotationVisibility = RetentionPolicy.CLASS;
    public boolean disableRecursiveScanning = false;
    private MultiMapKeyToList<String, StaticFinalFieldMatchProcessor> fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors;
    private MultiMapKeyToSet<String, String> classNameToStaticFinalFieldsToMatch;
    private ArrayList<ClassMatcher> classMatchers;
    private final List<FilePathTesterAndMatchProcessorWrapper> filePathTestersAndMatchProcessorWrappers = new ArrayList<FilePathTesterAndMatchProcessorWrapper>();
    List<ClassLoader> addedClassLoaders;
    List<ClassLoader> overrideClassLoaders;
    ClassLoaderFinder classLoaderFinder;
    String overrideClasspath;
    final ArrayList<Class<? extends ClassLoaderHandler>> extraClassLoaderHandlers = new ArrayList();
    public boolean initializeLoadedClasses = false;
    public boolean removeTemporaryFilesAfterScan = true;
    boolean ignoreParentClassLoaders = false;

    public MultiMapKeyToSet<String, String> getClassNameToStaticFinalFieldsToMatch() {
        return this.classNameToStaticFinalFieldsToMatch;
    }

    public ScanSpec(String[] scanSpec, LogNode log) {
        HashSet<String> uniqueWhitelistedPathPrefixes = new HashSet<String>();
        HashSet<String> uniqueBlacklistedPathPrefixes = new HashSet<String>();
        String[] stringArray = scanSpec;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String scanSpecEntry;
            String spec = scanSpecEntry = stringArray[i];
            if ("!".equals(scanSpecEntry)) {
                this.blacklistSystemPackages = false;
                continue;
            }
            if ("!!".equals(scanSpecEntry)) {
                this.blacklistSystemJars = false;
                this.blacklistSystemPackages = false;
                continue;
            }
            boolean blacklisted = spec.startsWith("-");
            if (blacklisted) {
                spec = spec.substring(1);
            }
            if (spec.startsWith("jar:")) {
                if ((spec = spec.substring(4)).indexOf(47) >= 0) {
                    if (log == null) continue;
                    log.log("Only a leaf filename may be used with a \"jar:\" entry in the scan spec, got \"" + spec + "\" -- ignoring");
                    continue;
                }
                if (spec.isEmpty()) {
                    if (blacklisted) {
                        this.scanJars = false;
                        continue;
                    }
                    if (log == null) continue;
                    log.log("Ignoring scan spec entry with no effect: \"" + scanSpecEntry + "\"");
                    continue;
                }
                if (blacklisted) {
                    if (spec.contains("*")) {
                        this.blacklistedJarPatterns.add(ScanSpec.specToPattern(spec));
                        continue;
                    }
                    this.blacklistedJars.add(spec);
                    continue;
                }
                if (spec.contains("*")) {
                    this.whitelistedJarPatterns.add(ScanSpec.specToPattern(spec));
                    continue;
                }
                this.whitelistedJars.add(spec);
                continue;
            }
            if (spec.startsWith("dir:")) {
                if (!(spec = spec.substring(4)).isEmpty() && log != null) {
                    log.log("Ignoring extra text after \"dir:\" in scan spec entry: " + scanSpecEntry);
                }
                if (blacklisted) {
                    this.scanDirs = false;
                    continue;
                }
                if (log == null) continue;
                log.log("Ignoring scan spec entry with no effect: \"" + scanSpecEntry + "\"");
                continue;
            }
            String specPath = spec.replace('.', '/');
            if (spec.startsWith("/")) {
                spec = spec.substring(1);
            }
            boolean isClassName = false;
            int lastSlashIdx = specPath.lastIndexOf(47);
            if (lastSlashIdx < specPath.length() - 1) {
                isClassName = Character.isUpperCase(specPath.charAt(lastSlashIdx + 1));
            }
            if (isClassName) {
                if (blacklisted) {
                    this.specificallyBlacklistedClassNames.add(spec);
                    this.specificallyBlacklistedClassRelativePaths.add(specPath + ".class");
                    continue;
                }
                this.specificallyWhitelistedClassRelativePaths.add(specPath + ".class");
                continue;
            }
            if (blacklisted) {
                uniqueBlacklistedPathPrefixes.add(specPath + "/");
                continue;
            }
            uniqueWhitelistedPathPrefixes.add(specPath + "/");
        }
        if (this.blacklistSystemPackages) {
            uniqueBlacklistedPathPrefixes.add("java/");
            uniqueBlacklistedPathPrefixes.add("javax/");
            uniqueBlacklistedPathPrefixes.add("sun/");
        }
        this.blacklistedPathPrefixes.addAll(uniqueBlacklistedPathPrefixes);
        if (uniqueBlacklistedPathPrefixes.contains("/")) {
            if (log != null) {
                log.log("Ignoring blacklist of root package, it would prevent all scanning");
            }
            uniqueBlacklistedPathPrefixes.remove("/");
        }
        for (String prefix : this.blacklistedPathPrefixes) {
            this.blacklistedPackagePrefixes.add(prefix.replace('/', '.'));
        }
        this.specificallyWhitelistedClassRelativePaths.removeAll(this.specificallyBlacklistedClassRelativePaths);
        for (String whitelistedClass : this.specificallyWhitelistedClassRelativePaths) {
            int lastSlashIdx = whitelistedClass.lastIndexOf(47);
            this.specificallyWhitelistedClassParentRelativePaths.add(whitelistedClass.substring(0, lastSlashIdx + 1));
        }
        uniqueWhitelistedPathPrefixes.removeAll(uniqueBlacklistedPathPrefixes);
        this.whitelistedPathPrefixes.addAll(uniqueWhitelistedPathPrefixes);
        if (this.whitelistedPathPrefixes.isEmpty() && this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
            this.whitelistedPathPrefixes.add("/");
        }
        if (this.whitelistedPathPrefixes.contains("/")) {
            this.whitelistedPathPrefixes.add("");
        }
        this.whitelistedJars.removeAll(this.blacklistedJars);
        if (!this.scanJars && !this.scanDirs) {
            if (log != null) {
                log.log("Scanning of jars and dirs are both disabled -- re-enabling scanning of dirs");
            }
            this.scanDirs = true;
        }
        if (log != null) {
            log.log("Whitelisted relative path prefixes:  " + this.whitelistedPathPrefixes);
            if (!this.blacklistedPathPrefixes.isEmpty()) {
                log.log("Blacklisted relative path prefixes:  " + this.blacklistedPathPrefixes);
            }
            if (!this.whitelistedJars.isEmpty()) {
                log.log("Whitelisted jars:  " + this.whitelistedJars);
            }
            if (!this.whitelistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.whitelistedJarPatterns);
            }
            if (!this.blacklistedJars.isEmpty()) {
                log.log("Blacklisted jars:  " + this.blacklistedJars);
            }
            if (!this.blacklistedJarPatterns.isEmpty()) {
                log.log("Whitelisted jars with glob wildcards:  " + this.blacklistedJarPatterns);
            }
            if (!this.specificallyWhitelistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-whitelisted classfiles: " + this.specificallyWhitelistedClassRelativePaths);
            }
            if (!this.specificallyBlacklistedClassRelativePaths.isEmpty()) {
                log.log("Specifically-blacklisted classfiles: " + this.specificallyBlacklistedClassRelativePaths);
            }
            if (!this.scanJars) {
                log.log("Scanning of jarfiles is disabled");
            }
            if (!this.scanDirs) {
                log.log("Scanning of directories (i.e. non-jarfiles) is disabled");
            }
        }
    }

    public void registerClassLoaderHandler(Class<? extends ClassLoaderHandler> classLoaderHandler) {
        this.extraClassLoaderHandlers.add(classLoaderHandler);
    }

    public void overrideClasspath(String overrideClasspath) {
        this.overrideClasspath = overrideClasspath;
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (this.addedClassLoaders == null) {
            this.addedClassLoaders = new ArrayList<ClassLoader>();
        }
        this.addedClassLoaders.add(classLoader);
    }

    public void overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.addedClassLoaders = null;
        this.overrideClassLoaders = Arrays.asList(overrideClassLoaders);
    }

    public void ignoreParentClassLoaders(boolean ignoreParentClassloaders) {
        this.ignoreParentClassLoaders = ignoreParentClassloaders;
    }

    public boolean hasMatchProcessors() {
        return this.filePathTestersAndMatchProcessorWrappers != null && this.filePathTestersAndMatchProcessorWrappers.size() > 0 || this.classMatchers != null && this.classMatchers.size() > 0 || this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null && !this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.isEmpty();
    }

    public void callMatchProcessors(ScanResult scanResult) {
        LogNode log = scanResult.log;
        try {
            List<Throwable> matchProcessorExceptions;
            for (ClasspathElement classpathElement : scanResult.classpathOrder) {
                if (classpathElement.fileMatches == null || classpathElement.fileMatches.isEmpty()) continue;
                classpathElement.callFileMatchProcessors(scanResult, log == null ? null : log.log("Calling FileMatchProcessors for classpath element " + classpathElement));
            }
            if (this.classMatchers != null) {
                for (ClassMatcher classMatcher : this.classMatchers) {
                    classMatcher.lookForMatches(scanResult, log == null ? null : log.log("Calling ClassMatchProcessors"));
                    scanResult.interruptionChecker.check();
                }
            }
            if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors != null) {
                for (Map.Entry entry : this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.getRawMap().entrySet()) {
                    int dotIdx;
                    String fullyQualifiedFieldName = (String)entry.getKey();
                    String className = fullyQualifiedFieldName.substring(0, dotIdx = fullyQualifiedFieldName.lastIndexOf(46));
                    ClassInfo classInfo = scanResult.classGraphBuilder.classNameToClassInfo.get(className);
                    if (classInfo != null) {
                        String fieldName = fullyQualifiedFieldName.substring(dotIdx + 1);
                        Object constValue = classInfo.getStaticFinalFieldConstantInitializerValue(fieldName);
                        if (constValue == null) {
                            if (log == null) continue;
                            log.log("No constant initializer value found for field " + className + "." + fieldName);
                            continue;
                        }
                        List staticFinalFieldMatchProcessors = (List)entry.getValue();
                        if (log != null) {
                            log.log("Calling MatchProcessor" + (staticFinalFieldMatchProcessors.size() == 1 ? "" : "s") + " for static final field " + className + "." + fieldName + " = " + (constValue instanceof Character ? '\'' + constValue.toString().replace("'", "\\'") + '\'' : (constValue instanceof String ? '\"' + constValue.toString().replace("\"", "\\\"") + '\"' : constValue.toString())));
                        }
                        for (StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor : (List)entry.getValue()) {
                            try {
                                staticFinalFieldMatchProcessor.processMatch(className, fieldName, constValue);
                            }
                            catch (Throwable e) {
                                if (log != null) {
                                    log.log("Exception while calling StaticFinalFieldMatchProcessor: " + e);
                                }
                                scanResult.addMatchProcessorException(e);
                            }
                            scanResult.interruptionChecker.check();
                        }
                        continue;
                    }
                    if (log == null) continue;
                    log.log("No matching class found in scan results for static final field " + fullyQualifiedFieldName);
                }
            }
            if ((matchProcessorExceptions = scanResult.getMatchProcessorExceptions()).size() > 0) {
                if (log != null) {
                    log.log("Number of exceptions raised during classloading and/or while calling MatchProcessors: " + matchProcessorExceptions.size());
                }
                throw MatchProcessorException.newInstance(matchProcessorExceptions);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            if (log != null) {
                log.log("Exception while calling MatchProcessors", e);
            }
            throw MatchProcessorException.newInstance(e);
        }
    }

    private static Pattern specToPattern(String spec) {
        return Pattern.compile("^" + spec.replace(".", "\\.").replace("*", ".*") + "$");
    }

    ScanSpecPathMatch pathWhitelistMatchStatus(String relativePath) {
        for (String blacklistedPath : this.blacklistedPathPrefixes) {
            if (!relativePath.startsWith(blacklistedPath)) continue;
            return ScanSpecPathMatch.WITHIN_BLACKLISTED_PATH;
        }
        for (String whitelistedPath : this.whitelistedPathPrefixes) {
            if (this.disableRecursiveScanning && relativePath.equals(whitelistedPath)) {
                return ScanSpecPathMatch.WITHIN_WHITELISTED_PATH;
            }
            if (!this.disableRecursiveScanning && relativePath.startsWith(whitelistedPath)) {
                return ScanSpecPathMatch.WITHIN_WHITELISTED_PATH;
            }
            if (!whitelistedPath.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        if (this.specificallyWhitelistedClassParentRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath)) {
            return ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE;
        }
        for (String whitelistedClassPathPrefix : this.specificallyWhitelistedClassParentRelativePaths) {
            if (!whitelistedClassPathPrefix.startsWith(relativePath) && !"/".equals(relativePath)) continue;
            return ScanSpecPathMatch.ANCESTOR_OF_WHITELISTED_PATH;
        }
        return ScanSpecPathMatch.NOT_WITHIN_WHITELISTED_PATH;
    }

    boolean isSpecificallyWhitelistedClass(String relativePath) {
        return this.specificallyWhitelistedClassRelativePaths.contains(relativePath) && !this.specificallyBlacklistedClassRelativePaths.contains(relativePath);
    }

    boolean classIsBlacklisted(String className) {
        boolean classIsBlacklisted = false;
        if (this.specificallyBlacklistedClassNames.contains(className)) {
            classIsBlacklisted = true;
        } else {
            for (String blacklistedPackagePrefix : this.blacklistedPackagePrefixes) {
                if (!className.startsWith(blacklistedPackagePrefix)) continue;
                classIsBlacklisted = true;
                break;
            }
        }
        return classIsBlacklisted;
    }

    void checkClassIsNotBlacklisted(String className) {
        if (this.strictWhitelist && this.classIsBlacklisted(className)) {
            boolean isSystemPackage = className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.");
            throw new IllegalArgumentException("Can't scan for " + className + ", it is in a blacklisted " + (!isSystemPackage ? "package" : "system package") + ", and and strictWhitelist() was called before scan()." + (!isSystemPackage ? "" : "You can override this by adding \"!\" or \"!!\" to the scan spec to disable system package blacklisting or system jar blacklisting respectively (see the docs)"));
        }
    }

    private static boolean containsJarName(HashSet<String> jarNames, ArrayList<Pattern> jarNamePatterns, String jarName) {
        String jarLeafName = JarUtils.leafName(jarName);
        if (jarNames.contains(jarLeafName)) {
            return true;
        }
        for (Pattern jarNamePattern : jarNamePatterns) {
            if (!jarNamePattern.matcher(jarLeafName).matches()) continue;
            return true;
        }
        return false;
    }

    boolean jarIsWhitelisted(String jarName) {
        String jarLeafName = JarUtils.leafName(jarName);
        return (this.whitelistedJars.isEmpty() && this.whitelistedJarPatterns.isEmpty() || ScanSpec.containsJarName(this.whitelistedJars, this.whitelistedJarPatterns, jarLeafName)) && !ScanSpec.containsJarName(this.blacklistedJars, this.blacklistedJarPatterns, jarLeafName);
    }

    boolean blacklistSystemJars() {
        return this.blacklistSystemJars;
    }

    private Class<?> loadClass(String className, ClassLoader classLoader, LogNode log) throws IllegalArgumentException {
        try {
            return Class.forName(className, this.initializeLoadedClasses, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Throwable e) {
            if (log != null) {
                log.log("Error while loading class " + className, e);
            }
            throw new IllegalArgumentException("Exception while loading class " + className, e);
        }
    }

    Class<?> loadClass(String className, ScanResult scanResult, LogNode log) throws IllegalArgumentException {
        if (scanResult.scanSpec.overrideClasspath != null) {
            throw new IllegalArgumentException("Cannot load classes from custom classpath, defined using .overrideClasspath(), since system classloaders may search a different classpath, and/or may have already loaded and cached a class (which can lead to a class being loaded twice, if a new classloader is defined using the custom classpath). If you want to load classes from a custom classpath at runtime, you need to define your own ClassLoader (e.g. using new URLClassLoader()), and then use .overrideClassLoaders() instead");
        }
        List<ClassLoader> classLoadersForClassName = scanResult.getClassLoadersForClass(className);
        for (ClassLoader classLoader : classLoadersForClassName) {
            Class<?> classRef = this.loadClass(className, classLoader, log);
            if (classRef == null) continue;
            return classRef;
        }
        if (log != null) {
            log.log("No classloader was able to load class " + className);
        }
        throw new IllegalArgumentException("No classloader was able to load class " + className);
    }

    private Class<?> loadClassForMatchProcessor(String className, ScanResult scanResult, LogNode log) throws MatchProcessorException {
        try {
            return this.loadClass(className, scanResult, log);
        }
        catch (IllegalArgumentException e) {
            throw MatchProcessorException.newInstance(e.getCause());
        }
    }

    String getAnnotationName(Class<?> annotation) {
        String annotationName = annotation.getName();
        this.checkClassIsNotBlacklisted(annotationName);
        if (!annotation.isAnnotation()) {
            throw new IllegalArgumentException(annotationName + " is not an annotation");
        }
        return annotation.getName();
    }

    String[] getAnnotationNames(Class<?>[] annotations) {
        String[] annotationNames = new String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationNames[i] = this.getAnnotationName(annotations[i]);
        }
        return annotationNames;
    }

    String getInterfaceName(Class<?> iface) {
        String ifaceName = iface.getName();
        this.checkClassIsNotBlacklisted(ifaceName);
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(ifaceName + " is not an interface");
        }
        return iface.getName();
    }

    String[] getInterfaceNames(Class<?>[] interfaces) {
        String[] interfaceNames = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceNames[i] = this.getInterfaceName(interfaces[i]);
        }
        return interfaceNames;
    }

    String getClassOrInterfaceName(Class<?> classOrInterface) {
        String classOrIfaceName = classOrInterface.getName();
        this.checkClassIsNotBlacklisted(classOrIfaceName);
        if (classOrInterface.isAnnotation()) {
            throw new IllegalArgumentException(classOrIfaceName + " is an annotation, not a regular class or interface");
        }
        return classOrInterface.getName();
    }

    String getStandardClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        if (cls.isAnnotation()) {
            throw new IllegalArgumentException(className + " is an annotation, not a standard class");
        }
        if (cls.isInterface()) {
            throw new IllegalArgumentException(cls.getName() + " is an interface, not a standard class");
        }
        return className;
    }

    private String getClassName(Class<?> cls) {
        String className = cls.getName();
        this.checkClassIsNotBlacklisted(className);
        return className;
    }

    private void addClassMatcher(ClassMatcher classMatcher) {
        if (this.classMatchers == null) {
            this.classMatchers = new ArrayList();
        }
        this.classMatchers.add(classMatcher);
    }

    public void matchAllClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchAllStandardClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllStandardClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched standard class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchAllInterfaceClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllInterfaceClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched interface class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchAllAnnotationClasses(final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                for (String className : scanResult.getNamesOfAllAnnotationClasses()) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched annotation class: " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + className, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchSubclassesOf(final Class<T> superclass, final SubclassMatchProcessor<T> subclassMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String superclassName = ScanSpec.this.getStandardClassName(superclass);
                for (String subclassName : scanResult.getNamesOfSubclassesOf(superclassName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched subclass of " + superclassName + ": " + subclassName);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(subclassName, scanResult, log);
                        subclassMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + subclassName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchSubinterfacesOf(final Class<T> superinterface, final SubinterfaceMatchProcessor<T> subinterfaceMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String superinterfaceName = ScanSpec.this.getInterfaceName(superinterface);
                for (String subinterfaceName : scanResult.getNamesOfSubinterfacesOf(superinterfaceName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched subinterface of " + superinterfaceName + ": " + subinterfaceName);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(subinterfaceName, scanResult, log);
                        subinterfaceMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + subinterfaceName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchClassesImplementing(final Class<T> implementedInterface, final ImplementingClassMatchProcessor<T> implementingClassMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String implementedInterfaceName = ScanSpec.this.getInterfaceName(implementedInterface);
                for (String implementingClassName : scanResult.getNamesOfClassesImplementing(implementedInterfaceName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class implementing interface " + implementedInterfaceName + ": " + implementingClassName);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(implementingClassName, scanResult, log);
                        implementingClassMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + implementingClassName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public <T> void matchClassesWithFieldOfType(final Class<T> fieldType, final ClassMatchProcessor classMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String fieldTypeName = ScanSpec.this.getClassName(fieldType);
                for (String className : scanResult.getNamesOfClassesWithFieldOfType(fieldTypeName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class with field of type " + fieldTypeName + ": " + className);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(className, scanResult, log);
                        classMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + fieldTypeName, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchClassesWithAnnotation(final Class<?> annotation, final ClassAnnotationMatchProcessor classAnnotationMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithAnnotation : scanResult.getNamesOfClassesWithAnnotation(annotationName)) {
                    LogNode subLog = null;
                    if (log != null) {
                        subLog = log.log("Matched class with annotation " + annotationName + ": " + classWithAnnotation);
                    }
                    try {
                        Class cls = ScanSpec.this.loadClassForMatchProcessor(classWithAnnotation, scanResult, log);
                        classAnnotationMatchProcessor.processMatch(cls);
                    }
                    catch (Throwable e) {
                        if (subLog != null) {
                            subLog.log("Exception while processing match for class " + classWithAnnotation, e);
                        }
                        scanResult.addMatchProcessorException(e);
                    }
                }
            }
        });
    }

    public void matchClassesWithMethodAnnotation(final Class<? extends Annotation> annotation, final MethodAnnotationMatchProcessor methodAnnotationMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithMethodAnnotation : scanResult.getNamesOfClassesWithMethodAnnotation(annotationName)) {
                    LogNode subLog;
                    Class cls = null;
                    try {
                        cls = ScanSpec.this.loadClassForMatchProcessor(classWithMethodAnnotation, scanResult, log);
                    }
                    catch (Throwable e) {
                        if (log != null) {
                            log.log("Exception while loading class " + classWithMethodAnnotation, e);
                        }
                        scanResult.addMatchProcessorException(e);
                        return;
                    }
                    for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                        if (!ScanSpec.this.ignoreMethodVisibility && (constructor.getModifiers() & 1) == 0 || !constructor.isAnnotationPresent(annotation)) continue;
                        subLog = null;
                        if (log != null) {
                            subLog = log.log("Constructor matched method annotation " + annotationName + ": " + constructor);
                        }
                        try {
                            methodAnnotationMatchProcessor.processMatch(cls, constructor);
                        }
                        catch (Throwable e) {
                            if (subLog != null) {
                                subLog.log("Exception while processing match for class " + classWithMethodAnnotation, e);
                            }
                            scanResult.addMatchProcessorException(e);
                        }
                    }
                    for (Executable executable : cls.getDeclaredMethods()) {
                        if (!ScanSpec.this.ignoreMethodVisibility && (((Method)executable).getModifiers() & 1) == 0 || !executable.isAnnotationPresent(annotation)) continue;
                        subLog = null;
                        if (log != null) {
                            subLog = log.log("Matched method annotation " + annotationName + ": " + executable);
                        }
                        try {
                            methodAnnotationMatchProcessor.processMatch(cls, executable);
                        }
                        catch (Throwable e) {
                            if (subLog != null) {
                                subLog.log("Exception while processing match for class " + classWithMethodAnnotation, e);
                            }
                            scanResult.addMatchProcessorException(e);
                        }
                    }
                }
            }
        });
    }

    public void matchClassesWithFieldAnnotation(final Class<? extends Annotation> annotation, final FieldAnnotationMatchProcessor fieldAnnotationMatchProcessor) {
        this.addClassMatcher(new ClassMatcher(){

            @Override
            public void lookForMatches(ScanResult scanResult, LogNode log) {
                String annotationName = ScanSpec.this.getAnnotationName(annotation);
                for (String classWithFieldAnnotation : scanResult.getNamesOfClassesWithFieldAnnotation(annotationName)) {
                    Class cls = null;
                    try {
                        cls = ScanSpec.this.loadClassForMatchProcessor(classWithFieldAnnotation, scanResult, log);
                    }
                    catch (Throwable e) {
                        if (log != null) {
                            log.log("Exception while loading class " + classWithFieldAnnotation, e);
                        }
                        scanResult.addMatchProcessorException(e);
                        return;
                    }
                    for (Field field : ScanSpec.this.ignoreFieldVisibility ? cls.getDeclaredFields() : cls.getFields()) {
                        if (!field.isAnnotationPresent(annotation)) continue;
                        LogNode subLog = null;
                        if (log != null) {
                            subLog = log.log("Matched field annotation " + annotationName + ": " + field);
                        }
                        try {
                            fieldAnnotationMatchProcessor.processMatch(cls, field);
                        }
                        catch (Throwable e) {
                            if (subLog != null) {
                                subLog.log("Exception while processing match for class " + classWithFieldAnnotation, e);
                            }
                            scanResult.addMatchProcessorException(e);
                        }
                    }
                }
            }
        });
    }

    private void addStaticFinalFieldProcessor(String className, String fieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        String fullyQualifiedFieldName = className + "." + fieldName;
        if (this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors == null) {
            this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors = new MultiMapKeyToList();
            this.classNameToStaticFinalFieldsToMatch = new MultiMapKeyToSet();
        }
        this.fullyQualifiedFieldNameToStaticFinalFieldMatchProcessors.put(fullyQualifiedFieldName, staticFinalFieldMatchProcessor);
        this.classNameToStaticFinalFieldsToMatch.put(className, fieldName);
    }

    public void matchStaticFinalFieldNames(Set<String> fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            int lastDotIdx = fullyQualifiedFieldName.lastIndexOf(46);
            if (lastDotIdx <= 0) continue;
            String className = fullyQualifiedFieldName.substring(0, lastDotIdx);
            String fieldName = fullyQualifiedFieldName.substring(lastDotIdx + 1);
            this.addStaticFinalFieldProcessor(className, fieldName, staticFinalFieldMatchProcessor);
        }
    }

    public void matchStaticFinalFieldNames(String fullyQualifiedStaticFinalFieldName, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedStaticFinalFieldName);
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    public void matchStaticFinalFieldNames(String[] fullyQualifiedStaticFinalFieldNames, StaticFinalFieldMatchProcessor staticFinalFieldMatchProcessor) {
        HashSet<String> fullyQualifiedStaticFinalFieldNamesSet = new HashSet<String>();
        for (String fullyQualifiedFieldName : fullyQualifiedStaticFinalFieldNames) {
            fullyQualifiedStaticFinalFieldNamesSet.add(fullyQualifiedFieldName);
        }
        this.matchStaticFinalFieldNames(fullyQualifiedStaticFinalFieldNamesSet, staticFinalFieldMatchProcessor);
    }

    private void addFilePathMatcher(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
        this.filePathTestersAndMatchProcessorWrappers.add(new FilePathTesterAndMatchProcessorWrapper(filePathTester, fileMatchProcessorWrapper));
    }

    List<FilePathTesterAndMatchProcessorWrapper> getFilePathTestersAndMatchProcessorWrappers() {
        return this.filePathTestersAndMatchProcessorWrappers;
    }

    private static byte[] readAllBytes(InputStream inputStream, long fileSize) throws IOException {
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException("File larger that 2GB, cannot read contents into a Java array");
        }
        byte[] bytes = new byte[(int)fileSize];
        int bytesRead = inputStream.read(bytes);
        if ((long)bytesRead < fileSize) {
            throw new IOException("Could not read whole file");
        }
        return bytes;
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessor fileMatchProcessor) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessor.processMatch(relativePath, inputStream, fileSize);
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchProcessorWithContext.processMatch(classpathElt, relativePath, inputStream, fileSize);
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessor fileMatchContentsProcessor) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessor.processMatch(relativePath, ScanSpec.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private static FileMatchProcessorWrapper makeFileMatchProcessorWrapper(final FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        return new FileMatchProcessorWrapper(){

            @Override
            public void processMatch(File classpathElt, String relativePath, InputStream inputStream, long fileSize) throws IOException {
                fileMatchContentsProcessorWithContext.processMatch(classpathElt, relativePath, ScanSpec.readAllBytes(inputStream, fileSize));
            }
        };
    }

    private FilePathTester makeFilePathTesterMatchingRegexp(final String pathRegexp) {
        return new FilePathTester(){
            private final Pattern pattern;
            {
                this.pattern = Pattern.compile(pathRegexp);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                boolean matched = this.pattern.matcher(relativePathStr).matches();
                if (matched && log != null) {
                    log.log("File " + relativePathStr + " matched filename pattern " + pathRegexp);
                }
                return matched;
            }
        };
    }

    public void matchFilenamePattern(String pathRegexp, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public void matchFilenamePattern(String pathRegexp, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public void matchFilenamePattern(String pathRegexp, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public void matchFilenamePattern(String pathRegexp, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRegexp(pathRegexp), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    private FilePathTester makeFilePathTesterMatchingRelativePath(final String relativePathToMatch) {
        return new FilePathTester(){

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                boolean matched = relativePathStr.equals(relativePathToMatch);
                if (matched && log != null) {
                    log.log("Matched filename path " + relativePathToMatch);
                }
                return matched;
            }
        };
    }

    public void matchFilenamePath(String relativePathToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public void matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public void matchFilenamePath(String relativePathToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public void matchFilenamePath(String relativePathToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingRelativePath(relativePathToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    private FilePathTester makeFilePathTesterMatchingPathLeaf(final String pathLeafToMatch) {
        return new FilePathTester(){
            private final String leafToMatch;
            {
                this.leafToMatch = pathLeafToMatch.substring(pathLeafToMatch.lastIndexOf(47) + 1);
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
                String relativePathLeaf = relativePathStr.substring(relativePathStr.lastIndexOf(47) + 1);
                boolean matched = relativePathLeaf.equals(this.leafToMatch);
                if (matched && log != null) {
                    log.log("File " + relativePathStr + " matched path leaf " + pathLeafToMatch);
                }
                return matched;
            }
        };
    }

    public void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public void matchFilenamePathLeaf(String pathLeafToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingPathLeaf(pathLeafToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    private FilePathTester makeFilePathTesterMatchingFilenameExtension(final String extensionToMatch) {
        return new FilePathTester(){
            final int extLen;
            {
                this.extLen = extensionToMatch.length();
            }

            @Override
            public boolean filePathMatches(File classpathElt, String relativePath, LogNode log) {
                boolean matched;
                int relativePathLen = relativePath.length();
                int extIdx = relativePathLen - this.extLen;
                boolean bl = matched = relativePathLen > this.extLen + 1 && relativePath.charAt(extIdx - 1) == '.' && relativePath.regionMatches(true, extIdx, extensionToMatch, 0, this.extLen);
                if (matched && log != null) {
                    log.log("File " + relativePath + " matched extension ." + extensionToMatch);
                }
                return matched;
            }
        };
    }

    public void matchFilenameExtension(String extensionToMatch, FileMatchProcessor fileMatchProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessor));
    }

    public void matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessor fileMatchContentsProcessor) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessor));
    }

    public void matchFilenameExtension(String extensionToMatch, FileMatchProcessorWithContext fileMatchProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchProcessorWithContext));
    }

    public void matchFilenameExtension(String extensionToMatch, FileMatchContentsProcessorWithContext fileMatchContentsProcessorWithContext) {
        this.addFilePathMatcher(this.makeFilePathTesterMatchingFilenameExtension(extensionToMatch), ScanSpec.makeFileMatchProcessorWrapper(fileMatchContentsProcessorWithContext));
    }

    static class FilePathTesterAndMatchProcessorWrapper {
        private final FilePathTester filePathTester;
        FileMatchProcessorWrapper fileMatchProcessorWrapper;

        private FilePathTesterAndMatchProcessorWrapper(FilePathTester filePathTester, FileMatchProcessorWrapper fileMatchProcessorWrapper) {
            this.filePathTester = filePathTester;
            this.fileMatchProcessorWrapper = fileMatchProcessorWrapper;
        }

        boolean filePathMatches(File classpathElt, String relativePathStr, LogNode log) {
            return this.filePathTester.filePathMatches(classpathElt, relativePathStr, log);
        }
    }

    static interface FileMatchProcessorWrapper {
        public void processMatch(File var1, String var2, InputStream var3, long var4) throws IOException;
    }

    private static interface FilePathTester {
        public boolean filePathMatches(File var1, String var2, LogNode var3);
    }

    static enum ScanSpecPathMatch {
        WITHIN_BLACKLISTED_PATH,
        WITHIN_WHITELISTED_PATH,
        ANCESTOR_OF_WHITELISTED_PATH,
        AT_WHITELISTED_CLASS_PACKAGE,
        NOT_WITHIN_WHITELISTED_PATH;

    }

    private static interface ClassMatcher {
        public void lookForMatches(ScanResult var1, LogNode var2);
    }
}

