/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.scanner;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.common.collections.Lists;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.core.metamodel.scanner.AnnotationsNameSpace;
import org.javers.core.metamodel.scanner.JPAAnnotationsNameSpace;
import org.javers.core.metamodel.scanner.JaversAnnotationsNameSpace;

class AnnotationNamesProvider {
    private final Set<String> entityAliases = new HashSet<String>();
    private final Set<String> typeNameAliases = new HashSet<String>();
    private final Set<String> valueObjectAliases = new HashSet<String>();
    private final Set<String> valueAliases = new HashSet<String>();
    private final Set<String> transientPropertyAliases = new HashSet<String>();
    private final Set<String> propertyNameAliases = new HashSet<String>();
    private final List<AnnotationsNameSpace> namesProviders = Lists.immutableListOf(new JPAAnnotationsNameSpace());

    AnnotationNamesProvider() {
        for (AnnotationsNameSpace provider : this.namesProviders) {
            this.entityAliases.addAll(provider.getEntityAliases());
            this.valueObjectAliases.addAll(provider.getValueObjectAliases());
            this.valueAliases.addAll(provider.getValueAliases());
            this.transientPropertyAliases.addAll(provider.getTransientPropertyAliases());
            this.typeNameAliases.addAll(provider.getTypeNameAliases());
            this.propertyNameAliases.addAll(provider.getPropertyNameAliases());
        }
    }

    boolean hasEntityAnnAlias(Set<Class<? extends Annotation>> annTypes) {
        return annTypes.stream().anyMatch(annType -> this.entityAliases.contains(annType.getSimpleName()));
    }

    boolean hasValueObjectAnnAlias(Set<Class<? extends Annotation>> annTypes) {
        return annTypes.stream().anyMatch(annType -> this.valueObjectAliases.contains(annType.getSimpleName()));
    }

    boolean hasValueAnnAlias(Set<Class<? extends Annotation>> annTypes) {
        return annTypes.stream().anyMatch(annType -> this.valueAliases.contains(annType.getSimpleName()));
    }

    boolean hasTransientPropertyAnn(Set<Class<? extends Annotation>> annTypes) {
        return annTypes.contains(JaversAnnotationsNameSpace.DIFF_IGNORE_ANN) || annTypes.stream().anyMatch(annType -> this.transientPropertyAliases.contains(annType.getSimpleName()));
    }

    boolean hasShallowReferenceAnn(Set<Class<? extends Annotation>> annTypes) {
        return annTypes.contains(JaversAnnotationsNameSpace.SHALLOW_REFERENCE_ANN);
    }

    Optional<String> findTypeNameAnnValue(Set<Annotation> annotations) {
        return this.getAnnotationValue(annotations, JaversAnnotationsNameSpace.TYPE_NAME_ANN, this.typeNameAliases);
    }

    Optional<String> findPropertyNameAnnValue(Set<Annotation> annotations) {
        return this.getAnnotationValue(annotations, JaversAnnotationsNameSpace.PROPERTY_NAME_ANN, this.propertyNameAliases);
    }

    private Optional<String> getAnnotationValue(Set<Annotation> annotations, Class<? extends Annotation> javersAnnType, Set<String> aliases) {
        Optional<Annotation> annotation = this.findAnnotation(annotations, javersAnnType, aliases);
        return annotation.map(ann -> (String)ReflectionUtil.getAnnotationValue(ann, "value"));
    }

    private Optional<Annotation> findAnnotation(Set<Annotation> annotations, Class<? extends Annotation> javersAnnType, Set<String> aliases) {
        Optional<Annotation> jTypeName = annotations.stream().filter(ann -> javersAnnType.isAssignableFrom(ann.getClass())).findAny();
        if (jTypeName.isPresent()) {
            return jTypeName;
        }
        return annotations.stream().filter(ann -> aliases.contains(ann.annotationType().getSimpleName())).findFirst();
    }
}

