/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.classloaderhandler;

import io.github.lukehutch.fastclasspathscanner.classloaderhandler.ClassLoaderHandler;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathFinder;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;

public class WeblogicClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public boolean handle(ClassLoader classLoader, ClasspathFinder classpathFinder, LogNode log) throws Exception {
        for (Class<?> c = classLoader.getClass(); c != null; c = c.getSuperclass()) {
            if (!"weblogic.utils.classloaders.ChangeAwareClassLoader".equals(c.getName())) continue;
            String classpath = (String)ReflectionUtils.invokeMethod(classLoader, "getClassPath");
            return classpathFinder.addClasspathElements(classpath, classLoader, log);
        }
        return false;
    }
}

