/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.scanner.ClassInfoUnlinked;
import io.github.lukehutch.fastclasspathscanner.scanner.ClassfileBinaryParser;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementDir;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathElementZip;
import io.github.lukehutch.fastclasspathscanner.scanner.ClasspathRelativePath;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanSpec;
import io.github.lukehutch.fastclasspathscanner.utils.ClasspathUtils;
import io.github.lukehutch.fastclasspathscanner.utils.InterruptionChecker;
import io.github.lukehutch.fastclasspathscanner.utils.LogNode;
import io.github.lukehutch.fastclasspathscanner.utils.MultiMapKeyToList;
import io.github.lukehutch.fastclasspathscanner.utils.NestedJarHandler;
import io.github.lukehutch.fastclasspathscanner.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;

abstract class ClasspathElement {
    final ClasspathRelativePath classpathEltPath;
    Set<String> nestedClasspathRoots;
    boolean ioExceptionOnOpen;
    List<ClasspathRelativePath> childClasspathElts;
    final ScanSpec scanSpec;
    private final boolean scanFiles;
    protected InterruptionChecker interruptionChecker;
    protected MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource> fileMatches;
    protected List<ClasspathResource> classfileMatches;
    protected Map<File, Long> fileToLastModified;

    ClasspathElement(ClasspathRelativePath classpathEltPath, ScanSpec scanSpec, boolean scanFiles, InterruptionChecker interruptionChecker) {
        this.classpathEltPath = classpathEltPath;
        this.scanSpec = scanSpec;
        this.scanFiles = scanFiles;
        this.interruptionChecker = interruptionChecker;
    }

    public String toString() {
        return this.getClasspathElementFilePath();
    }

    public URL getClasspathElementURL() {
        try {
            return this.getClasspathElementFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public File getClasspathElementFile() {
        try {
            return this.classpathEltPath.getFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getClasspathElementFilePath() {
        return this.classpathEltPath.toString();
    }

    public List<ClassLoader> getClassLoaders() {
        return this.classpathEltPath.getClassLoaders();
    }

    static ClasspathElement newInstance(ClasspathRelativePath classpathRelativePath, boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathRelativePath> workQueue, InterruptionChecker interruptionChecker, LogNode log) {
        ClasspathElement newInstance;
        String canonicalPath;
        boolean isDir;
        File file;
        try {
            file = classpathRelativePath.getFile();
            isDir = classpathRelativePath.isDirectory();
            canonicalPath = classpathRelativePath.getCanonicalPath();
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathRelativePath.getResolvedPath(), e);
            }
            return null;
        }
        LogNode logNode = log == null ? null : log.log(canonicalPath, "Scanning " + (isDir ? "directory " : "jarfile ") + "classpath entry " + classpathRelativePath + (file.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        ClasspathElement classpathElement = newInstance = isDir ? new ClasspathElementDir(classpathRelativePath, scanSpec, scanFiles, interruptionChecker, logNode) : new ClasspathElementZip(classpathRelativePath, scanSpec, scanFiles, nestedJarHandler, workQueue, interruptionChecker, logNode);
        if (logNode != null) {
            logNode.addElapsedTime();
        }
        return newInstance;
    }

    public int getNumClassfileMatches() {
        return this.classfileMatches == null ? 0 : this.classfileMatches.size();
    }

    void maskFiles(int classpathIdx, HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!this.scanFiles) {
            throw new IllegalArgumentException("scanFiles is false");
        }
        HashSet<String> allMatchingRelativePathsForThisClasspathElement = new HashSet<String>();
        for (ClasspathResource classpathResource : this.classfileMatches) {
            allMatchingRelativePathsForThisClasspathElement.add(classpathResource.pathRelativeToClasspathPrefix);
        }
        for (Map.Entry entry : this.fileMatches.entrySet()) {
            for (ClasspathResource classpathResource : (List)entry.getValue()) {
                allMatchingRelativePathsForThisClasspathElement.add(classpathResource.pathRelativeToClasspathPrefix);
            }
        }
        HashSet<String> maskedRelativePaths = new HashSet<String>();
        for (String string : allMatchingRelativePathsForThisClasspathElement) {
            if (!classpathRelativePathsFound.contains(string)) continue;
            maskedRelativePaths.add(string);
        }
        if (!maskedRelativePaths.isEmpty()) {
            ArrayList<ClasspathResource> arrayList = new ArrayList<ClasspathResource>();
            for (ClasspathResource classfileMatch : this.classfileMatches) {
                if (!maskedRelativePaths.contains(classfileMatch.pathRelativeToClasspathPrefix)) {
                    arrayList.add(classfileMatch);
                    continue;
                }
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + classfileMatch.pathRelativeToClasspathPrefix.replace('/', '.') + " for classpath element " + classfileMatch);
            }
            this.classfileMatches = arrayList;
            MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource> multiMapKeyToList = new MultiMapKeyToList<ScanSpec.FileMatchProcessorWrapper, ClasspathResource>();
            for (Map.Entry<ScanSpec.FileMatchProcessorWrapper, List<ClasspathResource>> ent : this.fileMatches.entrySet()) {
                for (ClasspathResource fileMatch : ent.getValue()) {
                    if (!maskedRelativePaths.contains(fileMatch.pathRelativeToClasspathPrefix)) {
                        multiMapKeyToList.put(ent.getKey(), fileMatch);
                        continue;
                    }
                    if (log == null) continue;
                    log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) file path " + fileMatch.pathRelativeToClasspathPrefix + " in classpath element " + fileMatch);
                }
            }
            this.fileMatches = multiMapKeyToList;
        }
        classpathRelativePathsFound.addAll(allMatchingRelativePathsForThisClasspathElement);
    }

    void callFileMatchProcessors(ScanResult scanResult, LogNode log) throws InterruptedException, ExecutionException {
        for (Map.Entry<ScanSpec.FileMatchProcessorWrapper, List<ClasspathResource>> ent : this.fileMatches.entrySet()) {
            ScanSpec.FileMatchProcessorWrapper fileMatchProcessorWrapper = ent.getKey();
            for (ClasspathResource fileMatch : ent.getValue()) {
                try {
                    LogNode logNode = log == null ? null : log.log("Calling MatchProcessor for matching file " + fileMatch);
                    this.openInputStreamAndProcessFileMatch(fileMatch, fileMatchProcessorWrapper);
                    if (logNode != null) {
                        logNode.addElapsedTime();
                    }
                }
                catch (IOException e) {
                    if (log != null) {
                        log.log("Exception while opening file " + fileMatch, e);
                    }
                }
                catch (Throwable e) {
                    if (log != null) {
                        log.log("Exception while calling FileMatchProcessor for file " + fileMatch, e);
                    }
                    scanResult.addMatchProcessorException(e);
                }
                this.interruptionChecker.check();
            }
        }
    }

    protected abstract void openInputStreamAndProcessFileMatch(ClasspathResource var1, ScanSpec.FileMatchProcessorWrapper var2) throws IOException;

    void parseClassfiles(ClassfileBinaryParser classfileBinaryParser, int classfileStartIdx, int classfileEndIdx, ConcurrentHashMap<String, String> stringInternMap, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws Exception {
        for (int i = classfileStartIdx; i < classfileEndIdx; ++i) {
            ClasspathResource classfileResource = this.classfileMatches.get(i);
            try {
                LogNode logNode = log == null ? null : log.log("Parsing classfile " + classfileResource);
                this.openInputStreamAndParseClassfile(classfileResource, classfileBinaryParser, this.scanSpec, stringInternMap, classInfoUnlinked, logNode);
                if (logNode != null) {
                    logNode.addElapsedTime();
                }
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("IOException while attempting to read classfile " + classfileResource + " -- skipping", e);
                }
            }
            catch (Exception e) {
                if (log != null) {
                    log.log("Exception while parsing classfile " + classfileResource, e);
                }
                throw e;
            }
            this.interruptionChecker.check();
        }
    }

    protected abstract void openInputStreamAndParseClassfile(ClasspathResource var1, ClassfileBinaryParser var2, ScanSpec var3, ConcurrentHashMap<String, String> var4, ConcurrentLinkedQueue<ClassInfoUnlinked> var5, LogNode var6) throws IOException, InterruptedException;

    public abstract void scanPaths(LogNode var1);

    public abstract void close();

    static class ClasspathResource {
        final File classpathEltFile;
        final String pathRelativeToClasspathElt;
        final String pathRelativeToClasspathPrefix;

        private ClasspathResource(File classpathEltFile, String pathRelativeToClasspathElt, String pathRelativeToClasspathPrefix) {
            this.classpathEltFile = classpathEltFile;
            this.pathRelativeToClasspathElt = pathRelativeToClasspathElt;
            this.pathRelativeToClasspathPrefix = pathRelativeToClasspathPrefix;
        }

        static class ClasspathResourceInZipFile
        extends ClasspathResource {
            final ZipEntry zipEntry;

            ClasspathResourceInZipFile(File classpathEltFile, String pathRelativeToClasspathElt, String pathRelativeToClasspathPrefix, ZipEntry zipEntry) {
                super(classpathEltFile, pathRelativeToClasspathElt, pathRelativeToClasspathPrefix);
                this.zipEntry = zipEntry;
            }

            public String toString() {
                return ClasspathUtils.getClasspathResourceURL(this.classpathEltFile, this.pathRelativeToClasspathElt).toString();
            }
        }

        static class ClasspathResourceInDir
        extends ClasspathResource {
            final File relativePathFile;

            ClasspathResourceInDir(File classpathEltFile, String pathRelativeToClasspathElt, File relativePathFile) {
                super(classpathEltFile, pathRelativeToClasspathElt, pathRelativeToClasspathElt);
                this.relativePathFile = relativePathFile;
            }

            public String toString() {
                return ClasspathUtils.getClasspathResourceURL(this.classpathEltFile, this.pathRelativeToClasspathElt).toString();
            }
        }
    }
}

