/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static Object getFieldVal(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Field field = classOrSuperclass.getDeclaredField(fieldName);
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return field.get(obj);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, new Class[0]);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeMethod(Object obj, String methodName, Class<?> argType, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (obj != null) {
            for (Class<?> classOrSuperclass = obj.getClass(); classOrSuperclass != null; classOrSuperclass = classOrSuperclass.getSuperclass()) {
                try {
                    Method method = classOrSuperclass.getDeclaredMethod(methodName, argType);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    return method.invoke(obj, arg);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, new Class[0]);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object invokeStaticMethod(Class<?> cls, String methodName, Class<?> argType, Object arg) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (cls != null) {
            try {
                Method method = cls.getDeclaredMethod(methodName, argType);
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(null, arg);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String modifiersToString(int modifiers, boolean isMethod) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 1) != 0) {
            buf.append("public");
        } else if ((modifiers & 4) != 0) {
            buf.append("protected");
        } else if ((modifiers & 2) != 0) {
            buf.append("private");
        }
        if ((modifiers & 8) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("static");
        }
        if ((modifiers & 0x400) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("abstract");
        }
        if ((modifiers & 0x20) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("synchronized");
        }
        if (!isMethod && (modifiers & 0x80) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("transient");
        } else if ((modifiers & 0x40) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            if (!isMethod) {
                buf.append("volatile");
            } else {
                buf.append("bridge");
            }
        }
        if ((modifiers & 0x10) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("final");
        }
        if ((modifiers & 0x100) != 0) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("native");
        }
        return buf.toString();
    }

    public static List<String> parseTypeDescriptor(String typeDescriptor) {
        ArrayList<String> types = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < typeDescriptor.length(); ++i) {
            int numDims = 0;
            char c = typeDescriptor.charAt(i);
            if (c == '(' || c == ')') continue;
            if (c == '[') {
                numDims = 1;
                ++i;
                while (i < typeDescriptor.length() && (c = typeDescriptor.charAt(i)) == '[') {
                    ++numDims;
                    ++i;
                }
                if (i == typeDescriptor.length()) {
                    throw new RuntimeException("Invalid type descriptor: " + typeDescriptor);
                }
            }
            switch (c) {
                case 'B': {
                    buf.append("byte");
                    break;
                }
                case 'C': {
                    buf.append("char");
                    break;
                }
                case 'D': {
                    buf.append("double");
                    break;
                }
                case 'F': {
                    buf.append("float");
                    break;
                }
                case 'I': {
                    buf.append("int");
                    break;
                }
                case 'J': {
                    buf.append("long");
                    break;
                }
                case 'S': {
                    buf.append("short");
                    break;
                }
                case 'Z': {
                    buf.append("boolean");
                    break;
                }
                case 'V': {
                    buf.append("void");
                    break;
                }
                case 'L': {
                    int semicolonIdx = typeDescriptor.indexOf(59, i + 1);
                    if (semicolonIdx < 0) {
                        throw new RuntimeException("Invalid type descriptor: " + typeDescriptor);
                    }
                    String className = typeDescriptor.substring(i + 1, semicolonIdx).replace('/', '.');
                    if (className.isEmpty()) {
                        throw new RuntimeException("Invalid type descriptor: " + typeDescriptor);
                    }
                    if (className.startsWith("java.lang.") || className.startsWith("java.util.")) {
                        className = className.substring(10);
                    }
                    buf.append(className);
                    i = semicolonIdx;
                }
            }
            for (int j = 0; j < numDims; ++j) {
                buf.append("[]");
            }
            types.add(buf.toString());
            buf.setLength(0);
        }
        return types;
    }
}

