/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukehutch.fastclasspathscanner.scanner;

import io.github.lukehutch.fastclasspathscanner.utils.ReflectionUtils;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;

public class MethodInfo {
    private final String methodName;
    private final int modifiers;
    private final List<String> annotationNames;
    private final List<String> parameterTypeStrs;
    private final String returnTypeStr;
    private final boolean isConstructor;

    public MethodInfo(String methodName, int modifiers, String typeDescriptor, List<String> annotationNames, boolean isConstructor) {
        this.methodName = methodName;
        this.modifiers = modifiers;
        List<String> typeNames = ReflectionUtils.parseTypeDescriptor(typeDescriptor);
        if (typeNames.size() < 1) {
            throw new IllegalArgumentException("Invalid type descriptor for method: " + typeDescriptor);
        }
        this.parameterTypeStrs = typeNames.subList(0, typeNames.size() - 1);
        this.returnTypeStr = typeNames.get(typeNames.size() - 1);
        this.annotationNames = annotationNames.isEmpty() ? Collections.emptyList() : annotationNames;
        this.isConstructor = isConstructor;
    }

    public String getModifiers() {
        return ReflectionUtils.modifiersToString(this.modifiers, true);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getAccessFlags() {
        return this.modifiers;
    }

    public String getReturnTypeStr() {
        return this.returnTypeStr;
    }

    public List<String> getParameterTypeStrs() {
        return this.parameterTypeStrs;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public List<String> getAnnotationNames() {
        return this.annotationNames;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (!this.annotationNames.isEmpty()) {
            for (String annotationName : this.annotationNames) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append("@" + annotationName);
            }
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getModifiers());
        if (!this.isConstructor) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(this.getReturnTypeStr());
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.methodName);
        buf.append('(');
        List<String> paramTypes = this.getParameterTypeStrs();
        boolean isVarargs = this.isVarArgs();
        for (int i = 0; i < paramTypes.size(); ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            String paramType = paramTypes.get(i);
            if (isVarargs && i == paramTypes.size() - 1) {
                if (!paramType.endsWith("[]")) {
                    throw new IllegalArgumentException("Got non-array type for last parameter of varargs method " + this.methodName);
                }
                buf.append(paramType.substring(0, paramType.length() - 2));
                buf.append("...");
                continue;
            }
            buf.append(paramType);
        }
        buf.append(')');
        return buf.toString();
    }
}

