/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;

public class EntityType
extends ManagedType {
    private final JaversProperty idProperty;

    EntityType(ManagedClass entity, JaversProperty idProperty, Optional<String> typeName) {
        super(entity, typeName);
        Validate.argumentIsNotNull(idProperty);
        this.idProperty = idProperty;
    }

    EntityType(ManagedClass entity, JaversProperty idProperty) {
        this(entity, idProperty, Optional.empty());
    }

    @Override
    EntityType spawn(ManagedClass managedClass, Optional<String> typeName) {
        return new EntityType(managedClass, managedClass.getProperty(this.idProperty.getName()), typeName);
    }

    public Type getIdPropertyGenericType() {
        return this.getIdProperty().getGenericType();
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, "baseType", this.getBaseJavaType(), "id", this.getIdProperty().getName());
    }

    @Override
    protected PrettyPrintBuilder prettyPrintBuilder() {
        return super.prettyPrintBuilder().addField("idProperty", this.getIdProperty().getName());
    }

    public JaversProperty getIdProperty() {
        return this.idProperty;
    }

    public InstanceId createIdFromInstance(Object instance) {
        return this.createIdFromLocalId(this.getIdOf(instance));
    }

    public InstanceId createIdFromLocalId(Object localId) {
        return new InstanceId(this.getName(), localId, this.localIdAsString(localId));
    }

    private Object getIdOf(Object instance) {
        Validate.argumentIsNotNull(instance);
        if (!this.isInstance(instance)) {
            throw new JaversException(JaversExceptionCode.NOT_INSTANCE_OF, this.getName(), instance.getClass().getName());
        }
        Object cdoId = this.getIdProperty().get(instance);
        if (cdoId == null) {
            throw new JaversException(JaversExceptionCode.ENTITY_INSTANCE_WITH_NULL_ID, this.getName(), this.getIdProperty().getName());
        }
        return cdoId;
    }

    private String localIdAsString(Object localId) {
        PrimitiveOrValueType idPropertyType = (PrimitiveOrValueType)this.getIdProperty().getType();
        return idPropertyType.smartToString(localId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityType)) {
            return false;
        }
        EntityType that = (EntityType)o;
        return super.equals(that) && this.idProperty.equals(that.idProperty);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.idProperty.hashCode();
    }
}

