/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.core.graph.ObjectAccessProxy;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdPathParser;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.snapshot.ObjectHasher;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.UnboundedValueObjectIdDTO;
import org.javers.repository.jql.ValueObjectIdDTO;
import org.picocontainer.PicoContainer;

public class GlobalIdFactory {
    private final TypeMapper typeMapper;
    private ObjectAccessHook objectAccessHook;
    private final GlobalIdPathParser pathParser;
    private ObjectHasher objectHasher;
    private final PicoContainer picoContainer;

    public GlobalIdFactory(TypeMapper typeMapper, ObjectAccessHook objectAccessHook, PicoContainer container) {
        this.typeMapper = typeMapper;
        this.objectAccessHook = objectAccessHook;
        this.pathParser = new GlobalIdPathParser(typeMapper);
        this.picoContainer = container;
    }

    public GlobalId createId(Object targetCdo) {
        return this.createId(targetCdo, null);
    }

    public GlobalId createId(Object targetCdo, OwnerContext ownerContext) {
        Validate.argumentsAreNotNull(targetCdo);
        Optional<ObjectAccessProxy<Object>> cdoProxy = this.objectAccessHook.createAccessor(targetCdo);
        Class<?> targetClass = cdoProxy.map(p -> p.getTargetClass()).orElse(targetCdo.getClass());
        ManagedType targetManagedType = this.typeMapper.getJaversManagedType(targetClass);
        if (targetManagedType instanceof EntityType) {
            if (cdoProxy.isPresent() && cdoProxy.get().getLocalId().isPresent()) {
                return this.createInstanceId(cdoProxy.get().getLocalId().get(), targetClass);
            }
            return ((EntityType)targetManagedType).createIdFromInstance(targetCdo);
        }
        if (targetManagedType instanceof ValueObjectType && !this.hasOwner(ownerContext)) {
            return new UnboundedValueObjectId(targetManagedType.getName());
        }
        if (targetManagedType instanceof ValueObjectType && this.hasOwner(ownerContext)) {
            String pathFromRoot = this.createPathFromRoot(ownerContext.getOwnerId(), ownerContext.getPath());
            if (ownerContext.requiresObjectHasher()) {
                pathFromRoot = pathFromRoot + "/" + this.getObjectHasher().hash(cdoProxy.map(p -> p.access()).orElse(targetCdo));
            }
            return new ValueObjectId(targetManagedType.getName(), this.getRootOwnerId(ownerContext), pathFromRoot);
        }
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }

    private GlobalId getRootOwnerId(OwnerContext ownerContext) {
        GlobalId rootOwnerId = ownerContext.getOwnerId() instanceof ValueObjectId ? ((ValueObjectId)ownerContext.getOwnerId()).getOwnerId() : ownerContext.getOwnerId();
        return rootOwnerId;
    }

    private String createPathFromRoot(GlobalId parentId, String fragment) {
        if (parentId instanceof ValueObjectId) {
            return ((ValueObjectId)parentId).getFragment() + "/" + fragment;
        }
        return fragment;
    }

    public UnboundedValueObjectId createUnboundedValueObjectId(Class valueObjectClass) {
        ValueObjectType valueObject = this.typeMapper.getJaversManagedType(valueObjectClass, ValueObjectType.class);
        return new UnboundedValueObjectId(valueObject.getName());
    }

    @Deprecated
    public ValueObjectId createValueObjectIdFromPath(GlobalId owner, String fragment) {
        ManagedType ownerType = this.typeMapper.getJaversManagedType(owner);
        ValueObjectType valueObjectType = this.pathParser.parseChildValueObject(ownerType, fragment);
        return new ValueObjectId(valueObjectType.getName(), owner, fragment);
    }

    public void touchValueObjectFromPath(ManagedType ownerType, String fragment) {
        this.pathParser.parseChildValueObject(ownerType, fragment);
    }

    public InstanceId createInstanceId(Object localId, Class entityClass) {
        EntityType entity = this.typeMapper.getJaversManagedType(entityClass, EntityType.class);
        return entity.createIdFromLocalId(localId);
    }

    public GlobalId createFromDto(GlobalIdDTO globalIdDTO) {
        if (globalIdDTO instanceof InstanceIdDTO) {
            InstanceIdDTO idDTO = (InstanceIdDTO)globalIdDTO;
            return this.createInstanceId(idDTO.getCdoId(), idDTO.getEntity());
        }
        if (globalIdDTO instanceof UnboundedValueObjectIdDTO) {
            UnboundedValueObjectIdDTO idDTO = (UnboundedValueObjectIdDTO)globalIdDTO;
            return this.createUnboundedValueObjectId(idDTO.getVoClass());
        }
        if (globalIdDTO instanceof ValueObjectIdDTO) {
            ValueObjectIdDTO idDTO = (ValueObjectIdDTO)globalIdDTO;
            GlobalId ownerId = this.createFromDto(idDTO.getOwnerIdDTO());
            return this.createValueObjectIdFromPath(ownerId, idDTO.getPath());
        }
        throw new RuntimeException("type " + globalIdDTO.getClass() + " is not implemented");
    }

    public Object dehydrate(Object item, JaversType targetType, OwnerContext context) {
        if (item == null) {
            return null;
        }
        if (!(item instanceof GlobalId) && targetType instanceof ManagedType) {
            return this.createId(item, context);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectHasher getObjectHasher() {
        if (this.objectHasher != null) {
            return this.objectHasher;
        }
        GlobalIdFactory globalIdFactory = this;
        synchronized (globalIdFactory) {
            this.objectHasher = (ObjectHasher)this.picoContainer.getComponent(ObjectHasher.class);
            return this.objectHasher;
        }
    }

    private boolean hasOwner(OwnerContext context) {
        return context != null && context.getOwnerId() != null;
    }
}

