/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;

class DiffBuilder {
    private final List<Change> changes = new ArrayList<Change>();

    private DiffBuilder() {
    }

    public static DiffBuilder diff() {
        return new DiffBuilder();
    }

    public static Diff empty() {
        return new Diff(Collections.emptyList());
    }

    public DiffBuilder addChange(Change change, Optional<Object> affectedCdo) {
        this.addChange(change);
        affectedCdo.ifPresent(change::setAffectedCdo);
        return this;
    }

    public DiffBuilder addChange(Change change) {
        this.changes.add(change);
        return this;
    }

    public DiffBuilder addChanges(Collection<Change> changeSet, Optional<CommitMetadata> commitMetadata) {
        changeSet.forEach(change -> {
            this.addChange((Change)change);
            commitMetadata.ifPresent(it -> change.bindToCommit((CommitMetadata)it));
        });
        return this;
    }

    public Diff build() {
        return new Diff(this.changes);
    }
}

