/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import java.util.Optional;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.object.GlobalId;

public final class ReferenceChange
extends PropertyChange {
    private final GlobalId left;
    private final GlobalId right;
    private final transient Optional<Object> leftObject;
    private final transient Optional<Object> rightObject;

    public ReferenceChange(GlobalId affectedCdoId, String propertyName, GlobalId leftReference, GlobalId rightReference, Object leftObject, Object rightObject) {
        this(affectedCdoId, propertyName, leftReference, rightReference, leftObject, rightObject, Optional.empty());
    }

    public ReferenceChange(GlobalId affectedCdoId, String propertyName, GlobalId leftReference, GlobalId rightReference, Object leftObject, Object rightObject, Optional<CommitMetadata> commitMetadata) {
        super(affectedCdoId, propertyName, commitMetadata);
        this.left = leftReference;
        this.right = rightReference;
        this.leftObject = Optional.ofNullable(leftObject);
        this.rightObject = Optional.ofNullable(rightObject);
    }

    public GlobalId getLeft() {
        return this.left;
    }

    public GlobalId getRight() {
        return this.right;
    }

    public Optional<Object> getLeftObject() {
        return this.leftObject;
    }

    public Optional<Object> getRightObject() {
        return this.rightObject;
    }

    @Override
    protected String fieldsToString(PrettyValuePrinter valuePrinter) {
        return super.fieldsToString(valuePrinter) + " changed from " + valuePrinter.formatWithQuotes(this.getLeft()) + " to " + valuePrinter.formatWithQuotes(this.getRight());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ReferenceChange) {
            ReferenceChange that = (ReferenceChange)obj;
            return super.equals(that) && Objects.equals(this.getLeft(), that.getLeft()) && Objects.equals(this.getRight(), that.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLeft(), this.getRight());
    }
}

