/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype;

import java.util.Objects;
import java.util.Optional;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.Atomic;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.metamodel.object.GlobalId;

public final class ValueChange
extends PropertyChange {
    private final Atomic left;
    private final Atomic right;

    public ValueChange(GlobalId affectedCdoId, String propertyName, Object leftValue, Object rightValue) {
        this(affectedCdoId, propertyName, leftValue, rightValue, Optional.empty());
    }

    public ValueChange(GlobalId affectedCdoId, String propertyName, Object leftValue, Object rightValue, Optional<CommitMetadata> commitMetadata) {
        super(affectedCdoId, propertyName, commitMetadata);
        this.left = new Atomic(leftValue);
        this.right = new Atomic(rightValue);
    }

    public Object getLeft() {
        return this.left.unwrap();
    }

    public Object getRight() {
        return this.right.unwrap();
    }

    @Override
    protected String fieldsToString(PrettyValuePrinter valuePrinter) {
        return super.fieldsToString(valuePrinter) + " changed from " + valuePrinter.formatWithQuotes(this.getLeft()) + " to " + valuePrinter.formatWithQuotes(this.getRight());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ValueChange) {
            ValueChange that = (ValueChange)obj;
            return super.equals(that) && Objects.equals(this.getLeft(), that.getLeft()) && Objects.equals(this.getRight(), that.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLeft(), this.getRight());
    }
}

