/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.GlobalId;

public abstract class ContainerChange
extends PropertyChange {
    private final List<ContainerElementChange> changes;

    ContainerChange(GlobalId affectedCdoId, String propertyName, List<ContainerElementChange> changes, Optional<CommitMetadata> commitMetadata) {
        super(affectedCdoId, propertyName, commitMetadata);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<ContainerElementChange>(changes));
    }

    public List<ContainerElementChange> getChanges() {
        return this.changes;
    }

    public List<ValueAdded> getValueAddedChanges() {
        return Lists.positiveFilter(this.changes, input -> input instanceof ValueAdded);
    }

    public List<ValueRemoved> getValueRemovedChanges() {
        return Lists.positiveFilter(this.changes, input -> input instanceof ValueRemoved);
    }

    public List<?> getAddedValues() {
        return Lists.transform(this.getValueAddedChanges(), input -> input.getAddedValue());
    }

    public List<?> getRemovedValues() {
        return Lists.transform(this.getValueRemovedChanges(), input -> input.getRemovedValue());
    }

    @Override
    protected String fieldsToString(PrettyValuePrinter valuePrinter) {
        StringBuilder changesAsString = new StringBuilder();
        for (ContainerElementChange c : this.changes) {
            if (changesAsString.length() > 0) {
                changesAsString.append("\n  ");
            }
            changesAsString.append(c.prettyPrint(valuePrinter));
        }
        return super.fieldsToString(valuePrinter) + " changes:\n  " + changesAsString;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ContainerChange) {
            ContainerChange that = (ContainerChange)obj;
            return super.equals(that) && Objects.equals(this.changes, that.changes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.changes);
    }
}

