/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.changetype.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.javers.common.collections.Lists;
import org.javers.common.string.PrettyValuePrinter;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChange;
import org.javers.core.metamodel.object.GlobalId;

public class MapChange
extends PropertyChange {
    private final List<EntryChange> changes;

    public MapChange(GlobalId affectedCdoId, String propertyName, List<EntryChange> changes) {
        this(affectedCdoId, propertyName, changes, Optional.empty());
    }

    public MapChange(GlobalId affectedCdoId, String propertyName, List<EntryChange> changes, Optional<CommitMetadata> commitMetadata) {
        super(affectedCdoId, propertyName, commitMetadata);
        Validate.argumentIsNotNull(changes);
        Validate.argumentCheck(!changes.isEmpty(), "changes list should not be empty");
        this.changes = Collections.unmodifiableList(new ArrayList<EntryChange>(changes));
    }

    public List<EntryChange> getEntryChanges() {
        return this.changes;
    }

    public List<EntryAdded> getEntryAddedChanges() {
        return this.filterChanges(EntryAdded.class);
    }

    public List<EntryRemoved> getEntryRemovedChanges() {
        return this.filterChanges(EntryRemoved.class);
    }

    public List<EntryValueChange> getEntryValueChanges() {
        return this.filterChanges(EntryValueChange.class);
    }

    private <T extends EntryChange> List<T> filterChanges(Class<T> ofType) {
        return Lists.positiveFilter(this.changes, input -> ofType.isAssignableFrom(input.getClass()));
    }

    @Override
    protected String fieldsToString(PrettyValuePrinter valuePrinter) {
        StringBuilder changesAsString = new StringBuilder();
        for (EntryChange c : this.changes) {
            if (changesAsString.length() > 0) {
                changesAsString.append("\n  ");
            }
            changesAsString.append(c.prettyPrint(valuePrinter));
        }
        return super.fieldsToString(valuePrinter) + " changes:\n  " + changesAsString;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MapChange) {
            MapChange that = (MapChange)obj;
            return super.equals(that) && Objects.equals(this.changes, that.changes);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.changes);
    }
}

