/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.Edge;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;

public class ObjectNode {
    private final Cdo cdo;
    private final Map<JaversProperty, Edge> edges = new HashMap<JaversProperty, Edge>();

    public ObjectNode(Cdo cdo) {
        Validate.argumentsAreNotNull(cdo);
        this.cdo = cdo;
    }

    public Optional<Object> wrappedCdo() {
        return this.cdo.getWrappedCdo();
    }

    public GlobalId getGlobalId() {
        return this.cdo.getGlobalId();
    }

    public GlobalId getReference(Property property) {
        Edge edge = this.getEdge(property);
        if (edge instanceof AbstractSingleEdge) {
            return ((AbstractSingleEdge)edge).getReference();
        }
        return (GlobalId)this.getPropertyValue(property);
    }

    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        return this.cdo.getPropertyValue(property);
    }

    public boolean isNull(Property property) {
        return this.cdo.isNull(property);
    }

    Edge getEdge(Property property) {
        return this.edges.get(property);
    }

    Edge getEdge(String propertyName) {
        for (JaversProperty p : this.edges.keySet()) {
            if (!p.getName().equals(propertyName)) continue;
            return this.getEdge(p);
        }
        return null;
    }

    void addEdge(Edge edge) {
        this.edges.put(edge.getProperty(), edge);
    }

    public ManagedType getManagedType() {
        return this.cdo.getManagedType();
    }

    public Cdo getCdo() {
        return this.cdo;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectNode that = (ObjectNode)o;
        return this.cdo.equals(that.cdo);
    }

    public int hashCode() {
        return this.cdo.hashCode();
    }
}

