/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.FieldInfo;
import io.github.classgraph.FieldInfoList;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.MethodParameterInfo;
import io.github.classgraph.MethodTypeSignature;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.TypeSignature;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;

class GraphvizDotfileGenerator {
    private static final int PARAM_WRAP_WIDTH = 40;
    private static final char NBSP_CHAR = '\u00a0';
    private static final BitSet IS_UNICODE_WHITESPACE = new BitSet(65536);

    GraphvizDotfileGenerator() {
    }

    private static boolean isUnicodeWhitespace(char c) {
        return IS_UNICODE_WHITESPACE.get(c);
    }

    private static void htmlEncode(CharSequence unsafeStr, boolean turnNewlineIntoBreak, StringBuilder buf) {
        int n = unsafeStr.length();
        block22: for (int i = 0; i < n; ++i) {
            char c = unsafeStr.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block22;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block22;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block22;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block22;
                }
                case '\'': {
                    buf.append("&#x27;");
                    continue block22;
                }
                case '\\': {
                    buf.append("&lsol;");
                    continue block22;
                }
                case '/': {
                    buf.append("&#x2F;");
                    continue block22;
                }
                case '\u2014': {
                    buf.append("&mdash;");
                    continue block22;
                }
                case '\u2013': {
                    buf.append("&ndash;");
                    continue block22;
                }
                case '\u201c': {
                    buf.append("&ldquo;");
                    continue block22;
                }
                case '\u201d': {
                    buf.append("&rdquo;");
                    continue block22;
                }
                case '\u2018': {
                    buf.append("&lsquo;");
                    continue block22;
                }
                case '\u2019': {
                    buf.append("&rsquo;");
                    continue block22;
                }
                case '\u00ab': {
                    buf.append("&laquo;");
                    continue block22;
                }
                case '\u00bb': {
                    buf.append("&raquo;");
                    continue block22;
                }
                case '\u00a3': {
                    buf.append("&pound;");
                    continue block22;
                }
                case '\u00a9': {
                    buf.append("&copy;");
                    continue block22;
                }
                case '\u00ae': {
                    buf.append("&reg;");
                    continue block22;
                }
                case '\u00a0': {
                    buf.append("&nbsp;");
                    continue block22;
                }
                case '\n': {
                    if (turnNewlineIntoBreak) {
                        buf.append("<br>");
                        continue block22;
                    }
                    buf.append(' ');
                    continue block22;
                }
                default: {
                    if (c <= ' ' || GraphvizDotfileGenerator.isUnicodeWhitespace(c)) {
                        buf.append(' ');
                        continue block22;
                    }
                    buf.append(c);
                }
            }
        }
    }

    private static void htmlEncode(CharSequence unsafeStr, StringBuilder buf) {
        GraphvizDotfileGenerator.htmlEncode(unsafeStr, false, buf);
    }

    private static void labelClassNodeHTML(ClassInfo ci, String shape, String boxBgColor, boolean showFields, boolean showMethods, ScanSpec scanSpec, StringBuilder buf) {
        buf.append("[shape=" + shape + ",style=filled,fillcolor=\"#" + boxBgColor + "\",label=");
        buf.append("<");
        buf.append("<table border='0' cellborder='0' cellspacing='1'>");
        buf.append("<tr><td>" + ci.getModifiersStr() + " " + (ci.isEnum() ? "enum" : (ci.isAnnotation() ? "@interface" : (ci.isInterface() ? "interface" : "class"))) + "</td></tr>");
        String className = ci.getName();
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx > 0) {
            buf.append("<tr><td><b>");
            GraphvizDotfileGenerator.htmlEncode(className.substring(0, dotIdx + 1), buf);
            buf.append("</b></td></tr>");
        }
        buf.append("<tr><td><font point-size='24'><b>");
        GraphvizDotfileGenerator.htmlEncode(className.substring(dotIdx + 1), buf);
        buf.append("</b></font></td></tr>");
        float darkness = 0.8f;
        int r = (int)((float)Integer.parseInt(boxBgColor.substring(0, 2), 16) * 0.8f);
        int g = (int)((float)Integer.parseInt(boxBgColor.substring(2, 4), 16) * 0.8f);
        int b = (int)((float)Integer.parseInt(boxBgColor.substring(4, 6), 16) * 0.8f);
        String darkerColor = String.format("#%s%s%s%s%s%s", Integer.toString(r >> 4, 16), Integer.toString(r & 0xF, 16), Integer.toString(g >> 4, 16), Integer.toString(g & 0xF, 16), Integer.toString(b >> 4, 16), Integer.toString(b & 0xF, 16));
        AnnotationInfoList annotationInfo = ci.annotationInfo;
        if (annotationInfo != null && annotationInfo.size() > 0) {
            buf.append("<tr><td colspan='3' bgcolor='" + darkerColor + "'><font point-size='12'><b>ANNOTATIONS</b></font></td></tr>");
            AnnotationInfoList annotationInfoSorted = new AnnotationInfoList(annotationInfo);
            Collections.sort(annotationInfoSorted);
            for (Object ai : annotationInfoSorted) {
                String annotationName = ((AnnotationInfo)ai).getName();
                if (annotationName.startsWith("java.lang.annotation.")) continue;
                buf.append("<tr>");
                buf.append("<td align='center' valign='top'>");
                GraphvizDotfileGenerator.htmlEncode(((AnnotationInfo)ai).toString(), buf);
                buf.append("</td></tr>");
            }
        }
        FieldInfoList fieldInfo = ci.fieldInfo;
        if (showFields && fieldInfo != null && fieldInfo.size() > 0) {
            buf.append("<tr><td colspan='3' bgcolor='" + darkerColor + "'><font point-size='12'><b>" + (scanSpec.ignoreFieldVisibility ? "" : "PUBLIC ") + "FIELDS</b></font></td></tr>");
            buf.append("<tr><td cellpadding='0'>");
            buf.append("<table border='0' cellborder='0'>");
            FieldInfoList fieldInfoSorted = new FieldInfoList(fieldInfo);
            Collections.sort(fieldInfoSorted);
            for (FieldInfo fi : fieldInfoSorted) {
                buf.append("<tr>");
                buf.append("<td align='right' valign='top'>");
                AnnotationInfoList fieldAnnotationInfo = fi.annotationInfo;
                if (fieldAnnotationInfo != null) {
                    for (Object ai : fieldAnnotationInfo) {
                        if (buf.charAt(buf.length() - 1) != ' ') {
                            buf.append(' ');
                        }
                        GraphvizDotfileGenerator.htmlEncode(((AnnotationInfo)ai).toString(), buf);
                    }
                }
                if (scanSpec.ignoreFieldVisibility) {
                    if (buf.charAt(buf.length() - 1) != ' ') {
                        buf.append(' ');
                    }
                    buf.append(fi.getModifierStr());
                }
                if (buf.charAt(buf.length() - 1) != ' ') {
                    buf.append(' ');
                }
                GraphvizDotfileGenerator.htmlEncode(fi.getTypeSignatureOrTypeDescriptor().toString(), buf);
                buf.append("</td>");
                buf.append("<td align='left' valign='top'><b>");
                String fieldName = fi.getName();
                GraphvizDotfileGenerator.htmlEncode(fieldName, buf);
                buf.append("</b></td></tr>");
            }
            buf.append("</table>");
            buf.append("</td></tr>");
        }
        MethodInfoList methodInfo = ci.methodInfo;
        if (showMethods && methodInfo != null && methodInfo.size() > 0) {
            buf.append("<tr><td cellpadding='0'>");
            buf.append("<table border='0' cellborder='0'>");
            buf.append("<tr><td colspan='3' bgcolor='" + darkerColor + "'><font point-size='12'><b>" + (scanSpec.ignoreMethodVisibility ? "" : "PUBLIC ") + "METHODS</b></font></td></tr>");
            MethodInfoList methodInfoSorted = new MethodInfoList(methodInfo);
            Collections.sort(methodInfoSorted);
            for (MethodInfo mi : methodInfoSorted) {
                if (mi.getName().equals("<clinit>")) continue;
                buf.append("<tr>");
                buf.append("<td align='right' valign='top'>");
                AnnotationInfoList methodAnnotationInfo = mi.annotationInfo;
                if (methodAnnotationInfo != null) {
                    for (AnnotationInfo ai : methodAnnotationInfo) {
                        if (buf.charAt(buf.length() - 1) != ' ') {
                            buf.append(' ');
                        }
                        GraphvizDotfileGenerator.htmlEncode(ai.toString(), buf);
                    }
                }
                if (scanSpec.ignoreMethodVisibility) {
                    if (buf.charAt(buf.length() - 1) != ' ') {
                        buf.append(' ');
                    }
                    buf.append(mi.getModifiersStr());
                }
                if (buf.charAt(buf.length() - 1) != ' ') {
                    buf.append(' ');
                }
                if (!mi.getName().equals("<init>")) {
                    GraphvizDotfileGenerator.htmlEncode(mi.getTypeSignatureOrTypeDescriptor().toString(), buf);
                } else {
                    buf.append("<b>&lt;constructor&gt;</b>");
                }
                buf.append("</td>");
                buf.append("<td align='left' valign='top'>");
                buf.append("<b>");
                if (mi.getName().equals("<init>")) {
                    GraphvizDotfileGenerator.htmlEncode(className.substring(className.lastIndexOf(46) + 1), buf);
                } else {
                    GraphvizDotfileGenerator.htmlEncode(mi.getName(), buf);
                }
                buf.append("</b>&nbsp;");
                buf.append("</td>");
                buf.append("<td align='left' valign='top'>");
                buf.append('(');
                MethodParameterInfo[] paramInfo = mi.getParameterInfo();
                if (paramInfo.length != 0) {
                    int wrapPos = 0;
                    for (int i = 0; i < paramInfo.length; ++i) {
                        AnnotationInfo[] paramAnnotationInfo;
                        if (i > 0) {
                            buf.append(", ");
                            wrapPos += 2;
                        }
                        if (wrapPos > 40) {
                            buf.append("</td></tr><tr><td></td><td></td><td align='left' valign='top'>");
                            wrapPos = 0;
                        }
                        if ((paramAnnotationInfo = paramInfo[i].annotationInfo) != null) {
                            for (AnnotationInfo ai : paramAnnotationInfo) {
                                String ais = ai.toString();
                                if (ais.isEmpty()) continue;
                                if (buf.charAt(buf.length() - 1) != ' ') {
                                    buf.append(' ');
                                }
                                GraphvizDotfileGenerator.htmlEncode(ais, buf);
                                if ((wrapPos += 1 + ais.length()) <= 40) continue;
                                buf.append("</td></tr><tr><td></td><td></td><td align='left' valign='top'>");
                                wrapPos = 0;
                            }
                        }
                        String paramTypeStr = paramInfo[i].getTypeSignatureOrTypeDescriptor().toString();
                        GraphvizDotfileGenerator.htmlEncode(paramTypeStr, buf);
                        wrapPos += paramTypeStr.length();
                        String paramName = paramInfo[i].getName();
                        if (paramName == null) continue;
                        buf.append(" <B>");
                        GraphvizDotfileGenerator.htmlEncode(paramName, buf);
                        wrapPos += 1 + paramName.length();
                        buf.append("</B>");
                    }
                }
                buf.append(')');
                buf.append("</td></tr>");
            }
            buf.append("</table>");
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        buf.append(">]");
    }

    static String generateClassGraphDotFile(ClassInfoList classInfoList, float sizeX, float sizeY, boolean showFields, boolean showFieldTypeDependencyEdges, boolean showMethods, boolean showMethodTypeDependencyEdges, boolean showAnnotations, ScanSpec scanSpec) {
        StringBuilder buf = new StringBuilder();
        buf.append("digraph {\n");
        buf.append("size=\"" + sizeX + "," + sizeY + "\";\n");
        buf.append("layout=dot;\n");
        buf.append("rankdir=\"BT\";\n");
        buf.append("overlap=false;\n");
        buf.append("splines=true;\n");
        buf.append("pack=true;\n");
        buf.append("graph [fontname = \"Courier, Regular\"]\n");
        buf.append("node [fontname = \"Courier, Regular\"]\n");
        buf.append("edge [fontname = \"Courier, Regular\"]\n");
        ClassInfoList standardClassNodes = classInfoList.getStandardClasses();
        ClassInfoList interfaceNodes = classInfoList.getInterfaces();
        ClassInfoList annotationNodes = classInfoList.getAnnotations();
        for (ClassInfo node : standardClassNodes) {
            buf.append("\"").append(node.getName()).append("\"");
            GraphvizDotfileGenerator.labelClassNodeHTML(node, "box", "fff2b6", showFields, showMethods, scanSpec, buf);
            buf.append(";\n");
        }
        for (ClassInfo node : interfaceNodes) {
            buf.append("\"").append(node.getName()).append("\"");
            GraphvizDotfileGenerator.labelClassNodeHTML(node, "diamond", "b6e7ff", showFields, showMethods, scanSpec, buf);
            buf.append(";\n");
        }
        for (ClassInfo node : annotationNodes) {
            buf.append("\"").append(node.getName()).append("\"");
            GraphvizDotfileGenerator.labelClassNodeHTML(node, "oval", "f3c9ff", showFields, showMethods, scanSpec, buf);
            buf.append(";\n");
        }
        HashSet allVisibleNodes = new HashSet();
        allVisibleNodes.addAll(standardClassNodes.getNames());
        allVisibleNodes.addAll(interfaceNodes.getNames());
        allVisibleNodes.addAll(annotationNodes.getNames());
        buf.append("\n");
        for (ClassInfo classNode : standardClassNodes) {
            for (ClassInfo directSuperclassNode : classNode.getSuperclasses().directOnly()) {
                if (directSuperclassNode == null || !allVisibleNodes.contains(directSuperclassNode.getName()) || directSuperclassNode.getName().equals("java.lang.Object")) continue;
                buf.append("  \"" + classNode.getName() + "\" -> \"" + directSuperclassNode.getName() + "\" [arrowsize=2.5]\n");
            }
            for (ClassInfo implementedInterfaceNode : classNode.getInterfaces().directOnly()) {
                if (!allVisibleNodes.contains(implementedInterfaceNode.getName())) continue;
                buf.append("  \"" + classNode.getName() + "\" -> \"" + implementedInterfaceNode.getName() + "\" [arrowhead=diamond, arrowsize=2.5]\n");
            }
            if (showFieldTypeDependencyEdges) {
                HashSet<String> referencedFieldTypeNames = new HashSet<String>();
                FieldInfoList fieldInfo = classNode.fieldInfo;
                if (fieldInfo != null) {
                    for (FieldInfo fi : fieldInfo) {
                        TypeSignature fieldSig = fi.getTypeSignatureOrTypeDescriptor();
                        if (fieldSig == null) continue;
                        fieldSig.getClassNamesFromTypeDescriptors(referencedFieldTypeNames);
                    }
                }
                for (String fieldTypeName : referencedFieldTypeNames) {
                    if (!allVisibleNodes.contains(fieldTypeName) || "java.lang.Object".equals(fieldTypeName)) continue;
                    buf.append("  \"" + fieldTypeName + "\" -> \"" + classNode.getName() + "\" [arrowtail=obox, arrowsize=2.5, dir=back]\n");
                }
            }
            if (!showMethodTypeDependencyEdges) continue;
            HashSet<String> referencedMethodTypeNames = new HashSet<String>();
            MethodInfoList methodInfo = classNode.methodInfo;
            if (methodInfo != null) {
                for (MethodInfo mi : methodInfo) {
                    MethodTypeSignature methodSig = mi.getTypeSignatureOrTypeDescriptor();
                    if (methodSig == null) continue;
                    methodSig.getClassNamesFromTypeDescriptors(referencedMethodTypeNames);
                }
            }
            for (String methodTypeName : referencedMethodTypeNames) {
                if (!allVisibleNodes.contains(methodTypeName) || "java.lang.Object".equals(methodTypeName)) continue;
                buf.append("  \"" + methodTypeName + "\" -> \"" + classNode.getName() + "\" [arrowtail=box, arrowsize=2.5, dir=back]\n");
            }
        }
        for (ClassInfo interfaceNode : interfaceNodes) {
            for (ClassInfo superinterfaceNode : interfaceNode.getInterfaces().directOnly()) {
                if (!allVisibleNodes.contains(superinterfaceNode.getName())) continue;
                buf.append("  \"" + interfaceNode.getName() + "\" -> \"" + superinterfaceNode.getName() + "\" [arrowhead=diamond, arrowsize=2.5]\n");
            }
        }
        if (showAnnotations) {
            for (ClassInfo annotationNode : annotationNodes) {
                for (ClassInfo annotatedClassNode : annotationNode.getClassesWithAnnotationDirectOnly()) {
                    if (!allVisibleNodes.contains(annotatedClassNode.getName())) continue;
                    buf.append("  \"" + annotatedClassNode.getName() + "\" -> \"" + annotationNode.getName() + "\" [arrowhead=dot, arrowsize=2.5]\n");
                }
                for (ClassInfo classWithMethodAnnotationNode : annotationNode.getClassesWithMethodAnnotationDirectOnly()) {
                    if (!allVisibleNodes.contains(classWithMethodAnnotationNode.getName())) continue;
                    buf.append("  \"" + classWithMethodAnnotationNode.getName() + "\" -> \"" + annotationNode.getName() + "\" [arrowhead=odot, arrowsize=2.5]\n");
                }
                for (ClassInfo classWithMethodAnnotationNode : annotationNode.getClassesWithFieldAnnotationDirectOnly()) {
                    if (!allVisibleNodes.contains(classWithMethodAnnotationNode.getName())) continue;
                    buf.append("  \"" + classWithMethodAnnotationNode.getName() + "\" -> \"" + annotationNode.getName() + "\" [arrowhead=odot, arrowsize=2.5]\n");
                }
            }
        }
        buf.append("}");
        return buf.toString();
    }

    static {
        String wsChars = "\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000";
        for (int i = 0; i < "\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000".length(); ++i) {
            IS_UNICODE_WHITESPACE.set("\t\n\u000b\f\r \u0085\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u2028\u2029\u202f\u205f\u3000".charAt(i));
        }
    }
}

