/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElementDir;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.ClasspathElementZip;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import io.github.classgraph.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ClasspathElement {
    final ClasspathOrModulePathEntry classpathEltPath;
    List<String> nestedClasspathRootPrefixes;
    boolean skipClasspathElement;
    List<ClasspathOrModulePathEntry> childClasspathElts;
    protected List<Resource> resourceMatches;
    protected List<Resource> whitelistedClassfileResources;
    protected List<Resource> nonBlacklistedClassfileResources;
    protected Map<String, Resource> classNameToNonBlacklistedResource;
    protected Map<File, Long> fileToLastModified;
    protected AtomicBoolean scanned = new AtomicBoolean(false);
    final ScanSpec scanSpec;

    ClasspathElement(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec) {
        this.classpathEltPath = classpathEltPath;
        this.scanSpec = scanSpec;
    }

    public String toString() {
        return this.classpathEltPath.toString();
    }

    String getRawPath() {
        return this.classpathEltPath.getRawPath();
    }

    String getResolvedPath() {
        return this.classpathEltPath.getResolvedPath();
    }

    File getClasspathElementFile(LogNode log) {
        if (this.classpathEltPath.getModuleRef() != null) {
            return null;
        }
        try {
            return this.classpathEltPath.getFile(log);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String getJarfilePackageRoot() {
        return "";
    }

    ClassLoader[] getClassLoaders() {
        return this.classpathEltPath.getClassLoaders();
    }

    ModuleRef getClasspathElementModuleRef() {
        return this.classpathEltPath.getModuleRef();
    }

    static ClasspathElement newInstance(ClasspathOrModulePathEntry classpathRelativePath, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathOrModulePathEntry> workQueue, LogNode log) {
        ClasspathElement newInstance;
        boolean isModule = false;
        boolean isDir = false;
        String resolvedPath = null;
        try {
            resolvedPath = classpathRelativePath.getResolvedPath();
            boolean bl = isModule = classpathRelativePath.getModuleRef() != null;
            if (!isModule) {
                isDir = classpathRelativePath.isDirectory(log);
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathRelativePath.getResolvedPath(), e);
            }
            return null;
        }
        LogNode subLog = null;
        if (log != null) {
            subLog = log.log(resolvedPath, "Scanning " + (isModule ? "module " : (isDir ? "directory " : "jarfile ")) + (isModule ? classpathRelativePath.getModuleRef() + (classpathRelativePath.getModuleRef().getLocationStr() == null ? "" : " -> " + classpathRelativePath.getModuleRef().getLocationStr()) : classpathRelativePath));
        }
        ClasspathElement classpathElement = isModule ? new ClasspathElementModule(classpathRelativePath, scanSpec, nestedJarHandler, subLog) : (newInstance = isDir ? new ClasspathElementDir(classpathRelativePath, scanSpec, subLog) : new ClasspathElementZip(classpathRelativePath, scanSpec, nestedJarHandler, workQueue, subLog));
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return newInstance;
    }

    int getNumClassfileMatches() {
        return this.whitelistedClassfileResources == null ? 0 : this.whitelistedClassfileResources.size();
    }

    static List<Resource> maskClassfiles(ScanSpec scanSpec, int classpathIdx, List<Resource> classfileResources, HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!scanSpec.performScan) {
            throw new IllegalArgumentException("performScan is false");
        }
        BitSet masked = new BitSet(classfileResources.size());
        boolean foundMasked = false;
        for (int i = 0; i < classfileResources.size(); ++i) {
            Resource res = classfileResources.get(i);
            String pathRelativeToPackageRoot = res.getPath();
            if (pathRelativeToPackageRoot.equals("module-info.class") || pathRelativeToPackageRoot.endsWith("/module-info.class") || pathRelativeToPackageRoot.equals("package-info.class") || pathRelativeToPackageRoot.endsWith("/package-info.class") || classpathRelativePathsFound.add(pathRelativeToPackageRoot)) continue;
            masked.set(i);
            foundMasked = true;
            if (log == null) continue;
            log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + JarUtils.classfilePathToClassName(pathRelativeToPackageRoot) + " for classpath element " + res);
        }
        if (!foundMasked) {
            return classfileResources;
        }
        ArrayList<Resource> maskedClassfileResources = new ArrayList<Resource>();
        for (int i = 0; i < classfileResources.size(); ++i) {
            if (masked.get(i)) continue;
            maskedClassfileResources.add(classfileResources.get(i));
        }
        return maskedClassfileResources;
    }

    void maskClassfiles(int classpathIdx, HashSet<String> whitelistedClasspathRelativePathsFound, HashSet<String> nonBlacklistedClasspathRelativePathsFound, LogNode maskLog) {
        this.whitelistedClassfileResources = ClasspathElement.maskClassfiles(this.scanSpec, classpathIdx, this.whitelistedClassfileResources, whitelistedClasspathRelativePathsFound, maskLog);
        this.nonBlacklistedClassfileResources = ClasspathElement.maskClassfiles(this.scanSpec, classpathIdx, this.nonBlacklistedClassfileResources, nonBlacklistedClasspathRelativePathsFound, null);
    }

    protected boolean addResource(Resource resource, ScanSpec.ScanSpecPathMatch parentMatchStatus, LogNode log) {
        boolean isWhitelisted;
        boolean isClassfile;
        String path = resource.getPath();
        boolean bl = isClassfile = this.scanSpec.enableClassInfo && FileUtils.isClassfile(path) && !this.scanSpec.classfilePathWhiteBlackList.isBlacklisted(path);
        if (isClassfile) {
            this.nonBlacklistedClassfileResources.add(resource);
        }
        boolean bl2 = isWhitelisted = parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_WHITELISTED_PATH_PREFIX || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_PATH || parentMatchStatus == ScanSpec.ScanSpecPathMatch.AT_WHITELISTED_CLASS_PACKAGE && this.scanSpec.isSpecificallyWhitelistedClass(path);
        if (isWhitelisted) {
            if (log != null) {
                log.log(path, "Found whitelisted path: " + path);
            }
            if (isClassfile) {
                this.whitelistedClassfileResources.add(resource);
            }
            this.resourceMatches.add(resource);
        } else if (log != null) {
            log.log("Skipping non-whitelisted path: " + path);
        }
        return isWhitelisted;
    }

    abstract void scanPaths(LogNode var1);

    abstract void closeRecyclers();
}

