/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class InputStreamOrByteBufferAdapter {
    private static final int INITIAL_BUFFER_CHUNK_SIZE = 16384;
    private static final int SUBSEQUENT_BUFFER_CHUNK_SIZE = 4096;
    public byte[] buf;
    public int curr = 0;
    public int used = 0;

    private InputStreamOrByteBufferAdapter(byte[] buf) {
        this.buf = buf == null ? new byte[16384] : buf;
    }

    public void readInitialChunk() throws IOException {
        int bytesRead;
        while (this.used < 16384 && (bytesRead = this.read(this.buf, this.used, 16384 - this.used)) != -1) {
            this.used += bytesRead;
        }
    }

    private void readMore(int bytesRequired) throws IOException {
        int bytesRead;
        int extraBytesNeeded = bytesRequired - (this.used - this.curr);
        int bytesToRequest = extraBytesNeeded + 4096;
        int maxNewUsed = this.used + bytesToRequest;
        if (maxNewUsed > this.buf.length) {
            int newBufLen = this.buf.length;
            while (newBufLen < maxNewUsed) {
                if ((newBufLen <<= 1) > 0) continue;
                throw new IOException("Classfile is bigger than 2GB, cannot read it");
            }
            this.buf = Arrays.copyOf(this.buf, newBufLen);
        }
        for (int extraBytesStillNotRead = extraBytesNeeded; extraBytesStillNotRead > 0; extraBytesStillNotRead -= bytesRead) {
            bytesRead = this.read(this.buf, this.used, bytesToRequest);
            if (bytesRead > 0) {
                this.used += bytesRead;
                bytesToRequest -= bytesRead;
                continue;
            }
            throw new IOException("Premature EOF while reading classfile");
        }
    }

    public int readUnsignedByte() throws IOException {
        if (this.curr > this.used - 1) {
            this.readMore(1);
        }
        return this.buf[this.curr++] & 0xFF;
    }

    public int readUnsignedByte(int offset) {
        int bytesToRead = Math.max(0, offset + 1 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return this.buf[offset] & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        if (this.curr > this.used - 2) {
            this.readMore(2);
        }
        int val = (this.buf[this.curr] & 0xFF) << 8 | this.buf[this.curr + 1] & 0xFF;
        this.curr += 2;
        return val;
    }

    public int readUnsignedShort(int offset) {
        int bytesToRead = Math.max(0, offset + 1 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return (this.buf[offset] & 0xFF) << 8 | this.buf[offset + 1] & 0xFF;
    }

    public int readInt() throws IOException {
        if (this.curr > this.used - 4) {
            this.readMore(4);
        }
        int val = (this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF;
        this.curr += 4;
        return val;
    }

    public int readInt(int offset) {
        int bytesToRead = Math.max(0, offset + 4 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return (this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF;
    }

    public long readLong() throws IOException {
        if (this.curr > this.used - 8) {
            this.readMore(8);
        }
        long val = (long)((this.buf[this.curr] & 0xFF) << 24 | (this.buf[this.curr + 1] & 0xFF) << 16 | (this.buf[this.curr + 2] & 0xFF) << 8 | this.buf[this.curr + 3] & 0xFF) << 32 | (long)((this.buf[this.curr + 4] & 0xFF) << 24) | (long)((this.buf[this.curr + 5] & 0xFF) << 16) | (long)((this.buf[this.curr + 6] & 0xFF) << 8) | (long)(this.buf[this.curr + 7] & 0xFF);
        this.curr += 8;
        return val;
    }

    public long readLong(int offset) {
        int bytesToRead = Math.max(0, offset + 8 - this.used);
        if (bytesToRead > 0) {
            throw new IllegalArgumentException("Can only read from absolute offsets before the current location in the file");
        }
        return (long)((this.buf[offset] & 0xFF) << 24 | (this.buf[offset + 1] & 0xFF) << 16 | (this.buf[offset + 2] & 0xFF) << 8 | this.buf[offset + 3] & 0xFF) << 32 | (long)((this.buf[offset + 4] & 0xFF) << 24) | (long)((this.buf[offset + 5] & 0xFF) << 16) | (long)((this.buf[offset + 6] & 0xFF) << 8) | (long)(this.buf[offset + 7] & 0xFF);
    }

    public void skip(int bytesToSkip) throws IOException {
        if (this.curr > this.used - bytesToSkip) {
            this.readMore(bytesToSkip);
        }
        this.curr += bytesToSkip;
    }

    public String readString(int strStart, boolean replaceSlashWithDot, boolean stripLSemicolon) {
        int c;
        int byteIdx;
        int utfLen = this.readUnsignedShort(strStart);
        int utfStart = strStart + 2;
        char[] chars = new char[utfLen];
        int charIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && (c = this.buf[utfStart + byteIdx] & 0xFF) <= 127; ++byteIdx) {
            chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
        }
        block6: while (byteIdx < utfLen) {
            c = this.buf[utfStart + byteIdx] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteIdx;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c == 47 ? 46 : c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((byteIdx += 2) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0x1F) << 6 | c2 & 0x3F;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
                case 14: {
                    if ((byteIdx += 3) > utfLen) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    byte c2 = this.buf[utfStart + byteIdx - 2];
                    byte c3 = this.buf[utfStart + byteIdx - 1];
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new RuntimeException("Bad modified UTF8");
                    }
                    int c4 = (c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0;
                    chars[charIdx++] = (char)(replaceSlashWithDot && c4 == 47 ? 46 : c4);
                    continue block6;
                }
            }
            throw new RuntimeException("Bad modified UTF8");
        }
        if (charIdx == utfLen && !stripLSemicolon) {
            return new String(chars);
        }
        if (stripLSemicolon) {
            if (charIdx < 2 || chars[0] != 'L' || chars[charIdx - 1] != ';') {
                throw new RuntimeException("Expected string to start with 'L' and end with ';', got \"" + new String(chars) + "\"");
            }
            return new String(chars, 1, charIdx - 2);
        }
        return new String(chars, 0, charIdx);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public static InputStreamOrByteBufferAdapter create(final InputStream inputStream) {
        return new InputStreamOrByteBufferAdapter(null){

            @Override
            public int read(byte[] array, int off, int len) throws IOException {
                return inputStream.read(array, off, len);
            }
        };
    }

    public static InputStreamOrByteBufferAdapter create(final ByteBuffer byteBuffer) {
        return new InputStreamOrByteBufferAdapter(byteBuffer.hasArray() ? byteBuffer.array() : null){
            private final boolean hasArray;
            private int bytesRemaining;
            {
                super(buf);
                this.hasArray = byteBuffer.hasArray();
                this.bytesRemaining = this.hasArray ? this.buf.length : -1;
            }

            @Override
            public int read(byte[] array, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                if (this.hasArray) {
                    int bytesToRead = Math.min(len, this.bytesRemaining);
                    if (bytesToRead == 0) {
                        return -1;
                    }
                    this.bytesRemaining -= bytesToRead;
                    return bytesToRead;
                }
                int bytesToRead = Math.min(len, byteBuffer.remaining());
                if (bytesToRead == 0) {
                    return -1;
                }
                int byteBufPositionBefore = byteBuffer.position();
                try {
                    byteBuffer.get(array, off, bytesToRead);
                }
                catch (BufferUnderflowException e) {
                    throw new IOException("Buffer underflow", e);
                }
                return byteBuffer.position() - byteBufPositionBefore;
            }
        };
    }
}

