/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders.levenshtein;

import java.util.List;
import java.util.Objects;
import org.javers.common.validation.Validate;
import org.javers.core.diff.EqualsFunction;
import org.javers.core.diff.appenders.ListChangeAppender;
import org.javers.core.diff.appenders.levenshtein.Backtrack;
import org.javers.core.diff.appenders.levenshtein.BacktrackSteps;
import org.javers.core.diff.appenders.levenshtein.StepsToChanges;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.ListChange;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.TypeMapper;

public class LevenshteinListChangeAppender
extends ListChangeAppender {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    LevenshteinListChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        Validate.argumentsAreNotNull(typeMapper, globalIdFactory);
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public ListChange calculateChanges(Object leftValue, Object rightValue, GlobalId affectedId, JaversProperty property) {
        List rightList;
        PropertyOwnerContext owner;
        JaversType itemType;
        DehydrateContainerFunction dehydrateFunction;
        EqualsFunction equalsFunction = (left, right) -> Objects.equals(left, right);
        StepsToChanges stepsToChanges = new StepsToChanges(equalsFunction);
        Backtrack backtrack = new Backtrack(equalsFunction);
        CollectionType listType = (CollectionType)property.getType();
        List leftList = (List)listType.map(leftValue, dehydrateFunction = new DehydrateContainerFunction(itemType = this.typeMapper.getJaversType(listType.getItemType()), this.globalIdFactory), owner = new PropertyOwnerContext(affectedId, property.getName()));
        BacktrackSteps[][] steps = backtrack.evaluateSteps(leftList, rightList = (List)listType.map(rightValue, dehydrateFunction, owner));
        List<ContainerElementChange> changes = stepsToChanges.convert(steps, leftList, rightList);
        ListChange result = this.getListChange(affectedId, property, changes);
        if (result != null) {
            this.renderNotParametrizedWarningIfNeeded(listType.getItemType(), "item", "List", property);
        }
        return result;
    }

    private ListChange getListChange(GlobalId affectedCdoId, Property property, List<ContainerElementChange> changes) {
        ListChange result = changes.size() == 0 ? null : new ListChange(affectedCdoId, property.getName(), changes);
        return result;
    }
}

