/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.object.DehydrateContainerFunction;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.GlobalIdFactory;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeMapper;

public class SetChangeAppender
extends CorePropertyChangeAppender<SetChange> {
    private final TypeMapper typeMapper;
    private final GlobalIdFactory globalIdFactory;

    SetChangeAppender(TypeMapper typeMapper, GlobalIdFactory globalIdFactory) {
        this.typeMapper = typeMapper;
        this.globalIdFactory = globalIdFactory;
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof SetType;
    }

    List<ContainerElementChange> calculateEntryChanges(CollectionType setType, Collection leftRawSet, Collection rightRawSet, OwnerContext owner) {
        JaversType itemType = this.typeMapper.getJaversType(setType.getItemType());
        DehydrateContainerFunction dehydrateFunction = new DehydrateContainerFunction(itemType, this.globalIdFactory);
        if (Objects.equals(leftRawSet, rightRawSet)) {
            return Collections.emptyList();
        }
        Set leftSet = (Set)setType.map(leftRawSet, dehydrateFunction, owner);
        Set rightSet = (Set)setType.map(rightRawSet, dehydrateFunction, owner);
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        Sets.difference(leftSet, rightSet).forEach(valueOrId -> changes.add(new ValueRemoved(valueOrId)));
        Sets.difference(rightSet, leftSet).forEach(valueOrId -> changes.add(new ValueAdded(valueOrId)));
        return changes;
    }

    @Override
    public SetChange calculateChanges(Object leftValue, Object rightValue, GlobalId affectedId, JaversProperty property) {
        PropertyOwnerContext owner;
        Collection leftValues = (Collection)leftValue;
        Collection rightValues = (Collection)rightValue;
        CollectionType setType = (CollectionType)property.getType();
        List<ContainerElementChange> entryChanges = this.calculateEntryChanges(setType, leftValues, rightValues, owner = new PropertyOwnerContext(affectedId, property.getName()));
        if (!entryChanges.isEmpty()) {
            this.renderNotParametrizedWarningIfNeeded(setType.getItemType(), "item", "Set", property);
            return new SetChange(affectedId, property.getName(), entryChanges);
        }
        return null;
    }
}

