/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.CallStackReader;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.ReflectionUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class ClassLoaderAndModuleFinder {
    private final ClassLoader[] classLoaders;
    private final List<ModuleRef> systemModuleRefs;
    private final List<ModuleRef> nonSystemModuleRefs;

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    private static void findLayerOrder(Object layer, Set<Object> layerVisited, Set<Object> parentLayers, Deque<Object> layerOrderOut) {
        if (layerVisited.add(layer)) {
            List parents = (List)ReflectionUtils.invokeMethod(layer, "parents", true);
            if (parents != null) {
                parentLayers.addAll(parents);
                for (int i = 0; i < parents.size(); ++i) {
                    ClassLoaderAndModuleFinder.findLayerOrder(parents.get(i), layerVisited, parentLayers, layerOrderOut);
                }
            }
            layerOrderOut.push(layer);
        }
    }

    private static List<ModuleRef> findModuleRefs(List<Object> layers, ScanSpec scanSpec, LogNode log) {
        ArrayList<Object> layerOrderFinal;
        if (layers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> layerOrder = new ArrayDeque<Object>();
        HashSet<Object> parentLayers = new HashSet<Object>();
        for (Object object : layers) {
            ClassLoaderAndModuleFinder.findLayerOrder(object, new HashSet<Object>(), parentLayers, layerOrder);
        }
        if (scanSpec.addedModuleLayers != null) {
            for (Object object : scanSpec.addedModuleLayers) {
                ClassLoaderAndModuleFinder.findLayerOrder(object, new HashSet<Object>(), parentLayers, layerOrder);
            }
        }
        if (scanSpec.ignoreParentModuleLayers) {
            layerOrderFinal = new ArrayList();
            for (Object e : layerOrder) {
                if (parentLayers.contains(e)) continue;
                layerOrderFinal.add(e);
            }
        } else {
            layerOrderFinal = new ArrayList<Object>(layerOrder);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object e : layerOrderFinal) {
            Set modules;
            Object configuration = ReflectionUtils.invokeMethod(e, "configuration", true);
            if (configuration == null || (modules = (Set)ReflectionUtils.invokeMethod(configuration, "modules", true)) == null) continue;
            ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
            for (Object module : modules) {
                Object moduleReference = ReflectionUtils.invokeMethod(module, "reference", true);
                if (moduleReference == null || !hashSet.add(moduleReference)) continue;
                try {
                    modulesInLayer.add(new ModuleRef(moduleReference, e));
                }
                catch (Exception e2) {
                    if (log == null) continue;
                    log.log("Exception while creating ModuleRef for module " + moduleReference, e2);
                }
            }
            Collections.sort(modulesInLayer);
            linkedHashSet.addAll(modulesInLayer);
        }
        return new ArrayList<ModuleRef>(linkedHashSet);
    }

    private static List<ModuleRef> findModuleRefs(Class<?>[] callStack, ScanSpec scanSpec, LogNode log) {
        Object bootLayer;
        ArrayList<Object> layers = new ArrayList<Object>();
        for (int i = 0; i < callStack.length; ++i) {
            Object layer;
            Object module = ReflectionUtils.invokeMethod(callStack[i], "getModule", false);
            if (module == null || (layer = ReflectionUtils.invokeMethod(module, "getLayer", true)) == null) continue;
            layers.add(layer);
        }
        Class<?> moduleLayerClass = null;
        try {
            moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        }
        catch (Throwable module) {
            // empty catch block
        }
        if (moduleLayerClass != null && (bootLayer = ReflectionUtils.invokeStaticMethod(moduleLayerClass, "boot", false)) != null) {
            layers.add(bootLayer);
        }
        return ClassLoaderAndModuleFinder.findModuleRefs(layers, scanSpec, log);
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoaderAndModuleFinder(ScanSpec scanSpec, LogNode log) {
        LinkedHashSet<Object> classLoadersUnique;
        LogNode classLoadersFoundLog = null;
        ArrayList<ModuleRef> systemModuleRefs = null;
        ArrayList<ModuleRef> nonSystemModuleRefs = null;
        if (scanSpec.overrideClassLoaders == null) {
            ClassLoader threadClassLoader;
            classLoadersUnique = new LinkedHashSet();
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            if (systemClassLoader != null) {
                classLoadersUnique.add(systemClassLoader);
            }
            List<ModuleRef> allModuleRefsList = null;
            if (scanSpec.overrideModuleLayers == null) {
                try {
                    void var10_12;
                    Class<?>[] callStack = CallStackReader.getClassContext(log);
                    int n = callStack.length - 1;
                    while (var10_12 >= 0) {
                        ClassLoader callerClassLoader = callStack[var10_12].getClassLoader();
                        if (callerClassLoader != null) {
                            classLoadersUnique.add(callerClassLoader);
                        }
                        --var10_12;
                    }
                    allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefs(callStack, scanSpec, log);
                }
                catch (IllegalArgumentException e) {
                    if (log != null) {
                        log.log("Could not get call stack", e);
                    }
                }
            } else {
                if (log != null) {
                    LogNode subLog = log.log("Overriding module layers");
                    for (Object moduleLayer : scanSpec.overrideModuleLayers) {
                        subLog.log(moduleLayer.toString());
                    }
                }
                allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefs(scanSpec.overrideModuleLayers, scanSpec, log);
            }
            if (allModuleRefsList != null) {
                systemModuleRefs = new ArrayList<ModuleRef>();
                nonSystemModuleRefs = new ArrayList<ModuleRef>();
                for (ModuleRef moduleRef : allModuleRefsList) {
                    if (moduleRef.isSystemModule()) {
                        systemModuleRefs.add(moduleRef);
                        continue;
                    }
                    nonSystemModuleRefs.add(moduleRef);
                }
            }
            if ((threadClassLoader = Thread.currentThread().getContextClassLoader()) != null) {
                classLoadersUnique.add(threadClassLoader);
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        HashSet<void> ancestralClassLoaders = new HashSet<void>(classLoadersUnique.size());
        for (Object classLoader : classLoadersUnique) {
            void var10_16;
            ClassLoader classLoader2 = ((ClassLoader)classLoader).getParent();
            while (var10_16 != null) {
                ancestralClassLoaders.add(var10_16);
                ClassLoader classLoader3 = var10_16.getParent();
            }
        }
        ArrayList<Object> classLoaderFinalOrder = new ArrayList<Object>(classLoadersUnique.size());
        for (ClassLoader classLoader : classLoadersUnique) {
            if (ancestralClassLoaders.contains(classLoader)) continue;
            classLoaderFinalOrder.add(classLoader);
        }
        if (scanSpec.overrideClasspath != null) {
            ClassLoader fallbackURLClassLoader = JarUtils.createURLClassLoaderFromPathString(scanSpec.overrideClasspath);
            classLoaderFinalOrder.add(fallbackURLClassLoader);
            if (log != null) {
                log.log("Adding fallback URLClassLoader for overriden classpath: " + fallbackURLClassLoader);
            }
        }
        if (classLoadersFoundLog != null) {
            for (ClassLoader classLoader : classLoaderFinalOrder) {
                classLoadersFoundLog.log("" + classLoader);
            }
        }
        if (log != null) {
            LogNode sysSubLog = log.log("Found system modules:");
            if (systemModuleRefs != null && !systemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : systemModuleRefs) {
                    sysSubLog.log(moduleRef.toString());
                }
            } else {
                sysSubLog.log("[None]");
            }
            LogNode logNode = log.log("Found non-system modules:");
            if (nonSystemModuleRefs != null && !nonSystemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : nonSystemModuleRefs) {
                    logNode.log(moduleRef.toString());
                }
            } else {
                logNode.log("[None]");
            }
        }
        this.classLoaders = classLoaderFinalOrder.toArray(new ClassLoader[0]);
        this.systemModuleRefs = systemModuleRefs;
        this.nonSystemModuleRefs = nonSystemModuleRefs;
    }
}

