/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.VersionFinder;
import io.github.classgraph.utils.VersionedZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarfileMetadataReader {
    public boolean isSystemJar;
    public List<VersionedZipEntry> versionedZipEntries;
    public List<String> classPathEntriesToScan;
    public List<String> strippedPathPrefixes;
    private static final String META_INF_PATH_PREFIX = "META-INF/";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String MULTI_RELEASE_PATH_PREFIX = "META-INF/versions/";
    private static final String VERSIONED_META_INF_PATH_PREFIX = "META-INF/versions/META-INF/";

    private void addClassPathEntryToScan(String classPathEntryPath) {
        if (this.classPathEntriesToScan == null) {
            this.classPathEntriesToScan = new ArrayList<String>();
        }
        this.classPathEntriesToScan.add(classPathEntryPath);
    }

    private String extractManifestField(String manifest, int classPathIdx) {
        int len = manifest.length();
        StringBuilder buf = new StringBuilder();
        int curr = classPathIdx;
        if (curr < len && manifest.charAt(curr) == ' ') {
            ++curr;
        }
        while (curr < len) {
            char c = manifest.charAt(curr);
            if (c == '\r' && (curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) == 10) {
                if ((curr < len - 2 ? (int)manifest.charAt(curr + 2) : 10) != 32) break;
                curr += 2;
            } else if (c == '\r') {
                if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                ++curr;
            } else if (c == '\n') {
                if ((curr < len - 1 ? (int)manifest.charAt(curr + 1) : 10) != 32) break;
                ++curr;
            } else {
                buf.append(c);
            }
            ++curr;
        }
        return buf.toString().trim();
    }

    JarfileMetadataReader(File jarFile, ScanSpec scanSpec, LogNode log) {
        block45: {
            try (ZipFile zipFile = new ZipFile(jarFile);){
                int numEntries = zipFile.size();
                String jarFileName = FastPathResolver.resolve(jarFile.getPath());
                ZipEntry manifestZipEntry = null;
                ArrayList<ZipEntry> zipEntries = new ArrayList<ZipEntry>(zipFile.size());
                Enumeration<? extends ZipEntry> iter = zipFile.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry zipEntry = iter.nextElement();
                    if (zipEntry.isDirectory()) continue;
                    String zipEntryPath = zipEntry.getName();
                    if (zipEntryPath.endsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(0, zipEntryPath.length() - 1);
                    }
                    if (zipEntryPath.startsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(1);
                    }
                    zipEntries.add(zipEntry);
                    if (!zipEntryPath.equals(MANIFEST_PATH) || manifestZipEntry != null) continue;
                    manifestZipEntry = zipEntry;
                }
                boolean isMultiReleaseJar = false;
                String springBootLibPrefix = "BOOT-INF/lib/";
                String springBootClassesPrefix = "BOOT-INF/classes/";
                if (manifestZipEntry != null) {
                    try (InputStream inputStream = zipFile.getInputStream(manifestZipEntry);){
                        int springBootLibIdx;
                        int springBootClassesIdx;
                        String manifest = FileUtils.readAllBytesAsString(inputStream, manifestZipEntry.getSize(), log);
                        String manifestLower = manifest.toLowerCase();
                        this.isSystemJar = manifestLower.indexOf("\nimplementation-title: java runtime environment") >= 0 || manifestLower.indexOf("\nspecification-title: java platform api specification") >= 0 || manifestLower.indexOf("\rimplementation-title: java runtime environment") >= 0 || manifestLower.indexOf("\rspecification-title: java platform api specification") >= 0;
                        int classPathIdx = manifestLower.indexOf("\nclass-path:");
                        if (classPathIdx < 0) {
                            classPathIdx = manifestLower.indexOf("\rclass-path:");
                        }
                        if (classPathIdx >= 0) {
                            String classPathField = this.extractManifestField(manifest, classPathIdx + 12);
                            for (String classpathEntry : classPathField.split(" ")) {
                                if (classpathEntry.isEmpty()) continue;
                                this.addClassPathEntryToScan(classpathEntry);
                            }
                            if (log != null) {
                                log.log("Found Class-Path entry in manifest file: " + classPathField);
                            }
                        }
                        boolean bl = isMultiReleaseJar = manifestLower.indexOf("\nmulti-release: true") >= 0 || manifestLower.indexOf("\rmulti-release: true") >= 0;
                        if (isMultiReleaseJar && log != null) {
                            log.log("This is a multi-release jar");
                        }
                        if ((springBootClassesIdx = manifestLower.indexOf("\nspring-boot-classes:")) < 0) {
                            springBootClassesIdx = manifest.indexOf("\rspring-boot-classes:");
                        }
                        if (springBootClassesIdx >= 0) {
                            springBootClassesPrefix = this.extractManifestField(manifest, springBootClassesIdx + 21);
                            while (springBootClassesPrefix.startsWith("/")) {
                                springBootClassesPrefix = springBootClassesPrefix.substring(1);
                            }
                            if (!springBootClassesPrefix.isEmpty() && !springBootClassesPrefix.endsWith("/")) {
                                springBootClassesPrefix = springBootClassesPrefix + "/";
                            }
                        }
                        if ((springBootLibIdx = manifestLower.indexOf("\nspring-boot-lib:")) < 0) {
                            springBootLibIdx = manifestLower.indexOf("\rspring-boot-lib:");
                        }
                        if (springBootLibIdx >= 0) {
                            springBootLibPrefix = this.extractManifestField(manifest, springBootLibIdx + 17);
                            while (springBootLibPrefix.startsWith("/")) {
                                springBootLibPrefix = springBootLibPrefix.substring(1);
                            }
                            if (!springBootLibPrefix.isEmpty() && !springBootLibPrefix.endsWith("/")) {
                                springBootLibPrefix = springBootLibPrefix + "/";
                            }
                        }
                    }
                }
                ArrayList<VersionedZipEntry> versionedZipEntriesRaw = new ArrayList<VersionedZipEntry>(numEntries);
                for (ZipEntry zipEntry : zipEntries) {
                    String unversionedPath;
                    int nextSlashIdx;
                    String zipEntryPath = zipEntry.getName();
                    if (zipEntryPath.endsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(0, zipEntryPath.length() - 1);
                    }
                    if (zipEntryPath.startsWith("/")) {
                        zipEntryPath = zipEntryPath.substring(1);
                    }
                    if (!isMultiReleaseJar || !zipEntryPath.startsWith(MULTI_RELEASE_PATH_PREFIX) || zipEntryPath.startsWith(VERSIONED_META_INF_PATH_PREFIX)) {
                        versionedZipEntriesRaw.add(new VersionedZipEntry(zipEntry, 8, zipEntryPath));
                        continue;
                    }
                    if (zipEntryPath.length() <= MULTI_RELEASE_PATH_PREFIX.length() + 1 || (nextSlashIdx = zipEntryPath.indexOf(47, MULTI_RELEASE_PATH_PREFIX.length())) <= 0 || (unversionedPath = zipEntryPath.substring(nextSlashIdx + 1)).isEmpty()) continue;
                    String versionStr = zipEntryPath.substring(MULTI_RELEASE_PATH_PREFIX.length(), nextSlashIdx);
                    try {
                        int versionInt = Integer.parseInt(versionStr);
                        if (versionInt < 9 || versionInt > VersionFinder.JAVA_MAJOR_VERSION || zipEntryPath.startsWith(VERSIONED_META_INF_PATH_PREFIX)) continue;
                        isMultiReleaseJar = true;
                        versionedZipEntriesRaw.add(new VersionedZipEntry(zipEntry, versionInt, unversionedPath));
                    }
                    catch (NumberFormatException versionInt) {}
                }
                Collections.sort(versionedZipEntriesRaw);
                ArrayList<VersionedZipEntry> versionedZipEntriesMasked = new ArrayList<VersionedZipEntry>(numEntries);
                HashMap<String, VersionedZipEntry> unversionedPathsEncountered = new HashMap<String, VersionedZipEntry>();
                for (VersionedZipEntry versionedZipEntry : versionedZipEntriesRaw) {
                    if (!unversionedPathsEncountered.containsKey(versionedZipEntry.unversionedPath)) {
                        unversionedPathsEncountered.put(versionedZipEntry.unversionedPath, versionedZipEntry);
                        versionedZipEntriesMasked.add(versionedZipEntry);
                        continue;
                    }
                    if (log == null) continue;
                    log.log(((VersionedZipEntry)unversionedPathsEncountered.get((Object)versionedZipEntry.unversionedPath)).zipEntry.getName() + " masks " + versionedZipEntry.zipEntry.getName());
                }
                this.strippedPathPrefixes = Arrays.asList(springBootClassesPrefix, "WEB-INF/classes/");
                this.versionedZipEntries = new ArrayList<VersionedZipEntry>();
                HashSet<String> strippedPathsEncountered = new HashSet<String>();
                for (VersionedZipEntry versionedZipEntry : versionedZipEntriesMasked) {
                    String unversionedPath;
                    String strippedPath = unversionedPath = versionedZipEntry.unversionedPath;
                    for (String prefixToStrip : this.strippedPathPrefixes) {
                        if (!unversionedPath.startsWith(prefixToStrip)) continue;
                        strippedPath = unversionedPath.substring(prefixToStrip.length());
                        break;
                    }
                    if (!strippedPathsEncountered.add(strippedPath)) continue;
                    this.versionedZipEntries.add(strippedPath.equals(unversionedPath) ? versionedZipEntry : new VersionedZipEntry(versionedZipEntry.zipEntry, versionedZipEntry.version, strippedPath));
                    if (!unversionedPath.startsWith(springBootLibPrefix) && !unversionedPath.startsWith("WEB-INF/lib/") && !unversionedPath.startsWith("WEB-INF/lib-provided/") && !unversionedPath.startsWith("lib/") || !unversionedPath.endsWith(".jar")) continue;
                    if (scanSpec.scanNestedJars) {
                        String zipEntryPath = versionedZipEntry.zipEntry.getName();
                        if (zipEntryPath.endsWith("/")) {
                            zipEntryPath = zipEntryPath.substring(0, zipEntryPath.length() - 1);
                        }
                        if (zipEntryPath.startsWith("/")) {
                            zipEntryPath = zipEntryPath.substring(1);
                        }
                        if (log != null) {
                            log.log("Found lib jar: " + zipEntryPath);
                        }
                        String libJarPath = jarFileName + "!" + zipEntryPath;
                        this.addClassPathEntryToScan(libJarPath);
                        continue;
                    }
                    if (log == null) continue;
                    log.log("Skipping lib jar because nested jar scanning is disabled: " + versionedZipEntry.zipEntry.getName());
                }
                Collections.sort(this.versionedZipEntries);
            }
            catch (IOException e) {
                this.versionedZipEntries = Collections.emptyList();
                if (log == null) break block45;
                log.log("Exception while opening jarfile " + jarFile, e);
            }
        }
    }
}

