/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.classloaderhandler;

import io.github.classgraph.ScanSpec;
import io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import io.github.classgraph.utils.ClasspathOrder;
import io.github.classgraph.utils.LogNode;
import java.net.URL;
import java.net.URLClassLoader;

public class URLClassLoaderHandler
implements ClassLoaderHandler {
    @Override
    public String[] handledClassLoaders() {
        return new String[]{"java.net.URLClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        URL[] urls = ((URLClassLoader)classLoader).getURLs();
        if (urls != null) {
            for (URL url : urls) {
                if (url == null) continue;
                classpathOrderOut.addClasspathElement(url.toString(), classLoader, log);
            }
        }
    }
}

