/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import io.github.classgraph.utils.LogNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

class ClasspathElementDir
extends ClasspathElement {
    private File classpathEltDir;
    private int ignorePrefixLen;
    private final HashSet<String> scannedCanonicalPaths = new HashSet();

    ClasspathElementDir(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec, LogNode log) {
        super(classpathEltPath, scanSpec);
        if (scanSpec.performScan) {
            try {
                this.classpathEltDir = classpathEltPath.getFile(log);
            }
            catch (IOException e) {
                if (log != null) {
                    log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
                }
                this.skipClasspathElement = true;
                return;
            }
            this.ignorePrefixLen = this.classpathEltDir.getPath().length() + 1;
            this.resourceMatches = new ArrayList();
            this.whitelistedClassfileResources = new ArrayList();
            this.nonBlacklistedClassfileResources = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    private Resource newResource(final File classpathEltFile, final String pathRelativeToClasspathElt, final File classpathResourceFile) {
        return new Resource(){
            private RandomAccessFile randomAccessFile;
            private FileChannel fileChannel;
            {
                this.length = classpathResourceFile.length();
            }

            @Override
            public String getPath() {
                return pathRelativeToClasspathElt;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return pathRelativeToClasspathElt;
            }

            @Override
            public URL getURL() {
                try {
                    return new File(classpathEltFile, pathRelativeToClasspathElt).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for dir: " + classpathEltFile + " ; path: " + pathRelativeToClasspathElt);
                }
            }

            @Override
            public URL getClasspathElementURL() {
                try {
                    return this.getClasspathElementFile().toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public File getClasspathElementFile() {
                return ClasspathElementDir.this.classpathEltDir;
            }

            @Override
            public ModuleRef getModuleRef() {
                return null;
            }

            @Override
            public ByteBuffer read() throws IOException {
                if (ClasspathElementDir.this.skipClasspathElement) {
                    throw new IOException("Parent directory could not be opened");
                }
                if (this.byteBuffer != null) {
                    throw new IllegalArgumentException("Resource is already open -- cannot open it again without first calling close()");
                }
                try {
                    this.randomAccessFile = new RandomAccessFile(classpathResourceFile, "r");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    MappedByteBuffer buffer = this.fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.fileChannel.size());
                    buffer.load();
                    this.byteBuffer = buffer;
                    this.length = this.byteBuffer.remaining();
                    return this.byteBuffer;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                    return InputStreamOrByteBufferAdapter.create(this.read());
                }
                this.inputStream = new Resource.InputStreamResourceCloser(this, new FileInputStream(classpathResourceFile));
                return InputStreamOrByteBufferAdapter.create(this.inputStream);
            }

            @Override
            public InputStream open() throws IOException {
                if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                    this.read();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this.byteBufferToInputStream());
                    return this.inputStream;
                }
                this.inputStream = new Resource.InputStreamResourceCloser(this, Files.newInputStream(classpathResourceFile.toPath(), new OpenOption[0]));
                return this.inputStream;
            }

            @Override
            public byte[] load() throws IOException {
                try {
                    byte[] byteArray;
                    if (this.length >= (long)FileUtils.FILECHANNEL_FILE_SIZE_THRESHOLD) {
                        this.read();
                        byteArray = this.byteBufferToByteArray();
                    } else {
                        this.open();
                        byteArray = FileUtils.readAllBytesAsArray(this.inputStream, this.length, null);
                    }
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        InputStream inputStreamWrapper = this.inputStream;
                        this.inputStream = null;
                        inputStreamWrapper.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.byteBuffer != null) {
                    this.byteBuffer = null;
                }
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.fileChannel = null;
                }
                if (this.randomAccessFile != null) {
                    try {
                        this.randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.randomAccessFile = null;
                }
            }
        };
    }

    private void scanDirRecursively(File dir, LogNode log) {
        String dirRelativePath;
        String canonicalPath;
        try {
            canonicalPath = dir.getCanonicalPath();
            if (!this.scannedCanonicalPaths.add(canonicalPath)) {
                if (log != null) {
                    log.log("Reached symlink cycle, stopping recursion: " + dir);
                }
                return;
            }
        }
        catch (IOException | SecurityException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + dir, e);
            }
            return;
        }
        String dirPath = dir.getPath();
        String string = dirRelativePath = this.ignorePrefixLen > dirPath.length() ? "/" : dirPath.substring(this.ignorePrefixLen).replace(File.separatorChar, '/') + "/";
        if (this.nestedClasspathRootPrefixes != null && this.nestedClasspathRootPrefixes.contains(dirRelativePath)) {
            if (log != null) {
                log.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + dirRelativePath);
            }
            return;
        }
        ScanSpec.ScanSpecPathMatch parentMatchStatus = this.scanSpec.dirWhitelistMatchStatus(dirRelativePath);
        if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
            if (log != null) {
                log.log("Reached blacklisted directory, stopping recursive scan: " + dirRelativePath);
            }
            return;
        }
        Object[] filesInDir = dir.listFiles();
        Arrays.sort(filesInDir);
        if (filesInDir == null) {
            if (log != null) {
                log.log("Invalid directory " + dir);
            }
            return;
        }
        LogNode subLog = log == null ? null : log.log(canonicalPath, "Scanning directory: " + dir + (dir.getPath().equals(canonicalPath) ? "" : " ; canonical path: " + canonicalPath));
        for (Object fileInDir : filesInDir) {
            String fileInDirRelativePath;
            Resource resource;
            boolean isWhitelisted;
            if (((File)fileInDir).isDirectory()) {
                this.scanDirRecursively((File)fileInDir, subLog);
                if (subLog == null) continue;
                subLog.addElapsedTime();
                continue;
            }
            if (!((File)fileInDir).isFile() || !(isWhitelisted = this.addResource(resource = this.newResource(this.classpathEltDir, fileInDirRelativePath = dirRelativePath.isEmpty() || "/".equals(dirRelativePath) ? ((File)fileInDir).getName() : dirRelativePath + ((File)fileInDir).getName(), (File)fileInDir), parentMatchStatus, subLog))) continue;
            this.fileToLastModified.put(fileInDir, ((File)fileInDir).lastModified());
        }
        this.fileToLastModified.put(dir, dir.lastModified());
    }

    @Override
    void scanPaths(LogNode log) {
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.toString());
        }
        LogNode logNode = log == null ? null : log.log(this.classpathEltPath.getResolvedPath(), "Scanning directory classpath element " + this.classpathEltPath);
        this.scanDirRecursively(this.classpathEltDir, logNode);
    }

    @Override
    void closeRecyclers() {
    }
}

