/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.FileUtils;
import io.github.classgraph.utils.InputStreamOrByteBufferAdapter;
import io.github.classgraph.utils.JarfileMetadataReader;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import io.github.classgraph.utils.Recycler;
import io.github.classgraph.utils.URLPathEncoder;
import io.github.classgraph.utils.VersionedZipEntry;
import io.github.classgraph.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClasspathElementZip
extends ClasspathElement {
    private File classpathEltZipFile;
    private JarfileMetadataReader jarfileMetadataReader;
    private String packageRootPrefix = "";
    private Recycler<ZipFile, IOException> zipFileRecycler;

    ClasspathElementZip(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathOrModulePathEntry> workQueue, LogNode log) {
        super(classpathEltPath, scanSpec);
        try {
            this.classpathEltZipFile = classpathEltPath.getFile(log);
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathEltPath.getResolvedPath(), e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.classpathEltZipFile == null || !FileUtils.canRead(this.classpathEltZipFile)) {
            if (log != null) {
                log.log("Skipping non-existent jarfile " + classpathEltPath.getResolvedPath());
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            classpathEltPath.getCanonicalPath(log);
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Skipping jarfile " + classpathEltPath.getResolvedPath() + " -- could not canonicalize path : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            this.zipFileRecycler = nestedJarHandler.getZipFileRecycler(this.classpathEltZipFile, log);
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while creating zipfile recycler for " + this.classpathEltZipFile + " : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Exception while creating zipfile recycler for " + this.classpathEltZipFile, e);
            }
            this.skipClasspathElement = true;
            return;
        }
        try {
            this.jarfileMetadataReader = nestedJarHandler.getJarfileMetadataReader(this.classpathEltZipFile, log);
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while reading metadata from " + this.classpathEltZipFile + " : " + e);
            }
            this.skipClasspathElement = true;
            return;
        }
        catch (Exception e) {
            if (log != null) {
                log.log("Exception while reading metadata from " + this.classpathEltZipFile, e);
            }
            this.skipClasspathElement = true;
            return;
        }
        if (this.jarfileMetadataReader == null) {
            this.skipClasspathElement = true;
            return;
        }
        String packageRoot = classpathEltPath.getJarfilePackageRoot();
        while (packageRoot.startsWith("/")) {
            packageRoot = packageRoot.substring(1);
        }
        if (!packageRoot.isEmpty() && !packageRoot.endsWith("/")) {
            packageRoot = packageRoot + "/";
        }
        if (!packageRoot.isEmpty() && !this.jarfileMetadataReader.strippedPathPrefixes.contains(packageRoot)) {
            if (log != null) {
                log.log("Package root within jarfile: " + packageRoot);
            }
            this.packageRootPrefix = packageRoot;
        }
        if (this.jarfileMetadataReader.classPathEntriesToScan != null) {
            String pathOfContainingDir = FastPathResolver.resolve(this.classpathEltZipFile.getParent());
            if (this.childClasspathElts == null) {
                this.childClasspathElts = new ArrayList(this.jarfileMetadataReader.classPathEntriesToScan.size());
            }
            for (int i = 0; i < this.jarfileMetadataReader.classPathEntriesToScan.size(); ++i) {
                String childClassPathEltPath = this.jarfileMetadataReader.classPathEntriesToScan.get(i);
                ClasspathOrModulePathEntry childRelativePath = new ClasspathOrModulePathEntry(pathOfContainingDir, childClassPathEltPath, classpathEltPath.getClassLoaders(), nestedJarHandler, scanSpec, log);
                if (childRelativePath.equals(classpathEltPath)) continue;
                this.childClasspathElts.add(childRelativePath);
            }
            if (!this.childClasspathElts.isEmpty()) {
                if (workQueue != null) {
                    workQueue.addWorkUnits(this.childClasspathElts);
                } else if (log != null) {
                    log.log("Ignoring Class-Path entries in rt.jar: " + this.childClasspathElts);
                }
            }
        }
        if (scanSpec.performScan) {
            this.resourceMatches = new ArrayList();
            this.whitelistedClassfileResources = new ArrayList();
            this.nonBlacklistedClassfileResources = new ArrayList();
            this.fileToLastModified = new HashMap();
        }
    }

    @Override
    String getJarfilePackageRoot() {
        return this.packageRootPrefix;
    }

    private Resource newResource(final File jarFile, final String packageRootPrefix, final String pathRelativeToPackageRoot, final ZipEntry zipEntry) {
        return new Resource(){
            private Recycler.Recyclable zipFileRecyclable;
            private ZipFile zipFile;
            private String pathRelativeToClasspathElt = null;
            {
                this.length = zipEntry.getSize();
            }

            @Override
            public String getPath() {
                return pathRelativeToPackageRoot;
            }

            @Override
            public String getPathRelativeToClasspathElement() {
                return this.pathRelativeToClasspathElt == null ? (this.pathRelativeToClasspathElt = packageRootPrefix + pathRelativeToPackageRoot) : this.pathRelativeToClasspathElt;
            }

            @Override
            public URL getURL() {
                try {
                    return new URL("jar:" + jarFile.toURI().toURL().toString() + "!/" + URLPathEncoder.encodePath(this.getPathRelativeToClasspathElement()));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Could not form URL for jarfile: " + jarFile + " ; path: " + this.pathRelativeToClasspathElt);
                }
            }

            @Override
            public URL getClasspathElementURL() {
                try {
                    return packageRootPrefix.isEmpty() ? this.getClasspathElementFile().toURI().toURL() : new URL("jar:" + this.getClasspathElementFile().toURI().toURL() + "!/" + URLPathEncoder.encodePath(packageRootPrefix));
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }

            @Override
            public File getClasspathElementFile() {
                return ClasspathElementZip.this.classpathEltZipFile;
            }

            @Override
            public ModuleRef getModuleRef() {
                return null;
            }

            @Override
            public InputStream open() throws IOException {
                if (ClasspathElementZip.this.skipClasspathElement) {
                    throw new IOException("Jarfile could not be opened");
                }
                if (this.inputStream != null) {
                    throw new IllegalArgumentException("Resource is already open -- cannot open it again without first calling close()");
                }
                try {
                    this.zipFileRecyclable = ClasspathElementZip.this.zipFileRecycler.acquire();
                    this.zipFile = (ZipFile)this.zipFileRecyclable.get();
                    this.inputStream = new Resource.InputStreamResourceCloser(this, this.zipFile.getInputStream(zipEntry));
                    this.length = zipEntry.getSize();
                    return this.inputStream;
                }
                catch (Exception e) {
                    this.close();
                    throw new IOException("Could not open " + this, e);
                }
            }

            @Override
            InputStreamOrByteBufferAdapter openOrRead() throws IOException {
                return InputStreamOrByteBufferAdapter.create(this.open());
            }

            @Override
            public ByteBuffer read() throws IOException {
                this.open();
                return this.inputStreamToByteBuffer();
            }

            @Override
            public byte[] load() throws IOException {
                try {
                    this.open();
                    byte[] byteArray = this.inputStreamToByteArray();
                    this.length = byteArray.length;
                    byte[] byArray = byteArray;
                    return byArray;
                }
                finally {
                    this.close();
                }
            }

            @Override
            public void close() {
                if (this.inputStream != null) {
                    try {
                        InputStream inputStreamWrapper = this.inputStream;
                        this.inputStream = null;
                        inputStreamWrapper.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.byteBuffer != null) {
                    this.byteBuffer = null;
                }
                if (this.zipFile != null) {
                    this.zipFile = null;
                }
                if (this.zipFileRecyclable != null) {
                    this.zipFileRecyclable.close();
                    this.zipFileRecyclable = null;
                }
            }
        };
    }

    @Override
    void scanPaths(LogNode log) {
        if (this.jarfileMetadataReader == null) {
            this.skipClasspathElement = true;
        }
        if (this.skipClasspathElement) {
            return;
        }
        if (this.scanned.getAndSet(true)) {
            throw new IllegalArgumentException("Already scanned classpath element " + this.toString());
        }
        LogNode subLog = log == null ? null : log.log(this.classpathEltPath.getResolvedPath(), "Scanning jarfile classpath element " + this.classpathEltPath);
        HashSet<String> loggedNestedClasspathRootPrefixes = null;
        String prevParentRelativePath = null;
        ScanSpec.ScanSpecPathMatch prevParentMatchStatus = null;
        for (VersionedZipEntry versionedZipEntry : this.jarfileMetadataReader.versionedZipEntries) {
            int lastSlashIdx;
            String relativePath = versionedZipEntry.unversionedPath;
            if (this.packageRootPrefix.length() != 0 && !relativePath.startsWith(this.packageRootPrefix)) continue;
            relativePath = relativePath.substring(this.packageRootPrefix.length());
            if (this.nestedClasspathRootPrefixes != null) {
                boolean reachedNestedRoot = false;
                for (String nestedClasspathRoot : this.nestedClasspathRootPrefixes) {
                    if (!relativePath.startsWith(nestedClasspathRoot)) continue;
                    if (subLog != null) {
                        if (loggedNestedClasspathRootPrefixes == null) {
                            loggedNestedClasspathRootPrefixes = new HashSet<String>();
                        }
                        if (loggedNestedClasspathRootPrefixes.add(nestedClasspathRoot)) {
                            subLog.log("Reached nested classpath root, stopping recursion to avoid duplicate scanning: " + nestedClasspathRoot);
                        }
                    }
                    reachedNestedRoot = true;
                    break;
                }
                if (reachedNestedRoot) continue;
            }
            String parentRelativePath = (lastSlashIdx = relativePath.lastIndexOf("/")) < 0 ? "/" : relativePath.substring(0, lastSlashIdx + 1);
            boolean parentRelativePathChanged = prevParentRelativePath == null || !parentRelativePath.equals(prevParentRelativePath);
            ScanSpec.ScanSpecPathMatch parentMatchStatus = parentRelativePathChanged ? this.scanSpec.dirWhitelistMatchStatus(parentRelativePath) : prevParentMatchStatus;
            prevParentRelativePath = parentRelativePath;
            prevParentMatchStatus = parentMatchStatus;
            if (parentMatchStatus == ScanSpec.ScanSpecPathMatch.HAS_BLACKLISTED_PATH_PREFIX) {
                if (subLog == null) continue;
                subLog.log("Skipping blacklisted path: " + relativePath);
                continue;
            }
            Resource resource = this.newResource(this.classpathEltZipFile, this.packageRootPrefix, relativePath, versionedZipEntry.zipEntry);
            this.addResource(resource, parentMatchStatus, subLog);
        }
        this.fileToLastModified.put(this.classpathEltZipFile, this.classpathEltZipFile.lastModified());
    }

    @Override
    void closeRecyclers() {
        if (this.zipFileRecycler != null) {
            this.zipFileRecycler.close();
        }
    }
}

