/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.HasName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackageInfo
implements Comparable<PackageInfo>,
HasName {
    private String name;
    private AnnotationInfoList annotationInfo;
    private PackageInfo parent;
    private Set<PackageInfo> children;
    private final Set<ClassInfo> classInfoSet = new HashSet<ClassInfo>();

    PackageInfo() {
    }

    PackageInfo(String packageName) {
        this.name = packageName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void addAnnotations(AnnotationInfoList packageAnnotations) {
        if (packageAnnotations != null && !packageAnnotations.isEmpty()) {
            if (this.annotationInfo == null) {
                this.annotationInfo = new AnnotationInfoList(packageAnnotations);
            } else {
                this.annotationInfo.addAll(packageAnnotations);
            }
        }
    }

    void addClassInfo(ClassInfo classInfo, Map<String, ClassInfo> classNameToClassInfo) {
        this.classInfoSet.add(classInfo);
    }

    public AnnotationInfo getAnnotationInfo(String annotationName) {
        return (AnnotationInfo)this.getAnnotationInfo().get(annotationName);
    }

    public AnnotationInfoList getAnnotationInfo() {
        return this.annotationInfo == null ? AnnotationInfoList.EMPTY_LIST : this.annotationInfo;
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotationInfo().containsName(annotationName);
    }

    public PackageInfo getParent() {
        return this.parent;
    }

    public List<PackageInfo> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<PackageInfo> childrenSorted = new ArrayList<PackageInfo>(this.children);
        Collections.sort(childrenSorted, new Comparator<PackageInfo>(){

            @Override
            public int compare(PackageInfo o1, PackageInfo o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        return childrenSorted;
    }

    public ClassInfo getClassInfo(String className) {
        if (this.classInfoSet == null) {
            return null;
        }
        for (ClassInfo ci : this.classInfoSet) {
            if (!ci.getName().equals(className)) continue;
            return ci;
        }
        return null;
    }

    public ClassInfoList getClassInfo() {
        return new ClassInfoList(this.classInfoSet, true);
    }

    private void getClassInfoRecursive(Set<ClassInfo> reachableClassInfo) {
        reachableClassInfo.addAll(this.classInfoSet);
        for (PackageInfo subPackageInfo : this.getChildren()) {
            subPackageInfo.getClassInfoRecursive(reachableClassInfo);
        }
    }

    public ClassInfoList getClassInfoRecursive() {
        HashSet<ClassInfo> reachableClassInfo = new HashSet<ClassInfo>();
        this.getClassInfoRecursive(reachableClassInfo);
        return new ClassInfoList(reachableClassInfo, true);
    }

    public static PackageInfo getPackage(String packageName, Map<String, PackageInfo> packageNameToPackageInfo) {
        PackageInfo packageInfo = packageNameToPackageInfo.get(packageName);
        if (packageInfo != null) {
            return packageInfo;
        }
        packageInfo = new PackageInfo(packageName);
        packageNameToPackageInfo.put(packageName, packageInfo);
        PackageInfo currPackageInfo = packageInfo;
        while (!currPackageInfo.name.isEmpty()) {
            boolean parentPackageAlreadyExisted;
            int lastDotIdx = currPackageInfo.name.lastIndexOf(46);
            String parentPackageName = lastDotIdx < 0 ? "" : currPackageInfo.name.substring(0, lastDotIdx);
            PackageInfo parentPackageInfo = packageNameToPackageInfo.get(parentPackageName);
            boolean bl = parentPackageAlreadyExisted = parentPackageInfo != null;
            if (!parentPackageAlreadyExisted) {
                parentPackageInfo = new PackageInfo(parentPackageName);
                packageNameToPackageInfo.put(parentPackageName, parentPackageInfo);
                if (currPackageInfo != null) {
                    parentPackageInfo.children = new HashSet<PackageInfo>();
                }
            }
            if (currPackageInfo != null) {
                currPackageInfo.parent = parentPackageInfo;
                parentPackageInfo.children.add(parentPackageInfo);
            }
            if (parentPackageAlreadyExisted) break;
            currPackageInfo = parentPackageInfo;
        }
        return packageInfo;
    }

    @Override
    public int compareTo(PackageInfo o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PackageInfo)) {
            return false;
        }
        return this.name.equals(((PackageInfo)o).name);
    }

    public String toString() {
        return this.name;
    }
}

