/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.classloaderhandler;

import io.github.classgraph.ScanSpec;
import io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import io.github.classgraph.utils.ClasspathOrder;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.ReflectionUtils;
import java.lang.reflect.Array;
import java.util.HashSet;

public class EquinoxClassLoaderHandler
implements ClassLoaderHandler {
    private boolean readSystemBundles = false;

    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.eclipse.osgi.internal.loader.EquinoxClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    private void addBundleFile(Object bundlefile, HashSet<Object> path, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        if (bundlefile != null && path.add(bundlefile)) {
            Object basefile = ReflectionUtils.getFieldVal(bundlefile, "basefile", false);
            if (basefile != null) {
                Object cp = ReflectionUtils.getFieldVal(bundlefile, "cp", false);
                if (cp != null) {
                    classpathOrderOut.addClasspathElement(basefile.toString() + "/" + cp.toString(), classLoader, log);
                } else {
                    classpathOrderOut.addClasspathElement(basefile.toString(), classLoader, log);
                }
            }
            this.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "wrapped", false), path, classLoader, classpathOrderOut, log);
            this.addBundleFile(ReflectionUtils.getFieldVal(bundlefile, "next", false), path, classLoader, classpathOrderOut, log);
        }
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object manager = ReflectionUtils.getFieldVal(classLoader, "manager", false);
        Object entries = ReflectionUtils.getFieldVal(manager, "entries", false);
        if (entries != null) {
            int n = Array.getLength(entries);
            for (int i = 0; i < n; ++i) {
                Object entry = Array.get(entries, i);
                Object bundlefile = ReflectionUtils.getFieldVal(entry, "bundlefile", false);
                this.addBundleFile(bundlefile, new HashSet<Object>(), classLoader, classpathOrderOut, log);
            }
        }
        if (!this.readSystemBundles) {
            Object delegate = ReflectionUtils.getFieldVal(classLoader, "delegate", false);
            Object container = ReflectionUtils.getFieldVal(delegate, "container", false);
            Object storage = ReflectionUtils.getFieldVal(container, "storage", false);
            Object moduleContainer = ReflectionUtils.getFieldVal(storage, "moduleContainer", false);
            Object moduleDatabase = ReflectionUtils.getFieldVal(moduleContainer, "moduleDatabase", false);
            Object modulesById = ReflectionUtils.getFieldVal(moduleDatabase, "modulesById", false);
            Object module0 = ReflectionUtils.invokeMethod(modulesById, "get", Object.class, 0L, false);
            Object bundle = ReflectionUtils.invokeMethod(module0, "getBundle", false);
            Object bundleContext = ReflectionUtils.invokeMethod(bundle, "getBundleContext", false);
            Object bundles = ReflectionUtils.invokeMethod(bundleContext, "getBundles", false);
            if (bundles != null) {
                int n = Array.getLength(bundles);
                for (int i = 0; i < n; ++i) {
                    int fileIdx;
                    Object equinoxBundle = Array.get(bundles, i);
                    Object module = ReflectionUtils.getFieldVal(equinoxBundle, "module", false);
                    String location = (String)ReflectionUtils.getFieldVal(module, "location", false);
                    if (location == null || (fileIdx = location.indexOf("file:")) < 0) continue;
                    location = location.substring(fileIdx);
                    classpathOrderOut.addClasspathElement(location, classLoader, log);
                }
            }
            this.readSystemBundles = true;
        }
    }
}

