/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.classloaderhandler;

import io.github.classgraph.ScanSpec;
import io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import io.github.classgraph.utils.ClasspathOrder;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.ReflectionUtils;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FelixClassLoaderHandler
implements ClassLoaderHandler {
    final Set<Object> bundles = new HashSet<Object>();

    @Override
    public String[] handledClassLoaders() {
        return new String[]{"org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5", "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader"};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    private String getContentLocation(Object content) {
        File file = (File)ReflectionUtils.invokeMethod(content, "getFile", false);
        return file != null ? file.toURI().toString() : null;
    }

    private void addBundle(Object bundleWiring, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        String location;
        this.bundles.add(bundleWiring);
        Object revision = ReflectionUtils.invokeMethod(bundleWiring, "getRevision", false);
        Object content = ReflectionUtils.invokeMethod(revision, "getContent", false);
        String string = location = content != null ? this.getContentLocation(content) : null;
        if (location != null) {
            classpathOrderOut.addClasspathElement(location, classLoader, log);
            List embeddedContent = (List)ReflectionUtils.invokeMethod(revision, "getContentPath", false);
            if (embeddedContent != null) {
                for (Object embedded : embeddedContent) {
                    String embeddedLocation;
                    if (embedded == content || (embeddedLocation = embedded != null ? this.getContentLocation(embedded) : null) == null) continue;
                    classpathOrderOut.addClasspathElement(embeddedLocation, classLoader, log);
                }
            }
        }
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        Object bundleWiring = ReflectionUtils.getFieldVal(classLoader, "m_wiring", false);
        this.addBundle(bundleWiring, classLoader, classpathOrderOut, log);
        List requiredWires = (List)ReflectionUtils.invokeMethod(bundleWiring, "getRequiredWires", String.class, null, false);
        if (requiredWires != null) {
            for (Object wire : requiredWires) {
                Object provider = ReflectionUtils.invokeMethod(wire, "getProviderWiring", false);
                if (this.bundles.contains(provider)) continue;
                this.addBundle(provider, classLoader, classpathOrderOut, log);
            }
        }
    }
}

