/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.utils.InterruptionChecker;
import io.github.classgraph.utils.LogNode;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class WorkQueue<T>
implements AutoCloseable {
    private final WorkUnitProcessor<T> workUnitProcessor;
    private final ConcurrentLinkedQueue<T> workQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger numWorkUnitsRemaining = new AtomicInteger();
    private final AtomicInteger numRunningThreads = new AtomicInteger();
    private final ConcurrentLinkedQueue<Future<?>> workerFutures = new ConcurrentLinkedQueue();
    private final InterruptionChecker interruptionChecker;
    private final LogNode log;

    public static <U> void runWorkQueue(Collection<U> elements, ExecutorService executorService, int numParallelTasks, WorkUnitProcessor<U> workUnitProcessor, InterruptionChecker interruptionChecker, LogNode log) throws ExecutionException, InterruptedException {
        try (WorkQueue<U> workQueue = new WorkQueue<U>(elements, workUnitProcessor, interruptionChecker, log);){
            super.startWorkers(executorService, numParallelTasks - 1, log);
            super.runWorkLoop();
        }
    }

    private WorkQueue(WorkUnitProcessor<T> workUnitProcessor, InterruptionChecker interruptionChecker, LogNode log) {
        this.workUnitProcessor = workUnitProcessor;
        this.interruptionChecker = interruptionChecker;
        this.log = log;
    }

    private WorkQueue(Collection<T> initialWorkUnits, WorkUnitProcessor<T> workUnitProcessor, InterruptionChecker interruptionChecker, LogNode log) {
        this(workUnitProcessor, interruptionChecker, log);
        this.addWorkUnits(initialWorkUnits);
    }

    private void startWorkers(ExecutorService executorService, int numWorkers, LogNode log) {
        for (int i = 0; i < numWorkers; ++i) {
            this.workerFutures.add(executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    WorkQueue.this.runWorkLoop();
                    return null;
                }
            }));
        }
    }

    private void runWorkLoop() throws InterruptedException, ExecutionException {
        while (this.numWorkUnitsRemaining.get() > 0) {
            Object workUnit = null;
            int counter = 0;
            while (this.numWorkUnitsRemaining.get() > 0) {
                if (++counter > 100) {
                    this.interruptionChecker.check();
                }
                if ((workUnit = (Object)this.workQueue.poll()) != null) break;
                Thread.sleep(5L);
            }
            if (workUnit == null) {
                return;
            }
            this.interruptionChecker.check();
            try {
                this.numRunningThreads.incrementAndGet();
                this.workUnitProcessor.processWorkUnit(workUnit, this);
            }
            catch (InterruptedException e) {
                this.interruptionChecker.interrupt();
                throw e;
            }
            catch (Exception e) {
                if (this.log != null) {
                    this.log.log("Exception in worker thread", e);
                }
                if (e.getCause() instanceof InterruptedException) {
                    this.interruptionChecker.interrupt();
                }
                throw this.interruptionChecker.executionException(e);
            }
            finally {
                this.numWorkUnitsRemaining.decrementAndGet();
                this.numRunningThreads.decrementAndGet();
            }
        }
    }

    private void addWorkUnit(T workUnit) {
        this.numWorkUnitsRemaining.incrementAndGet();
        this.workQueue.add(workUnit);
    }

    public void addWorkUnits(Collection<T> workUnits) {
        for (T workUnit : workUnits) {
            this.addWorkUnit(workUnit);
        }
    }

    @Override
    public void close() throws ExecutionException {
        Future<?> future;
        boolean uncompletedWork = false;
        if (this.numWorkUnitsRemaining.get() > 0) {
            uncompletedWork = true;
            if (this.log != null) {
                this.log.log("Some work units not completed");
            }
        }
        while ((future = this.workerFutures.poll()) != null) {
            try {
                if (uncompletedWork) {
                    future.cancel(true);
                }
                future.get();
            }
            catch (InterruptedException | CancellationException exception) {
            }
            catch (ExecutionException e) {
                if (this.log != null) {
                    this.log.log("Closed work queue because worker threw exception", e);
                }
                this.interruptionChecker.executionException(e);
            }
        }
        while (this.numRunningThreads.get() > 0) {
        }
    }

    public static interface WorkUnitProcessor<T> {
        public void processWorkUnit(T var1, WorkQueue<T> var2) throws Exception;
    }
}

