/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Optional;
import java.util.function.Supplier;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.CustomDefinition;
import org.javers.core.metamodel.clazz.EntityDefinition;
import org.javers.core.metamodel.clazz.EntityDefinitionBuilder;
import org.javers.core.metamodel.clazz.IgnoredTypeDefinition;
import org.javers.core.metamodel.clazz.ValueDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinition;
import org.javers.core.metamodel.clazz.ValueObjectDefinitionBuilder;
import org.javers.core.metamodel.scanner.ClassScan;
import org.javers.core.metamodel.scanner.ClassScanner;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.EntityTypeFactory;
import org.javers.core.metamodel.type.IgnoredType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedClassFactory;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TokenType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.core.metamodel.type.ValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(TypeFactory.class);
    private final ClassScanner classScanner;
    private final ManagedClassFactory managedClassFactory;
    private final EntityTypeFactory entityTypeFactory;

    public TypeFactory(ClassScanner classScanner, TypeMapper typeMapper) {
        this.classScanner = classScanner;
        this.managedClassFactory = new ManagedClassFactory(typeMapper);
        this.entityTypeFactory = new EntityTypeFactory(this.managedClassFactory);
    }

    JaversType create(ClientsClassDefinition def) {
        return this.create(def, this.classScanner.scan(def.getBaseJavaClass()));
    }

    JaversType create(ClientsClassDefinition def, ClassScan scan) {
        if (def instanceof CustomDefinition) {
            return new CustomType(def.getBaseJavaClass(), ((CustomDefinition)def).getComparator());
        }
        if (def instanceof EntityDefinition) {
            return this.entityTypeFactory.createEntity((EntityDefinition)def, scan);
        }
        if (def instanceof ValueObjectDefinition) {
            return this.createValueObject((ValueObjectDefinition)def, scan);
        }
        if (def instanceof ValueDefinition) {
            ValueDefinition valueDefinition = (ValueDefinition)def;
            return new ValueType(valueDefinition.getBaseJavaClass(), valueDefinition.getComparator(), valueDefinition.getToStringFunction());
        }
        if (def instanceof IgnoredTypeDefinition) {
            return new IgnoredType(def.getBaseJavaClass());
        }
        throw new IllegalArgumentException("unsupported definition " + def.getClass().getSimpleName());
    }

    private ValueObjectType createValueObject(ValueObjectDefinition definition, ClassScan scan) {
        return new ValueObjectType(this.managedClassFactory.create(definition, scan), definition.getTypeName(), definition.isDefault());
    }

    JaversType infer(Type javaType) {
        return this.infer(javaType, Optional.empty());
    }

    JaversType infer(Type javaType, Optional<JaversType> prototype) {
        JavaRichType javaRichType = new JavaRichType(javaType);
        if (prototype.isPresent()) {
            JaversType jType2 = this.spawnFromPrototype(javaRichType, prototype.get());
            logger.debug("javersType of {} spawned as {} from prototype {}", new Object[]{javaRichType.getSimpleName(), jType2.getClass().getSimpleName(), prototype.get()});
            return jType2;
        }
        return this.inferFromAnnotations(javaRichType).map(jType -> {
            logger.debug("javersType of {} inferred from annotations as {}", javaRichType.getSimpleName(), (Object)jType.getClass().getSimpleName());
            return jType;
        }).orElseGet(() -> {
            logger.debug("javersType of {} defaulted to ValueObjectType", javaRichType.getSimpleName());
            return this.createDefaultType(javaRichType);
        });
    }

    boolean inferredAsEntity(Type javaType) {
        if (javaType instanceof TypeVariable) {
            return false;
        }
        JavaRichType t = new JavaRichType(javaType);
        return t.getScan().hasEntityAnn() || t.getScan().hasIdProperty();
    }

    JaversType inferIdPropertyTypeAsValue(Type idPropertyGenericType) {
        if (idPropertyGenericType instanceof TypeVariable) {
            logger.debug("javersType of {} inferred as TokenType", (Object)idPropertyGenericType);
            return new TokenType((TypeVariable)idPropertyGenericType);
        }
        logger.debug("javersType of {} inferred as ValueType, it's used as id-property type", (Object)idPropertyGenericType);
        return new ValueType(idPropertyGenericType);
    }

    private JaversType spawnFromPrototype(JavaRichType javaRichType, JaversType prototype) {
        Validate.argumentsAreNotNull(javaRichType, prototype);
        if (prototype instanceof ManagedType) {
            ManagedType managedPrototype = (ManagedType)prototype;
            ManagedClass managedClass = this.managedClassFactory.createFromPrototype(javaRichType.javaClass, javaRichType.getScan(), managedPrototype.getManagedClass().getManagedPropertiesFilter());
            return managedPrototype.spawn(managedClass, javaRichType.getScan().typeName());
        }
        if (prototype instanceof CustomType) {
            CustomType customTypePrototype = (CustomType)prototype;
            return new CustomType(customTypePrototype.getBaseJavaType(), customTypePrototype.getComparator());
        }
        return prototype.spawn(javaRichType.javaType);
    }

    private JaversType createDefaultType(JavaRichType t) {
        return this.create(((ValueObjectDefinitionBuilder)ValueObjectDefinitionBuilder.valueObjectDefinition(t.javaClass).withTypeName(t.getScan().typeName())).defaultType().build(), t.getScan());
    }

    private Optional<JaversType> inferFromAnnotations(JavaRichType t) {
        if (t.getScan().hasValueAnn()) {
            return Optional.of(this.create(new ValueDefinition(t.javaClass), t.getScan()));
        }
        if (t.getScan().hasIgnoredAnn()) {
            return Optional.of(this.create(new IgnoredTypeDefinition(t.javaClass), t.getScan()));
        }
        if (t.getScan().hasValueObjectAnn()) {
            return Optional.of(this.create(((ValueObjectDefinitionBuilder)ValueObjectDefinitionBuilder.valueObjectDefinition(t.javaClass).withTypeName(t.getAnnTypeName())).build(), t.getScan()));
        }
        if (t.getScan().hasShallowReferenceAnn()) {
            return Optional.of(this.create(((EntityDefinitionBuilder)EntityDefinitionBuilder.entityDefinition(t.javaClass).withTypeName(t.getAnnTypeName())).withShallowReference().build(), t.getScan()));
        }
        if (t.getScan().hasEntityAnn() || t.getScan().hasIdProperty()) {
            return Optional.of(this.create(((EntityDefinitionBuilder)EntityDefinitionBuilder.entityDefinition(t.javaClass).withTypeName(t.getAnnTypeName())).build(), t.getScan()));
        }
        return Optional.empty();
    }

    private class JavaRichType {
        private Type javaType;
        private Class javaClass;
        private ClassScan scan;
        Supplier<ClassScan> classScan;

        JavaRichType(Type javaType) {
            this.javaType = javaType;
            this.javaClass = ReflectionUtil.extractClass(javaType);
            this.classScan = () -> TypeFactory.this.classScanner.scan(this.javaClass);
        }

        Object getSimpleName() {
            return this.javaClass.getSimpleName();
        }

        ClassScan getScan() {
            if (this.scan == null) {
                this.scan = this.classScan.get();
            }
            return this.scan;
        }

        Optional<String> getAnnTypeName() {
            return this.getScan().typeName();
        }
    }
}

