/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashSet;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.EdgeBuilder;
import org.javers.core.graph.LiveCdo;
import org.javers.core.graph.LiveCdoFactory;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.LiveNode;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ObjectGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ObjectGraphBuilder.class);
    private static final int MAX_VO_HASHING_DEPTH = 1;
    private final TypeMapper typeMapper;
    private boolean built;
    private final EdgeBuilder edgeBuilder;
    private final NodeReuser nodeReuser = new NodeReuser();
    private final LiveCdoFactory cdoFactory;

    ObjectGraphBuilder(TypeMapper typeMapper, LiveCdoFactory cdoFactory) {
        Validate.argumentsAreNotNull(typeMapper, cdoFactory);
        this.typeMapper = typeMapper;
        this.cdoFactory = cdoFactory;
        this.edgeBuilder = new EdgeBuilder(typeMapper, this.nodeReuser, cdoFactory);
    }

    LiveGraph buildGraph(Object handle) {
        Validate.argumentIsNotNull(handle);
        LiveCdo cdo = this.cdoFactory.create(handle, null);
        return this.buildGraphFromCdo(cdo);
    }

    LiveGraph buildGraphFromCdo(LiveCdo cdo) {
        Validate.argumentIsNotNull(cdo);
        LiveNode root = this.edgeBuilder.buildNodeStub(cdo);
        while (this.nodeReuser.hasMoreStubs()) {
            LiveNode stub = this.nodeReuser.pollStub();
            this.buildEdges(stub);
        }
        logger.debug("live graph assembled, object nodes: {}, entities: {}, valueObjects: {}", new Object[]{this.nodeReuser.nodesCount(), this.nodeReuser.entitiesCount(), this.nodeReuser.voCount()});
        List<LiveNode> nodes = this.nodeReuser.nodes();
        this.enrichHashes(nodes);
        this.switchToBuilt();
        return new LiveGraph(root, new HashSet<ObjectNode<LiveCdo>>(nodes));
    }

    private void enrichHashes(List<LiveNode> nodes) {
        nodes.forEach(this::enrichHashIfNeeded);
        nodes.forEach(this::reloadHashFromParentIfNeeded);
    }

    private void enrichHashIfNeeded(LiveNode node) {
        ((LiveCdo)node.getCdo()).enrichHashIfNeeded(this.cdoFactory, () -> node.descendants(1));
    }

    private void reloadHashFromParentIfNeeded(LiveNode node) {
        ((LiveCdo)node.getCdo()).reloadHashFromParentIfNeeded(this.cdoFactory);
    }

    private void buildEdges(LiveNode nodeStub) {
        this.nodeReuser.saveForReuse(nodeStub);
        this.buildSingleEdges(nodeStub);
        this.buildMultiEdges(nodeStub);
    }

    private void buildSingleEdges(LiveNode node) {
        for (JaversProperty singleRef : this.getSingleReferencesWithManagedTypes(node.getManagedType())) {
            if (node.isNull(singleRef)) continue;
            AbstractSingleEdge edge = this.edgeBuilder.buildSingleEdge(node, singleRef);
            node.addEdge(edge);
        }
    }

    private void buildMultiEdges(LiveNode node) {
        for (JaversProperty containerProperty : this.getNonEmptyEnumerablesWithManagedTypes(node)) {
            EnumerableType enumerableType = (EnumerableType)containerProperty.getType();
            MultiEdge multiEdge = this.edgeBuilder.createMultiEdge(containerProperty, enumerableType, node);
            node.addEdge(multiEdge);
        }
    }

    private void switchToBuilt() {
        if (this.built) {
            throw new IllegalStateException("ObjectGraphBuilder is a stateful builder (not a Service)");
        }
        this.built = true;
    }

    private List<JaversProperty> getSingleReferencesWithManagedTypes(ManagedType managedType) {
        return managedType.getProperties(property -> property.getType() instanceof ManagedType);
    }

    private List<JaversProperty> getNonEmptyEnumerablesWithManagedTypes(LiveNode node) {
        return node.getManagedType().getProperties(property -> {
            Object container;
            if (!(property.getType() instanceof EnumerableType)) {
                return false;
            }
            EnumerableType enumerableType = (EnumerableType)property.getType();
            if (enumerableType.isEmpty(container = node.getPropertyValue((Property)property))) {
                return false;
            }
            if (node.isNull((Property)property)) {
                return false;
            }
            return this.typeMapper.isContainerOfManagedTypes(enumerableType) || this.typeMapper.isKeyValueTypeWithManagedTypes(enumerableType);
        });
    }
}

